% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_batch_api.R
\name{anthropic_create_batch}
\alias{anthropic_create_batch}
\title{Create an Anthropic Message Batch}
\usage{
anthropic_create_batch(
  requests,
  api_key = Sys.getenv("ANTHROPIC_API_KEY"),
  anthropic_version = "2023-06-01"
)
}
\arguments{
\item{requests}{List of request objects, each of the form
\code{list(custom_id = <chr>, params = <list>)}. You can obtain this
list from the output of \code{\link{build_anthropic_batch_requests}} via
\code{split} / \code{Map}, or use \code{run_anthropic_batch_pipeline}.}

\item{api_key}{Optional Anthropic API key. Defaults to
\code{Sys.getenv("ANTHROPIC_API_KEY")}.}

\item{anthropic_version}{Anthropic API version string passed as the
\code{anthropic-version} HTTP header. Defaults to \code{"2023-06-01"}.}
}
\value{
A list representing the Message Batch object returned by Anthropic.
Important fields include \code{id}, \code{processing_status},
\code{request_counts}, and (after completion) \code{results_url}.
}
\description{
This is a thin wrapper around Anthropic's
\code{/v1/messages/batches} endpoint. It accepts a list of request
objects (each with \code{custom_id} and \code{params}) and returns the
resulting Message Batch object.
}
\details{
Typically you will not call this directly; instead, use
\code{\link{run_anthropic_batch_pipeline}} which builds requests from a
tibble of pairs, creates the batch, polls for completion, and downloads
the results.
}
\examples{
\dontrun{
# Requires ANTHROPIC_API_KEY and network access.
library(pairwiseLLM)

data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 2, seed = 123) |>
  randomize_pair_order(seed = 456)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

req_tbl <- build_anthropic_batch_requests(
  pairs             = pairs,
  model             = "claude-sonnet-4-5",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl
)

requests <- lapply(seq_len(nrow(req_tbl)), function(i) {
  list(
    custom_id = req_tbl$custom_id[i],
    params    = req_tbl$params[[i]]
  )
})

batch <- anthropic_create_batch(requests = requests)
batch$id
batch$processing_status
}

}
