% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt_template.R
\name{remove_prompt_template}
\alias{remove_prompt_template}
\title{Remove a registered prompt template}
\usage{
remove_prompt_template(name, quiet = FALSE)
}
\arguments{
\item{name}{Character scalar; name of the template to remove.}

\item{quiet}{Logical; if \code{FALSE} (default), an error is thrown
when \code{name} is not found in the user registry. When
\code{TRUE}, the function simply returns \code{FALSE} in that
case.}
}
\value{
Invisibly, \code{TRUE} if a template was removed,
\code{FALSE} otherwise.
}
\description{
This function removes a template from the user registry created by
\code{\link{register_prompt_template}}. It does not affect built-in
templates stored under \code{inst/templates}.
}
\examples{
# Register and then remove a template
register_prompt_template("to_delete", template = set_prompt_template())
remove_prompt_template("to_delete")

}
\seealso{
\code{\link{register_prompt_template}},
\code{\link{get_prompt_template}},
\code{\link{list_prompt_templates}}
}
