% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hill.N2.core.R
\name{Hill.N2.core}
\alias{Hill.N2.core}
\title{Calculate the effective number of species in the fossil data}
\usage{
Hill.N2.core(spp)
}
\arguments{
\item{spp}{data.frame of Species data}
}
\value{
Minimum, first quartile and median effective number of species
}
\description{
Gives a measure of the species diversity in the fossil data.
}
\details{
Uses \code{\link[rioja:utils]{rioja::Hill.N2()}} from the rioja package.
}
\note{
If the effective number of species is small, WA based reconstructions are
unlikely to be significant, and MAT based reconstructions should be tested
instead.
}
\examples{
require(rioja)
data(RLGH)
Hill.N2.core(RLGH$spec)
}
\references{
Hill, M. O. (1973) Diversity and evenness: a unifying notation and its
consequences. \emph{Ecology} \bold{54}: 427--432.
}
\seealso{
\code{\link[rioja:utils]{rioja::Hill.N2()}}
}
\author{
Richard Telford
}
\keyword{attribute}
