% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_species.r
\name{make.set}
\alias{make.set}
\title{Simulate species data sets}
\usage{
make.set(ndim, n, elen, emean, edistr, ecor, cnt, spec, env, ...)
}
\arguments{
\item{ndim}{Number of environmental variables to generate.}

\item{n}{Number of samples to be generated.}

\item{elen}{Range of the environmental variables.
Single number or vector of length \code{ndim}.}

\item{emean}{Mean of the environmental variables.
Single number or vector of length \code{ndim}.}

\item{edistr}{Distribution of the environmental variables.
Currently 'uniform' and 'Gaussian' are supported.}

\item{ecor}{Correlation matrix of the environmental variables.
Object generated by \code{\link{cor.mat.fun}}.
If omitted environmental variables are uncorrelated.}

\item{cnt}{Count sum to be simulated.}

\item{spec}{Users may supply their own species parameters.}

\item{env}{Users may supply their own environmental variables.}

\item{\dots}{Arguments passed to \code{\link{species}}}
}
\value{
List with three elements:
\item{spp}{ Species abundance data.}
\item{env}{ Environmental variables used to simulate species abundance data.}
\item{spec}{ Species parameters.}
}
\description{
Function to simulate species data following Minchin (1987).
This functions generates species response functions,
simulates environmental variables and simulates species assemblages
based on species response functions and environmental variables.
Users can supply own species parameters
(e.g. when simulating calibration and fossil datasets) and
own environmental variables.
}
\examples{
calib <- make.set(
  nspp = 90, ndim = 3, Amax = runif, fun = runif,
  xpar = c(-50, 150), srange = 400, alpha = 4, gamma = 4,
  n = 100, elen = rep(100, 3), emean = rep(50, 3),
  edistr = "uniform", cnt = 1000
)

# Provide species parameters generated above, so that the fossil data use the
#    same species parameters.
fos <- make.set(
  ndim = 3, n = 100, elen = rep(100, 3), emean = rep(50, 3),
  edistr = "uniform", cnt = 1000, spec = calib$spec
)

# Supplying own environmental variables and species parameters.
env.vars <- make.env(100,
  elen = rep(100, 3), emean = rep(50, 3),
  edistr = "uniform", ndim = 3
)
fos <- make.set(cnt = 1000, spec = calib$spec, env = env.vars)

}
\references{
Minchin, P.R. (1987) Multidimensional Community Patterns:
Towards a Comprehensive Model. \emph{Vegetatio}, \strong{71}, 145-156.
\doi{10.1007/BF00039167}
}
\seealso{
\code{\link{make.env}}, \code{\link{species}},
\code{\link{cor.mat.fun}}
}
\author{
Mathias Trachsel and Richard J. Telford
}
\keyword{datagen}
