% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pald_functions.R
\name{local_depths}
\alias{local_depths}
\title{Local (Community) Depths}
\usage{
local_depths(d)
}
\arguments{
\item{d}{A matrix of pairwise distances, a \code{\link{dist}} object, or a
\code{\link{cohesion_matrix}} object.}
}
\value{
A vector of local depths.
}
\description{
Creates a vector of local depths from a matrix of distances (or \code{dist}
object).
}
\details{
Local depth is an interpretable probability which reflects aspects of
relative position and centrality via distance comparisons
(i.e., d(z, x) < d(z, y)).

The average of the local depth values is always 1/2.  Cohesion is
partitioned local depth (see \code{\link{cohesion_matrix}}); the row-sums of the
cohesion matrix are the values of local depth.
}
\examples{

D <- dist(exdata1)
local_depths(D)
C <- cohesion_matrix(D)
local_depths(C)

## local depths are the row sums of the cohesion matrix
rowSums(C)

## cognate distance data

ld_lang <- sort(local_depths(cognate_dist))
}
