% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_strata}
\alias{pbdb_strata}
\title{Get information about geological strata}
\usage{
pbdb_strata(...)
}
\arguments{
\item{...}{Arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/strata/list}. E.g.:
\itemize{
\item \code{name}: A full or partial name. You can use \% and _ as wildcards.
\item \code{rank}: Returns only strata of the specified rank: \code{"formation"},
\code{"group"} or \code{"member"}.
\item \code{lngmin}: Numeric. The longitude boundaries will be normalized to
fall between -180 and 180. Note that if you specify \code{lngmin} then
you must also specify \code{lngmax}. Returns only records whose
geographic location falls within the given bounding box (defined
by \code{lngmin}, \code{lngmax}, \code{latmin}, \code{latmax}). It generates two
adjacent bounding boxes if the range crosses the antimeridian.
\item \code{lngmax}: Numeric. The longitude boundaries will be normalized to
fall between -180 and 180.
\item \code{latmin}: Numeric between -90 and 90. Note that if you specify
\code{latmin} then you must also specify \code{latmax}.
\item \code{latmax}: Numeric between -90 and 90.
\item \code{loc}: Return only strata associated with some occurrence whose
geographic location falls within the specified geometry,
specified in WKT format.
\item \code{vocab}: Set to \code{"pbdb"} to show the complete name of the
variables (by default variables have short 3-letter names).
}}
}
\value{
A data frame with information from the selected strata.
}
\description{
Returns information about geological strata, selected by name,
rank, and/or geographic location.
}
\examples{
\dontrun{
  pbdb_strata(
    lngmin = 0, lngmax = 15, latmin = 0, latmax = 15,
    rank = "formation", vocab = "pbdb"
  )
}
}
