% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_masked.R
\name{masked_preload}
\alias{masked_preload}
\title{Preloads a masked language model}
\usage{
masked_preload(
  model = getOption("pangoling.masked.default"),
  add_special_tokens = NULL,
  config_model = NULL,
  config_tokenizer = NULL
)
}
\arguments{
\item{model}{Name of a pre-trained model or folder. One should be able to use
models based on "bert". See
\href{https://huggingface.co/models?other=bert}{hugging face website}.}

\item{add_special_tokens}{Whether to include special tokens. It has the
same default as the
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoTokenizer}{AutoTokenizer}
method in Python.}

\item{config_model}{List with other arguments that control how the
model from Hugging Face is accessed.}

\item{config_tokenizer}{List with other arguments that control how the
tokenizer from Hugging Face is accessed.}
}
\value{
Nothing.
}
\description{
Preloads a masked language model to speed up next runs.
}
\details{
A masked language model (also called BERT-like, or encoder model) is a type
of large language model  that can be used to predict the content of a mask
in a sentence.

If not specified, the masked model that will be used is the one set in
specified in the global option \code{pangoling.masked.default}, this can be
accessed via \code{getOption("pangoling.masked.default")} (by default
"bert-base-uncased"). To change the default option
use \code{options(pangoling.masked.default = "newmaskedmodel")}.

A list of possible masked can be found in
\href{https://huggingface.co/models?pipeline_tag=fill-mask}{Hugging Face website}

Using the  \code{config_model} and \code{config_tokenizer} arguments, it's possible to
control how the model and tokenizer from Hugging Face is accessed, see the
python method
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoProcessor.from_pretrained}{\code{from_pretrained}}
for details. In case of errors check the status of
\url{https://status.huggingface.co/}
}
\examples{
\dontshow{if (installed_py_pangoling()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
causal_preload(model = "bert-base-uncased")
\dontshow{\}) # examplesIf}
}
\seealso{
Other masked model helper functions: 
\code{\link{masked_config}()}
}
\concept{masked model helper functions}
