% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st.R
\name{moment_st}
\alias{moment_st}
\title{Moments of Skew-\eqn{t} Distribution}
\usage{
moment_st(xi = 0, omega = 1, alpha = 0, nu = Inf)
}
\arguments{
\item{xi}{\link[base]{numeric} scalar or \link[base]{vector},
location parameter \eqn{\xi}}

\item{omega}{\link[base]{numeric} scalar or \link[base]{vector},
scale parameter \eqn{\omega}}

\item{alpha}{\link[base]{numeric} scalar or \link[base]{vector},
slant parameter \eqn{\alpha}}

\item{nu}{\link[base]{numeric} scalar or \link[base]{vector},
degree of freedom \eqn{\nu}}
}
\value{
Function \code{\link[=moment_st]{moment_st()}} returns a \linkS4class{moment} object.
}
\description{
Moments of skew-\eqn{t} distribution, parameter nomenclature follows
\link[sn]{dst} function.
}
\examples{
xi = 2; omega = 1.3; alpha = 3; nu = 6
curve(sn::dst(x, xi = xi, omega = omega, alpha = alpha, nu = nu), from = 0, to = 6)
moment_st(xi, omega, alpha, nu)

}
\references{
Raw moments of skew-\eqn{t}: \url{https://arxiv.org/abs/0911.2342}
}
