% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sn.R
\name{moment_sn}
\alias{moment_sn}
\title{Moments of Skew-Normal Distribution}
\usage{
moment_sn(xi = 0, omega = 1, alpha = 0)
}
\arguments{
\item{xi}{\link[base]{numeric} scalar or \link[base]{vector},
location parameter \eqn{\xi}}

\item{omega}{\link[base]{numeric} scalar or \link[base]{vector},
scale parameter \eqn{\omega}}

\item{alpha}{\link[base]{numeric} scalar or \link[base]{vector},
slant parameter \eqn{\alpha}}
}
\value{
Function \code{\link[=moment_sn]{moment_sn()}} returns a \linkS4class{moment} object.
}
\description{
Moments of \href{https://en.wikipedia.org/wiki/Skew_normal_distribution}{skew-normal distribution}, parameter nomenclature follows
\link[sn]{dsn} function.
}
\examples{
xi = 2; omega = 1.3; alpha = 3
moment_sn(xi, omega, alpha)
curve(sn::dsn(x, xi = 2, omega = 1.3, alpha = 3), from = 0, to = 6)

}
