% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.linkdat.R
\name{as.data.frame.linkdat}
\alias{as.data.frame.linkdat}
\title{linkdat to data.frame conversion}
\usage{
\method{as.data.frame}{linkdat}(
  x,
  ...,
  famid = F,
  markers = seq_len(x$nMark),
  alleles = NULL,
  missing = NULL,
  singleCol = FALSE,
  sep = ""
)
}
\arguments{
\item{x}{a \code{\link{linkdat}} object.}

\item{\dots}{further arguments (not used).}

\item{famid}{a logical indicating if the family identifier should be included
as the first column.}

\item{markers}{a numeric indicating which markers should be included/printed.}

\item{alleles}{a character containing allele names, e.g.
\code{alleles=c('A','B')}.}

\item{missing}{the character (of length 1) used for missing alleles. Defaults
to '0'.}

\item{singleCol}{a logical: Should the two alleles for each marker be pasted
into one column or kept in separate columns?}

\item{sep}{a single character to be used as allele separator if
\code{singleCol=TRUE}.}
}
\value{
A \code{data.frame}.
}
\description{
Convert a linkdat object to data.frame for pretty printing.
}
\details{
This function is mainly intended for pretty-printing \code{linkdat} objects
(for instance it is called by \code{print.linkdat}). For direct manipulation
of the pedigree and/or marker matrices, it is better to use
\code{\link{as.matrix.linkdat}}.
}
\examples{

x = linkdat(toyped)
x

# Printing x as above is equivalent to:
as.data.frame(x, sep = '/', missing = '-', singleCol = TRUE)

}
\seealso{
\code{\link{as.matrix.linkdat}}
}
