% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{literal}
\alias{literal}
\title{Matching parser input with a literal string}
\usage{
literal(string)
}
\arguments{
\item{string}{string, a single-element character vector, or an object that
can be coerced to a character vector.}
}
\value{
A parser.
}
\description{
\code{literal} tests whether a supplied string literally equals a desired value.
}
\section{Pseudocode}{

\preformatted{
literal(a)(x): satisfy(F(y): y==a)(x)
}

where \code{F} is equivalent to the \code{function} declarator in R. So, we have an
anonymous function in the argument of \code{satisfy}.
}

\examples{
literal("ab") (c("ab", "cdef")) # success
literal("ab") (c("abc", "cdef")) # failure

}
