% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{finders}
\alias{finders}
\alias{find_whitespace}
\alias{find_env}
\alias{find_macro}
\alias{find_catcode}
\alias{find_tags}
\alias{find_char}
\alias{find_block}
\alias{find_general}
\title{Miscellaneous low-level finders}
\usage{
find_whitespace(items, ...)

find_env(items, envtypes = NULL, ...)

find_macro(items, macros = NULL, ...)

find_catcode(items, codes, ...)

find_tags(items, tags, ...)

find_char(items, char, ...)

find_block(items, ...)

find_general(items, test, ..., all = TRUE, path = FALSE)
}
\arguments{
\item{items}{A list of latex items.}

\item{...}{For \code{find_general}, additional arguments
to pass to \code{test}.  For the other \verb{find_*} functions,
additional arguments to pass to \code{find_general}.}

\item{envtypes}{Which types of environment to look for.}

\item{macros}{Which types of macros to look for.}

\item{codes}{Which codes to look for.}

\item{tags}{Which tags to look for.}

\item{char}{Which character to look for.}

\item{test}{Test function for target.}

\item{all}{If \code{FALSE}, return just the first match}

\item{path}{If \code{TRUE}, return a path rather than an index.  See Details below.}
}
\value{
\code{find_whitespace()} returns the indices of
whitespace in \code{items}.

\code{find_env()} returns the indices within \code{items}
of environments in \code{envtypes}.

\code{find_macro()} returns the index within \code{items}
of instances in \code{macros}.

\code{find_catcode()} returns the index within \code{items}.
of specials matching \code{code}.

\code{find_tags()} returns the index within \code{items}.
of items with tags matching \code{tags}.

\code{find_char()} returns the index within \code{items}
of characters matching \code{char}.  Only characters
marked as SPECIAL by the parser will be found.

\code{find_block()} returns the index within \code{items}
of blocks (i.e. sequences in {})

\code{find_general()} returns locations of
objects matching the \code{test}.
}
\description{
Miscellaneous low-level finders
}
\details{
These functions search through \code{items} for individual
objects that match a test.  In general they do not
operate recursively, with one exception.  If \code{items}
contains \code{ITEMLIST} objects, the search will always
recurse into those.

By default the return value is an index or a vector
of indices of the matches.  These are the indices as
they would be if any \code{ITEMLIST} objects had been
flattened.

However, if \code{path = TRUE}, the path to the
object will be returned.  With \code{all = FALSE}, this will
be a numeric vector such that \code{items[[result]]} is the
matching item.  With \code{all = TRUE} it will be a list of
such vectors.
}
\seealso{
\code{\link[=index_to_path]{index_to_path()}}, \code{\link[=path_to_index]{path_to_index()}}
}
