% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_inline_code_utils.R
\name{inline_code_utils}
\alias{inline_code_utils}
\alias{rmd_has_inline_code}
\alias{rmd_extract_inline_code}
\title{Inline code detection and extraction utilities}
\usage{
rmd_has_inline_code(x, engine = NULL)

rmd_extract_inline_code(x, flatten = FALSE)
}
\arguments{
\item{x}{An AST node, list of nodes, or character vector}

\item{engine}{character vector, optional glob patterns for matching inline code engine names.
If NULL (default), matches any inline code.}

\item{flatten}{Return a flat list inline codes if \code{TRUE}}
}
\value{
\itemize{
\item \code{rmd_has_inline_code()}: logical vector indicating which nodes contain inline code
\item \code{rmd_extract_inline_code()}: list of inline code objects found in the content
}
}
\description{
Functions for detecting and extracting inline code chunks from AST nodes
after the initial parsing phase.
}
