% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{pathling_fhirpath_to_column}
\alias{pathling_fhirpath_to_column}
\title{Convert a FHIRPath expression to a Spark Column}
\usage{
pathling_fhirpath_to_column(pc, resource_type, fhirpath_expression)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{resource_type}{A string containing the FHIR resource type code (e.g., "Patient",
"Observation").}

\item{fhirpath_expression}{A FHIRPath expression to evaluate (e.g., "gender = 'male'",
"name.given.first()").}
}
\value{
A Spark Column object (\code{spark_jobj}) representing the evaluated expression.
}
\description{
Converts a FHIRPath expression into a Spark Column that can be used in DataFrame operations
such as filtering and selection. Boolean expressions can be used for filtering, while other
expressions can be used for value extraction.
}
\details{
The expression should evaluate to a single value per resource row.
}
\examples{
\dontrun{
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))
patients <- data_source \%>\% ds_read("Patient")

# Filter patients using a boolean FHIRPath expression.
filtered <- patients \%>\%
  pathling_filter(pc, "Patient", "gender = 'male'")

# Value expression for selection.
name_col <- pathling_fhirpath_to_column(pc, "Patient", "name.given.first()")

pathling_disconnect(pc)
}
}
\seealso{
Other context functions: 
\code{\link{pathling_evaluate_fhirpath}()},
\code{\link{pathling_filter}()},
\code{\link{pathling_search_to_column}()},
\code{\link{pathling_with_column}()}
}
\concept{context functions}
