% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendraranking_service.R
\name{kendraranking}
\alias{kendraranking}
\title{Amazon Kendra Intelligent Ranking}
\usage{
kendraranking(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Kendra Intelligent Ranking uses Amazon Kendra semantic search
capabilities to intelligently re-rank a search service's results.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- kendraranking(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=kendraranking_create_rescore_execution_plan]{create_rescore_execution_plan} \tab Creates a rescore execution plan\cr
\link[=kendraranking_delete_rescore_execution_plan]{delete_rescore_execution_plan} \tab Deletes a rescore execution plan\cr
\link[=kendraranking_describe_rescore_execution_plan]{describe_rescore_execution_plan} \tab Gets information about a rescore execution plan\cr
\link[=kendraranking_list_rescore_execution_plans]{list_rescore_execution_plans} \tab Lists your rescore execution plans\cr
\link[=kendraranking_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags associated with a specified resource\cr
\link[=kendraranking_rescore]{rescore} \tab Rescores or re-ranks search results from a search service such as OpenSearch (self managed)\cr
\link[=kendraranking_tag_resource]{tag_resource} \tab Adds a specified tag to a specified rescore execution plan\cr
\link[=kendraranking_untag_resource]{untag_resource} \tab Removes a tag from a rescore execution plan\cr
\link[=kendraranking_update_rescore_execution_plan]{update_rescore_execution_plan} \tab Updates a rescore execution plan
}
}

\examples{
\dontrun{
svc <- kendraranking()
svc$create_rescore_execution_plan(
  Foo = 123
)
}

}
