% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_respond_decision_task_completed}
\alias{swf_respond_decision_task_completed}
\title{Used by deciders to tell the service that the DecisionTask identified by
the taskToken has successfully completed}
\usage{
swf_respond_decision_task_completed(
  taskToken,
  decisions = NULL,
  executionContext = NULL,
  taskList = NULL,
  taskListScheduleToStartTimeout = NULL
)
}
\arguments{
\item{taskToken}{[required] The \code{taskToken} from the DecisionTask.

\code{taskToken} is generated by the service and should be treated as an
opaque value. If the task is passed to another process, its \code{taskToken}
must also be passed. This enables it to provide its progress and respond
with results.}

\item{decisions}{The list of decisions (possibly empty) made by the decider while
processing this decision task. See the docs for the Decision structure
for details.}

\item{executionContext}{User defined context to add to workflow execution.}

\item{taskList}{The task list to use for the future decision tasks of this workflow
execution. This list overrides the original task list you specified
while starting the workflow execution.}

\item{taskListScheduleToStartTimeout}{Specifies a timeout (in seconds) for the task list override. When this
parameter is missing, the task list override is permanent. This
parameter makes it possible to temporarily override the task list. If a
decision task scheduled on the override task list is not started within
the timeout, the decision task will time out. Amazon SWF will revert the
override and schedule a new decision task to the original task list.

If a decision task scheduled on the override task list is started within
the timeout, but not completed within the start-to-close timeout, Amazon
SWF will also revert the override and schedule a new decision task to
the original task list.}
}
\description{
Used by deciders to tell the service that the DecisionTask identified by the \code{taskToken} has successfully completed. The \code{decisions} argument specifies the list of decisions made while processing the task.

See \url{https://www.paws-r-sdk.com/docs/swf_respond_decision_task_completed/} for full documentation.
}
\keyword{internal}
