% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_register_transit_gateway_multicast_group_members}
\alias{ec2_register_transit_gateway_multicast_group_members}
\title{Registers members (network interfaces) with the transit gateway
multicast group}
\usage{
ec2_register_transit_gateway_multicast_group_members(
  TransitGatewayMulticastDomainId,
  GroupIpAddress = NULL,
  NetworkInterfaceIds,
  DryRun = NULL
)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{[required] The ID of the transit gateway multicast domain.}

\item{GroupIpAddress}{The IP address assigned to the transit gateway multicast group.}

\item{NetworkInterfaceIds}{[required] The group members' network interface IDs to register with the transit
gateway multicast group.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Registers members (network interfaces) with the transit gateway multicast group. A member is a network interface associated with a supported EC2 instance that receives multicast traffic. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/tgw/tgw-multicast-overview.html}{Multicast on transit gateways} in the \emph{Amazon Web Services Transit Gateways Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_register_transit_gateway_multicast_group_members/} for full documentation.
}
\keyword{internal}
