% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_describe_task_sets}
\alias{ecs_describe_task_sets}
\title{Describes the task sets in the specified cluster and service}
\usage{
ecs_describe_task_sets(cluster, service, taskSets = NULL, include = NULL)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service that the task sets exist in.}

\item{service}{[required] The short name or full Amazon Resource Name (ARN) of the service that
the task sets exist in.}

\item{taskSets}{The ID or full Amazon Resource Name (ARN) of task sets to describe.}

\item{include}{Specifies whether to see the resource tags for the task set. If \code{TAGS}
is specified, the tags are included in the response. If this field is
omitted, tags aren't included in the response.}
}
\description{
Describes the task sets in the specified cluster and service. This is used when a service uses the \code{EXTERNAL} deployment controller type. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/}{Amazon ECS Deployment Types} in the \emph{Amazon Elastic Container Service Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/ecs_describe_task_sets/} for full documentation.
}
\keyword{internal}
