% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacecatalog_operations.R
\name{marketplacecatalog_list_change_sets}
\alias{marketplacecatalog_list_change_sets}
\title{Returns the list of change sets owned by the account being used to make
the call}
\usage{
marketplacecatalog_list_change_sets(
  Catalog,
  FilterList = NULL,
  Sort = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Catalog}{[required] The catalog related to the request. Fixed value: \code{AWSMarketplace}}

\item{FilterList}{An array of filter objects.}

\item{Sort}{An object that contains two attributes, \code{SortBy} and \code{SortOrder}.}

\item{MaxResults}{The maximum number of results returned by a single call. This value must
be provided in the next call to retrieve the next set of results. By
default, this value is 20.}

\item{NextToken}{The token value retrieved from a previous call to access the next page
of results.}
}
\description{
Returns the list of change sets owned by the account being used to make the call. You can filter this list by providing any combination of \code{entityId}, \code{ChangeSetName}, and status. If you provide more than one filter, the API operation applies a logical AND between the filters.

See \url{https://www.paws-r-sdk.com/docs/marketplacecatalog_list_change_sets/} for full documentation.
}
\keyword{internal}
