% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_journey_run_execution_activity_metrics}
\alias{pinpoint_get_journey_run_execution_activity_metrics}
\title{Retrieves (queries) pre-aggregated data for a standard run execution
metric that applies to a journey activity}
\usage{
pinpoint_get_journey_run_execution_activity_metrics(
  ApplicationId,
  JourneyActivityId,
  JourneyId,
  NextToken = NULL,
  PageSize = NULL,
  RunId
)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{JourneyActivityId}{[required] The unique identifier for the journey activity.}

\item{JourneyId}{[required] The unique identifier for the journey.}

\item{NextToken}{The `` string that specifies which page of results to return in a
paginated response. This parameter is not supported for application,
campaign, and journey metrics.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{RunId}{[required] The unique identifier for the journey run.}
}
\description{
Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.

See \url{https://www.paws-r-sdk.com/docs/pinpoint_get_journey_run_execution_activity_metrics/} for full documentation.
}
\keyword{internal}
