% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_list_contacts}
\alias{sesv2_list_contacts}
\title{Lists the contacts present in a specific contact list}
\usage{
sesv2_list_contacts(
  ContactListName,
  Filter = NULL,
  PageSize = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ContactListName}{[required] The name of the contact list.}

\item{Filter}{A filter that can be applied to a list of contacts.}

\item{PageSize}{The number of contacts that may be returned at once, which is dependent
on if there are more or less contacts than the value of the PageSize.
Use this parameter to paginate results. If additional contacts exist
beyond the specified limit, the \code{NextToken} element is sent in the
response. Use the \code{NextToken} value in subsequent requests to retrieve
additional contacts.}

\item{NextToken}{A string token indicating that there might be additional contacts
available to be listed. Use the token provided in the Response to use in
the subsequent call to ListContacts with the same parameters to retrieve
the next page of contacts.}
}
\description{
Lists the contacts present in a specific contact list.

See \url{https://www.paws-r-sdk.com/docs/sesv2_list_contacts/} for full documentation.
}
\keyword{internal}
