% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_create_user}
\alias{memorydb_create_user}
\title{Creates a MemoryDB user}
\usage{
memorydb_create_user(UserName, AuthenticationMode, AccessString, Tags = NULL)
}
\arguments{
\item{UserName}{[required] The name of the user. This value must be unique as it also serves as the
user identifier.}

\item{AuthenticationMode}{[required] Denotes the user's authentication properties, such as whether it
requires a password to authenticate.}

\item{AccessString}{[required] Access permissions string used for this user.}

\item{Tags}{A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}
}
\description{
Creates a MemoryDB user. For more information, see \href{https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html}{Authenticating users with Access Contol Lists (ACLs)}.

See \url{https://www.paws-r-sdk.com/docs/memorydb_create_user/} for full documentation.
}
\keyword{internal}
