% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_global_clusters}
\alias{neptune_describe_global_clusters}
\title{Returns information about Neptune global database clusters}
\usage{
neptune_describe_global_clusters(
  GlobalClusterIdentifier = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{The user-supplied DB cluster identifier. If this parameter is specified,
only information about the specified DB cluster is returned. This
parameter is not case-sensitive.

Constraints: If supplied, must match an existing DB cluster identifier.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination marker
token is included in the response that you can use to retrieve the
remaining results.

Default: \code{100}

Constraints: Minimum 20, maximum 100.}

\item{Marker}{(\emph{Optional}) A pagination token returned by a previous call to
\code{\link[=neptune_describe_global_clusters]{describe_global_clusters}}. If this
parameter is specified, the response will only include records beyond
the marker, up to the number specified by \code{MaxRecords}.}
}
\description{
Returns information about Neptune global database clusters. This API supports pagination.

See \url{https://www.paws-r-sdk.com/docs/neptune_describe_global_clusters/} for full documentation.
}
\keyword{internal}
