% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_global_clusters}
\alias{docdb_describe_global_clusters}
\title{Returns information about Amazon DocumentDB global clusters}
\usage{
docdb_describe_global_clusters(
  GlobalClusterIdentifier = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{The user-supplied cluster identifier. If this parameter is specified,
information from only the specific cluster is returned. This parameter
isn't case-sensitive.}

\item{Filters}{A filter that specifies one or more global DB clusters to describe.

Supported filters: \code{db-cluster-id} accepts cluster identifiers and
cluster Amazon Resource Names (ARNs). The results list will only include
information about the clusters identified by these ARNs.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=docdb_describe_global_clusters]{describe_global_clusters}} request. If
this parameter is specified, the response includes only records beyond
the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns information about Amazon DocumentDB global clusters. This API supports pagination.

See \url{https://www.paws-r-sdk.com/docs/docdb_describe_global_clusters/} for full documentation.
}
\keyword{internal}
