% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_get_effective_permissions_for_path}
\alias{lakeformation_get_effective_permissions_for_path}
\title{Returns the Lake Formation permissions for a specified table or database
resource located at a path in Amazon S3}
\usage{
lakeformation_get_effective_permissions_for_path(
  CatalogId = NULL,
  ResourceArn,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource for which you want to get
permissions.}

\item{NextToken}{A continuation token, if this is not the first call to retrieve this
list.}

\item{MaxResults}{The maximum number of results to return.}
}
\description{
Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. \code{\link[=lakeformation_get_effective_permissions_for_path]{get_effective_permissions_for_path}} will not return databases and tables if the catalog is encrypted.

See \url{https://www.paws-r-sdk.com/docs/lakeformation_get_effective_permissions_for_path/} for full documentation.
}
\keyword{internal}
