% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_disassociate_member_from_group}
\alias{workmail_disassociate_member_from_group}
\title{Removes a member from a group}
\usage{
workmail_disassociate_member_from_group(OrganizationId, GroupId, MemberId)
}
\arguments{
\item{OrganizationId}{[required] The identifier for the organization under which the group exists.}

\item{GroupId}{[required] The identifier for the group from which members are removed.

The identifier can accept \emph{GroupId}, \emph{Groupname}, or \emph{email}. The
following identity formats are available:
\itemize{
\item Group ID: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: group@domain.tld
\item Group name: group
}}

\item{MemberId}{[required] The identifier for the member to be removed from the group.

The member ID can accept \emph{UserID or GroupId}, \emph{Username or Groupname},
or \emph{email}.
\itemize{
\item Member ID: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: member@domain.tld
\item Member name: member
}}
}
\description{
Removes a member from a group.

See \url{https://www.paws-r-sdk.com/docs/workmail_disassociate_member_from_group/} for full documentation.
}
\keyword{internal}
