% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_inference_profile}
\alias{bedrock_create_inference_profile}
\title{Creates an application inference profile to track metrics and costs when
invoking a model}
\usage{
bedrock_create_inference_profile(
  inferenceProfileName,
  description = NULL,
  clientRequestToken = NULL,
  modelSource,
  tags = NULL
)
}
\arguments{
\item{inferenceProfileName}{[required] A name for the inference profile.}

\item{description}{A description for the inference profile.}

\item{clientRequestToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{modelSource}{[required] The foundation model or system-defined inference profile that the
inference profile will track metrics and costs for.}

\item{tags}{An array of objects, each of which contains a tag and its value. For
more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Tagging resources}
in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.}
}
\description{
Creates an application inference profile to track metrics and costs when invoking a model. To create an application inference profile for a foundation model in one region, specify the ARN of the model in that region. To create an application inference profile for a foundation model across multiple regions, specify the ARN of the system-defined inference profile that contains the regions that you want to route requests to. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html}{Increase throughput and resilience with cross-region inference in Amazon Bedrock}. in the Amazon Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_inference_profile/} for full documentation.
}
\keyword{internal}
