% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_list_event_predictions}
\alias{frauddetector_list_event_predictions}
\title{Gets a list of past predictions}
\usage{
frauddetector_list_event_predictions(
  eventId = NULL,
  eventType = NULL,
  detectorId = NULL,
  detectorVersionId = NULL,
  predictionTimeRange = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{eventId}{The event ID.}

\item{eventType}{The event type associated with the detector.}

\item{detectorId}{The detector ID.}

\item{detectorVersionId}{The detector version ID.}

\item{predictionTimeRange}{The time period for when the predictions were generated.}

\item{nextToken}{Identifies the next page of results to return. Use the token to make the
call again to retrieve the next page. Keep all other arguments
unchanged. Each pagination token expires after 24 hours.}

\item{maxResults}{The maximum number of predictions to return for the request.}
}
\description{
Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_list_event_predictions/} for full documentation.
}
\keyword{internal}
