% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_exports}
\alias{lexmodelsv2_list_exports}
\title{Lists the exports for a bot, bot locale, or custom vocabulary}
\usage{
lexmodelsv2_list_exports(
  botId = NULL,
  botVersion = NULL,
  sortBy = NULL,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL,
  localeId = NULL
)
}
\arguments{
\item{botId}{The unique identifier that Amazon Lex assigned to the bot.}

\item{botVersion}{The version of the bot to list exports for.}

\item{sortBy}{Determines the field that the list of exports is sorted by. You can sort
by the \code{LastUpdatedDateTime} field in ascending or descending order.}

\item{filters}{Provides the specification of a filter used to limit the exports in the
response to only those that match the filter specification. You can only
specify one filter and one string to filter on.}

\item{maxResults}{The maximum number of exports to return in each page of results. If
there are fewer results than the max page size, only the actual number
of results are returned.}

\item{nextToken}{If the response from the \code{\link[=lexmodelsv2_list_exports]{list_exports}}
operation contains more results that specified in the \code{maxResults}
parameter, a token is returned in the response.

Use the returned token in the \code{nextToken} parameter of a
\code{\link[=lexmodelsv2_list_exports]{list_exports}} request to return the next
page of results. For a complete set of results, call the
\code{\link[=lexmodelsv2_list_exports]{list_exports}} operation until the
\code{nextToken} returned in the response is null.}

\item{localeId}{Specifies the resources that should be exported. If you don't specify a
resource type in the \code{filters} parameter, both bot locales and custom
vocabularies are exported.}
}
\description{
Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_exports/} for full documentation.
}
\keyword{internal}
