% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_create_user}
\alias{rekognition_create_user}
\title{Creates a new User within a collection specified by CollectionId}
\usage{
rekognition_create_user(CollectionId, UserId, ClientRequestToken = NULL)
}
\arguments{
\item{CollectionId}{[required] The ID of an existing collection to which the new UserID needs to be
created.}

\item{UserId}{[required] ID for the UserID to be created. This ID needs to be unique within the
collection.}

\item{ClientRequestToken}{Idempotent token used to identify the request to
\code{\link[=rekognition_create_user]{create_user}}. If you use the same token with
multiple \code{\link[=rekognition_create_user]{create_user}} requests, the same
response is returned. Use ClientRequestToken to prevent the same request
from being processed more than once.}
}
\description{
Creates a new User within a collection specified by \code{CollectionId}. Takes \code{UserId} as a parameter, which is a user provided ID which should be unique within the collection. The provided \code{UserId} will alias the system generated UUID to make the \code{UserId} more user friendly.

See \url{https://www.paws-r-sdk.com/docs/rekognition_create_user/} for full documentation.
}
\keyword{internal}
