% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_get_expense_analysis}
\alias{textract_get_expense_analysis}
\title{Gets the results for an Amazon Textract asynchronous operation that
analyzes invoices and receipts}
\usage{
textract_get_expense_analysis(JobId, MaxResults = NULL, NextToken = NULL)
}
\arguments{
\item{JobId}{[required] A unique identifier for the text detection job. The \code{JobId} is returned
from \code{\link[=textract_start_expense_analysis]{start_expense_analysis}}. A
\code{JobId} value is only valid for 7 days.}

\item{MaxResults}{The maximum number of results to return per paginated call. The largest
value you can specify is 20. If you specify a value greater than 20, a
maximum of 20 results is returned. The default value is 20.}

\item{NextToken}{If the previous response was incomplete (because there are more blocks
to retrieve), Amazon Textract returns a pagination token in the
response. You can use this pagination token to retrieve the next set of
blocks.}
}
\description{
Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.

See \url{https://www.paws-r-sdk.com/docs/textract_get_expense_analysis/} for full documentation.
}
\keyword{internal}
