% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_list_knowledge_base_documents}
\alias{bedrockagent_list_knowledge_base_documents}
\title{Retrieves all the documents contained in a data source that is connected
to a knowledge base}
\usage{
bedrockagent_list_knowledge_base_documents(
  dataSourceId,
  knowledgeBaseId,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{dataSourceId}{[required] The unique identifier of the data source that contains the documents.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base that is connected to the
data source.}

\item{maxResults}{The maximum number of results to return in the response. If the total
number of results is greater than this value, use the token returned in
the response in the \code{nextToken} field when making another request to
return the next batch of results.}

\item{nextToken}{If the total number of results is greater than the \code{maxResults} value
provided in the request, enter the token returned in the \code{nextToken}
field in the response in this field to return the next batch of results.}
}
\description{
Retrieves all the documents contained in a data source that is connected to a knowledge base. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html}{Ingest changes directly into a knowledge base} in the Amazon Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_list_knowledge_base_documents/} for full documentation.
}
\keyword{internal}
