% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_put_resource_policy}
\alias{cloudtrail_put_resource_policy}
\title{Attaches a resource-based permission policy to a CloudTrail event data
store, dashboard, or channel}
\usage{
cloudtrail_put_resource_policy(ResourceArn, ResourcePolicy)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the CloudTrail event data store,
dashboard, or channel attached to the resource-based policy.

Example event data store ARN format:
\verb{arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE}

Example dashboard ARN format:
\code{arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash}

Example channel ARN format:
\code{arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890}}

\item{ResourcePolicy}{[required] A JSON-formatted string for an Amazon Web Services resource-based
policy.

For example resource-based policies, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html}{CloudTrail resource-based policy examples}
in the \emph{CloudTrail User Guide}.}
}
\description{
Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel. For more information about resource-based policies, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html}{CloudTrail resource-based policy examples} in the \emph{CloudTrail User Guide}.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_put_resource_policy/} for full documentation.
}
\keyword{internal}
