% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchapplicationsignals_operations.R
\name{cloudwatchapplicationsignals_list_service_dependents}
\alias{cloudwatchapplicationsignals_list_service_dependents}
\title{Returns the list of dependents that invoked the specified service during
the provided time range}
\usage{
cloudwatchapplicationsignals_list_service_dependents(
  StartTime,
  EndTime,
  KeyAttributes,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{StartTime}{[required] The start of the time period to retrieve information about. When used in
a raw HTTP Query API, it is formatted as be epoch time in seconds. For
example: \code{1698778057}

Your requested start time will be rounded to the nearest hour.}

\item{EndTime}{[required] The end of the time period to retrieve information about. When used in a
raw HTTP Query API, it is formatted as be epoch time in seconds. For
example: \code{1698778057}

Your requested start time will be rounded to the nearest hour.}

\item{KeyAttributes}{[required] Use this field to specify which service you want to retrieve information
for. You must specify at least the \code{Type}, \code{Name}, and \code{Environment}
attributes.

This is a string-to-string map. It can include the following fields.
\itemize{
\item \code{Type} designates the type of object this is.
\item \code{ResourceType} specifies the type of the resource. This field is
used only when the value of the \code{Type} field is \code{Resource} or
\code{AWS::Resource}.
\item \code{Name} specifies the name of the object. This is used only if the
value of the \code{Type} field is \code{Service}, \code{RemoteService}, or
\code{AWS::Service}.
\item \code{Identifier} identifies the resource objects of this resource. This
is used only if the value of the \code{Type} field is \code{Resource} or
\code{AWS::Resource}.
\item \code{Environment} specifies the location where this object is hosted, or
what it belongs to.
}}

\item{MaxResults}{The maximum number of results to return in one operation. If you omit
this parameter, the default of 50 is used.}

\item{NextToken}{Include this value, if it was returned by the previous operation, to get
the next set of service dependents.}
}
\description{
Returns the list of dependents that invoked the specified service during the provided time range. Dependents include other services, CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch RUM app monitors.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_dependents/} for full documentation.
}
\keyword{internal}
