% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_destination_policy}
\alias{cloudwatchlogs_put_destination_policy}
\title{Creates or updates an access policy associated with an existing
destination}
\usage{
cloudwatchlogs_put_destination_policy(
  destinationName,
  accessPolicy,
  forceUpdate = NULL
)
}
\arguments{
\item{destinationName}{[required] A name for an existing destination.}

\item{accessPolicy}{[required] An IAM policy document that authorizes cross-account users to deliver
their log events to the associated destination. This can be up to 5120
bytes.}

\item{forceUpdate}{Specify true if you are updating an existing destination policy to grant
permission to an organization ID instead of granting permission to
individual Amazon Web Services accounts. Before you update a destination
policy this way, you must first update the subscription filters in the
accounts that send logs to this destination. If you do not, the
subscription filters might stop working. By specifying \code{true} for
\code{forceUpdate}, you are affirming that you have already updated the
subscription filters. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html}{Updating an existing cross-account subscription}

If you omit this parameter, the default of \code{false} is used.}
}
\description{
Creates or updates an access policy associated with an existing destination. An access policy is an \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}{IAM policy document} that is used to authorize claims to register a subscription filter against a given destination.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_destination_policy/} for full documentation.
}
\keyword{internal}
