% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_index_policy}
\alias{cloudwatchlogs_put_index_policy}
\title{Creates or updates a field index policy for the specified log group}
\usage{
cloudwatchlogs_put_index_policy(logGroupIdentifier, policyDocument)
}
\arguments{
\item{logGroupIdentifier}{[required] Specify either the log group name or log group ARN to apply this field
index policy to. If you specify an ARN, use the format
arn:aws:logs:\emph{region}:\emph{account-id}:log-group:\emph{log_group_name} Don't
include an * at the end.}

\item{policyDocument}{[required] The index policy document, in JSON format. The following is an example
of an index policy document that creates two indexes, \code{RequestId} and
\code{TransactionId}.

\verb{"policyDocument": "\{ "Fields": [ "RequestId", "TransactionId" ] \}"}

The policy document must include at least one field index. For more
information about the fields that can be included and other
restrictions, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing-Syntax.html}{Field index syntax and quotas}.}
}
\description{
Creates or updates a \emph{field index policy} for the specified log group. Only log groups in the Standard log class support field index policies. For more information about log classes, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html}{Log classes}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_index_policy/} for full documentation.
}
\keyword{internal}
