% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_service_setting}
\alias{ssm_get_service_setting}
\title{ServiceSetting is an account-level setting for an Amazon Web Services
service}
\usage{
ssm_get_service_setting(SettingId)
}
\arguments{
\item{SettingId}{[required] The ID of the service setting to get. The setting ID can be one of the
following.
\itemize{
\item \verb{/ssm/appmanager/appmanager-enabled}
\item \verb{/ssm/automation/customer-script-log-destination}
\item \verb{/ssm/automation/customer-script-log-group-name}
\item /ssm/automation/enable-adaptive-concurrency
\item \verb{/ssm/documents/console/public-sharing-permission}
\item \verb{/ssm/managed-instance/activation-tier}
\item \verb{/ssm/managed-instance/default-ec2-instance-management-role}
\item \verb{/ssm/opsinsights/opscenter}
\item \verb{/ssm/parameter-store/default-parameter-tier}
\item \verb{/ssm/parameter-store/high-throughput-enabled}
}}
}
\description{
\code{ServiceSetting} is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of \code{false}. This means the user can't use this feature unless they change the setting to \code{true} and intentionally opt in for a paid feature.

See \url{https://www.paws-r-sdk.com/docs/ssm_get_service_setting/} for full documentation.
}
\keyword{internal}
