% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_nodes_summary}
\alias{ssm_list_nodes_summary}
\title{Generates a summary of managed instance/node metadata based on the
filters and aggregators you specify}
\usage{
ssm_list_nodes_summary(
  SyncName = NULL,
  Filters = NULL,
  Aggregators,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{SyncName}{The name of the resource data sync to retrieve information about.
Required for cross-account/cross-Region configuration. Optional for
single account/single-Region configurations.}

\item{Filters}{One or more filters. Use a filter to generate a summary that matches
your specified filter criteria.}

\item{Aggregators}{[required] Specify one or more aggregators to return a count of managed nodes that
match that expression. For example, a count of managed nodes by
operating system.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.) The call also returns a token that you can
specify in a subsequent call to get the next set of results.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\description{
Generates a summary of managed instance/node metadata based on the filters and aggregators you specify. Results are grouped by the input aggregator you specify.

See \url{https://www.paws-r-sdk.com/docs/ssm_list_nodes_summary/} for full documentation.
}
\keyword{internal}
