# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include licensemanagerusersubscriptions_service.R
NULL

#' Associates the user to an EC2 instance to utilize user-based
#' subscriptions
#'
#' @description
#' Associates the user to an EC2 instance to utilize user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_associate_user/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_associate_user/) for full documentation.
#'
#' @param Domain The domain name of the Active Directory that contains information for
#' the user to associate.
#' @param IdentityProvider &#91;required&#93; The identity provider for the user.
#' @param InstanceId &#91;required&#93; The ID of the EC2 instance that provides the user-based subscription.
#' @param Tags The tags that apply for the user association.
#' @param Username &#91;required&#93; The user name from the identity provider.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_associate_user
licensemanagerusersubscriptions_associate_user <- function(Domain = NULL, IdentityProvider, InstanceId, Tags = NULL, Username) {
  op <- new_operation(
    name = "AssociateUser",
    http_method = "POST",
    http_path = "/user/AssociateUser",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$associate_user_input(Domain = Domain, IdentityProvider = IdentityProvider, InstanceId = InstanceId, Tags = Tags, Username = Username)
  output <- .licensemanagerusersubscriptions$associate_user_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$associate_user <- licensemanagerusersubscriptions_associate_user

#' Creates a network endpoint for the Remote Desktop Services (RDS) license
#' server
#'
#' @description
#' Creates a network endpoint for the Remote Desktop Services (RDS) license server.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_create_license_server_endpoint/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_create_license_server_endpoint/) for full documentation.
#'
#' @param IdentityProviderArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the `IdentityProvider`
#' resource that contains details about a registered identity provider. In
#' the case of Active Directory, that can be a self-managed Active
#' Directory or an Amazon Web Services Managed Active Directory that
#' contains user identity details.
#' @param LicenseServerSettings &#91;required&#93; The `LicenseServerSettings` resource to create for the endpoint. The
#' settings include the type of license server and the Secrets Manager
#' secret that enables administrators to add or remove users associated
#' with the license server.
#' @param Tags The tags that apply for the license server endpoint.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_cre_lic_ser_end
licensemanagerusersubscriptions_create_license_server_endpoint <- function(IdentityProviderArn, LicenseServerSettings, Tags = NULL) {
  op <- new_operation(
    name = "CreateLicenseServerEndpoint",
    http_method = "POST",
    http_path = "/license-server/CreateLicenseServerEndpoint",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$create_license_server_endpoint_input(IdentityProviderArn = IdentityProviderArn, LicenseServerSettings = LicenseServerSettings, Tags = Tags)
  output <- .licensemanagerusersubscriptions$create_license_server_endpoint_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$create_license_server_endpoint <- licensemanagerusersubscriptions_create_license_server_endpoint

#' Deletes a LicenseServerEndpoint resource
#'
#' @description
#' Deletes a `LicenseServerEndpoint` resource.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_delete_license_server_endpoint/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_delete_license_server_endpoint/) for full documentation.
#'
#' @param LicenseServerEndpointArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the
#' `LicenseServerEndpoint` resource to delete.
#' @param ServerType &#91;required&#93; The type of License Server that the delete request refers to.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_del_lic_ser_end
licensemanagerusersubscriptions_delete_license_server_endpoint <- function(LicenseServerEndpointArn, ServerType) {
  op <- new_operation(
    name = "DeleteLicenseServerEndpoint",
    http_method = "POST",
    http_path = "/license-server/DeleteLicenseServerEndpoint",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$delete_license_server_endpoint_input(LicenseServerEndpointArn = LicenseServerEndpointArn, ServerType = ServerType)
  output <- .licensemanagerusersubscriptions$delete_license_server_endpoint_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$delete_license_server_endpoint <- licensemanagerusersubscriptions_delete_license_server_endpoint

#' Deregisters the Active Directory identity provider from License Manager
#' user-based subscriptions
#'
#' @description
#' Deregisters the Active Directory identity provider from License Manager user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_deregister_identity_provider/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_deregister_identity_provider/) for full documentation.
#'
#' @param IdentityProvider An object that specifies details for the Active Directory identity
#' provider.
#' @param IdentityProviderArn The Amazon Resource Name (ARN) that identifies the identity provider to
#' deregister.
#' @param Product The name of the user-based subscription product.
#' 
#' Valid values: `VISUAL_STUDIO_ENTERPRISE` | `VISUAL_STUDIO_PROFESSIONAL`
#' | `OFFICE_PROFESSIONAL_PLUS` | `REMOTE_DESKTOP_SERVICES`
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_deregister_identity_provider
licensemanagerusersubscriptions_deregister_identity_provider <- function(IdentityProvider = NULL, IdentityProviderArn = NULL, Product = NULL) {
  op <- new_operation(
    name = "DeregisterIdentityProvider",
    http_method = "POST",
    http_path = "/identity-provider/DeregisterIdentityProvider",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$deregister_identity_provider_input(IdentityProvider = IdentityProvider, IdentityProviderArn = IdentityProviderArn, Product = Product)
  output <- .licensemanagerusersubscriptions$deregister_identity_provider_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$deregister_identity_provider <- licensemanagerusersubscriptions_deregister_identity_provider

#' Disassociates the user from an EC2 instance providing user-based
#' subscriptions
#'
#' @description
#' Disassociates the user from an EC2 instance providing user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_disassociate_user/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_disassociate_user/) for full documentation.
#'
#' @param Domain The domain name of the Active Directory that contains information for
#' the user to disassociate.
#' @param IdentityProvider An object that specifies details for the Active Directory identity
#' provider.
#' @param InstanceId The ID of the EC2 instance which provides user-based subscriptions.
#' @param InstanceUserArn The Amazon Resource Name (ARN) of the user to disassociate from the EC2
#' instance.
#' @param Username The user name from the Active Directory identity provider for the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_disassociate_user
licensemanagerusersubscriptions_disassociate_user <- function(Domain = NULL, IdentityProvider = NULL, InstanceId = NULL, InstanceUserArn = NULL, Username = NULL) {
  op <- new_operation(
    name = "DisassociateUser",
    http_method = "POST",
    http_path = "/user/DisassociateUser",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$disassociate_user_input(Domain = Domain, IdentityProvider = IdentityProvider, InstanceId = InstanceId, InstanceUserArn = InstanceUserArn, Username = Username)
  output <- .licensemanagerusersubscriptions$disassociate_user_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$disassociate_user <- licensemanagerusersubscriptions_disassociate_user

#' Lists the Active Directory identity providers for user-based
#' subscriptions
#'
#' @description
#' Lists the Active Directory identity providers for user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_identity_providers/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_identity_providers/) for full documentation.
#'
#' @param Filters You can use the following filters to streamline results:
#' 
#' -   Product
#' 
#' -   DirectoryId
#' @param MaxResults The maximum number of results to return from a single request.
#' @param NextToken A token to specify where to start paginating. This is the nextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_identity_providers
licensemanagerusersubscriptions_list_identity_providers <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityProviders",
    http_method = "POST",
    http_path = "/identity-provider/ListIdentityProviders",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "IdentityProviderSummaries"),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$list_identity_providers_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_identity_providers_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_identity_providers <- licensemanagerusersubscriptions_list_identity_providers

#' Lists the EC2 instances providing user-based subscriptions
#'
#' @description
#' Lists the EC2 instances providing user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_instances/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_instances/) for full documentation.
#'
#' @param Filters You can use the following filters to streamline results:
#' 
#' -   Status
#' 
#' -   InstanceId
#' @param MaxResults The maximum number of results to return from a single request.
#' @param NextToken A token to specify where to start paginating. This is the nextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_instances
licensemanagerusersubscriptions_list_instances <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/instance/ListInstances",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InstanceSummaries"),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$list_instances_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_instances_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_instances <- licensemanagerusersubscriptions_list_instances

#' List the Remote Desktop Services (RDS) License Server endpoints
#'
#' @description
#' List the Remote Desktop Services (RDS) License Server endpoints
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_license_server_endpoints/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_license_server_endpoints/) for full documentation.
#'
#' @param Filters You can use the following filters to streamline results:
#' 
#' -   IdentityProviderArn
#' @param MaxResults The maximum number of results to return from a single request.
#' @param NextToken A token to specify where to start paginating. This is the nextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_lis_lic_ser_end
licensemanagerusersubscriptions_list_license_server_endpoints <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLicenseServerEndpoints",
    http_method = "POST",
    http_path = "/license-server/ListLicenseServerEndpoints",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "LicenseServerEndpoints"),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$list_license_server_endpoints_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_license_server_endpoints_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_license_server_endpoints <- licensemanagerusersubscriptions_list_license_server_endpoints

#' Lists the user-based subscription products available from an identity
#' provider
#'
#' @description
#' Lists the user-based subscription products available from an identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_product_subscriptions/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_product_subscriptions/) for full documentation.
#'
#' @param Filters You can use the following filters to streamline results:
#' 
#' -   Status
#' 
#' -   Username
#' 
#' -   Domain
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param MaxResults The maximum number of results to return from a single request.
#' @param NextToken A token to specify where to start paginating. This is the nextToken from
#' a previously truncated response.
#' @param Product The name of the user-based subscription product.
#' 
#' Valid values: `VISUAL_STUDIO_ENTERPRISE` | `VISUAL_STUDIO_PROFESSIONAL`
#' | `OFFICE_PROFESSIONAL_PLUS` | `REMOTE_DESKTOP_SERVICES`
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_product_subscriptions
licensemanagerusersubscriptions_list_product_subscriptions <- function(Filters = NULL, IdentityProvider, MaxResults = NULL, NextToken = NULL, Product = NULL) {
  op <- new_operation(
    name = "ListProductSubscriptions",
    http_method = "POST",
    http_path = "/user/ListProductSubscriptions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ProductUserSummaries"),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$list_product_subscriptions_input(Filters = Filters, IdentityProvider = IdentityProvider, MaxResults = MaxResults, NextToken = NextToken, Product = Product)
  output <- .licensemanagerusersubscriptions$list_product_subscriptions_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_product_subscriptions <- licensemanagerusersubscriptions_list_product_subscriptions

#' Returns the list of tags for the specified resource
#'
#' @description
#' Returns the list of tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_tags_for_resource
licensemanagerusersubscriptions_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .licensemanagerusersubscriptions$list_tags_for_resource_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_tags_for_resource <- licensemanagerusersubscriptions_list_tags_for_resource

#' Lists user associations for an identity provider
#'
#' @description
#' Lists user associations for an identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_user_associations/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_user_associations/) for full documentation.
#'
#' @param Filters You can use the following filters to streamline results:
#' 
#' -   Status
#' 
#' -   Username
#' 
#' -   Domain
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param InstanceId &#91;required&#93; The ID of the EC2 instance, which provides user-based subscriptions.
#' @param MaxResults The maximum number of results to return from a single request.
#' @param NextToken A token to specify where to start paginating. This is the nextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_user_associations
licensemanagerusersubscriptions_list_user_associations <- function(Filters = NULL, IdentityProvider, InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUserAssociations",
    http_method = "POST",
    http_path = "/user/ListUserAssociations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InstanceUserSummaries"),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$list_user_associations_input(Filters = Filters, IdentityProvider = IdentityProvider, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_user_associations_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_user_associations <- licensemanagerusersubscriptions_list_user_associations

#' Registers an identity provider for user-based subscriptions
#'
#' @description
#' Registers an identity provider for user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_register_identity_provider/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_register_identity_provider/) for full documentation.
#'
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider to register.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#' 
#' Valid values: `VISUAL_STUDIO_ENTERPRISE` | `VISUAL_STUDIO_PROFESSIONAL`
#' | `OFFICE_PROFESSIONAL_PLUS` | `REMOTE_DESKTOP_SERVICES`
#' @param Settings The registered identity provider’s product related configuration
#' settings such as the subnets to provision VPC endpoints.
#' @param Tags The tags that apply to the identity provider's registration.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_register_identity_provider
licensemanagerusersubscriptions_register_identity_provider <- function(IdentityProvider, Product, Settings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "RegisterIdentityProvider",
    http_method = "POST",
    http_path = "/identity-provider/RegisterIdentityProvider",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$register_identity_provider_input(IdentityProvider = IdentityProvider, Product = Product, Settings = Settings, Tags = Tags)
  output <- .licensemanagerusersubscriptions$register_identity_provider_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$register_identity_provider <- licensemanagerusersubscriptions_register_identity_provider

#' Starts a product subscription for a user with the specified identity
#' provider
#'
#' @description
#' Starts a product subscription for a user with the specified identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_start_product_subscription/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_start_product_subscription/) for full documentation.
#'
#' @param Domain The domain name of the Active Directory that contains the user for whom
#' to start the product subscription.
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#' 
#' Valid values: `VISUAL_STUDIO_ENTERPRISE` | `VISUAL_STUDIO_PROFESSIONAL`
#' | `OFFICE_PROFESSIONAL_PLUS` | `REMOTE_DESKTOP_SERVICES`
#' @param Tags The tags that apply to the product subscription.
#' @param Username &#91;required&#93; The user name from the identity provider of the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_start_product_subscription
licensemanagerusersubscriptions_start_product_subscription <- function(Domain = NULL, IdentityProvider, Product, Tags = NULL, Username) {
  op <- new_operation(
    name = "StartProductSubscription",
    http_method = "POST",
    http_path = "/user/StartProductSubscription",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$start_product_subscription_input(Domain = Domain, IdentityProvider = IdentityProvider, Product = Product, Tags = Tags, Username = Username)
  output <- .licensemanagerusersubscriptions$start_product_subscription_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$start_product_subscription <- licensemanagerusersubscriptions_start_product_subscription

#' Stops a product subscription for a user with the specified identity
#' provider
#'
#' @description
#' Stops a product subscription for a user with the specified identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_stop_product_subscription/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_stop_product_subscription/) for full documentation.
#'
#' @param Domain The domain name of the Active Directory that contains the user for whom
#' to stop the product subscription.
#' @param IdentityProvider An object that specifies details for the identity provider.
#' @param Product The name of the user-based subscription product.
#' 
#' Valid values: `VISUAL_STUDIO_ENTERPRISE` | `VISUAL_STUDIO_PROFESSIONAL`
#' | `OFFICE_PROFESSIONAL_PLUS` | `REMOTE_DESKTOP_SERVICES`
#' @param ProductUserArn The Amazon Resource Name (ARN) of the product user.
#' @param Username The user name from the identity provider for the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_stop_product_subscription
licensemanagerusersubscriptions_stop_product_subscription <- function(Domain = NULL, IdentityProvider = NULL, Product = NULL, ProductUserArn = NULL, Username = NULL) {
  op <- new_operation(
    name = "StopProductSubscription",
    http_method = "POST",
    http_path = "/user/StopProductSubscription",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$stop_product_subscription_input(Domain = Domain, IdentityProvider = IdentityProvider, Product = Product, ProductUserArn = ProductUserArn, Username = Username)
  output <- .licensemanagerusersubscriptions$stop_product_subscription_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$stop_product_subscription <- licensemanagerusersubscriptions_stop_product_subscription

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_tag_resource/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param Tags &#91;required&#93; The tags to apply to the specified resource.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_tag_resource
licensemanagerusersubscriptions_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .licensemanagerusersubscriptions$tag_resource_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$tag_resource <- licensemanagerusersubscriptions_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_untag_resource/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' tags from.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_untag_resource
licensemanagerusersubscriptions_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .licensemanagerusersubscriptions$untag_resource_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$untag_resource <- licensemanagerusersubscriptions_untag_resource

#' Updates additional product configuration settings for the registered
#' identity provider
#'
#' @description
#' Updates additional product configuration settings for the registered identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_update_identity_provider_settings/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_update_identity_provider_settings/) for full documentation.
#'
#' @param IdentityProvider 
#' @param IdentityProviderArn The Amazon Resource Name (ARN) of the identity provider to update.
#' @param Product The name of the user-based subscription product.
#' 
#' Valid values: `VISUAL_STUDIO_ENTERPRISE` | `VISUAL_STUDIO_PROFESSIONAL`
#' | `OFFICE_PROFESSIONAL_PLUS` | `REMOTE_DESKTOP_SERVICES`
#' @param UpdateSettings &#91;required&#93; Updates the registered identity provider’s product related configuration
#' settings. You can update any combination of settings in a single
#' operation such as the:
#' 
#' -   Subnets which you want to add to provision VPC endpoints.
#' 
#' -   Subnets which you want to remove the VPC endpoints from.
#' 
#' -   Security group ID which permits traffic to the VPC endpoints.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_upd_ide_pro_set
licensemanagerusersubscriptions_update_identity_provider_settings <- function(IdentityProvider = NULL, IdentityProviderArn = NULL, Product = NULL, UpdateSettings) {
  op <- new_operation(
    name = "UpdateIdentityProviderSettings",
    http_method = "POST",
    http_path = "/identity-provider/UpdateIdentityProviderSettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .licensemanagerusersubscriptions$update_identity_provider_settings_input(IdentityProvider = IdentityProvider, IdentityProviderArn = IdentityProviderArn, Product = Product, UpdateSettings = UpdateSettings)
  output <- .licensemanagerusersubscriptions$update_identity_provider_settings_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$update_identity_provider_settings <- licensemanagerusersubscriptions_update_identity_provider_settings
