% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_dashboard}
\alias{cloudwatch_put_dashboard}
\title{Creates a dashboard if it does not already exist, or updates an existing
dashboard}
\usage{
cloudwatch_put_dashboard(DashboardName, DashboardBody)
}
\arguments{
\item{DashboardName}{[required] The name of the dashboard. If a dashboard with this name already exists,
this call modifies that dashboard, replacing its current contents.
Otherwise, a new dashboard is created. The maximum length is 255, and
valid characters are A-Z, a-z, 0-9, "-", and "_". This parameter is
required.}

\item{DashboardBody}{[required] The detailed information about the dashboard in JSON format, including
the widgets to include and their location on the dashboard. This
parameter is required.

For more information about the syntax, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html}{Dashboard Body Structure and Syntax}.}
}
\description{
Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_put_dashboard/} for full documentation.
}
\keyword{internal}
