# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudfrontkeyvaluestore_service.R
NULL

#' Deletes the key value pair specified by the key
#'
#' @description
#' Deletes the key value pair specified by the key.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_delete_key/](https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_delete_key/) for full documentation.
#'
#' @param KvsARN &#91;required&#93; The Amazon Resource Name (ARN) of the Key Value Store.
#' @param Key &#91;required&#93; The key to delete.
#' @param IfMatch &#91;required&#93; The current version (ETag) of the Key Value Store that you are deleting
#' keys from, which you can get using DescribeKeyValueStore.
#'
#' @keywords internal
#'
#' @rdname cloudfrontkeyvaluestore_delete_key
cloudfrontkeyvaluestore_delete_key <- function(KvsARN, Key, IfMatch) {
  op <- new_operation(
    name = "DeleteKey",
    http_method = "DELETE",
    http_path = "/key-value-stores/{KvsARN}/keys/{Key}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudfrontkeyvaluestore$delete_key_input(KvsARN = KvsARN, Key = Key, IfMatch = IfMatch)
  output <- .cloudfrontkeyvaluestore$delete_key_output()
  config <- get_config()
  svc <- .cloudfrontkeyvaluestore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfrontkeyvaluestore$operations$delete_key <- cloudfrontkeyvaluestore_delete_key

#' Returns metadata information about Key Value Store
#'
#' @description
#' Returns metadata information about Key Value Store.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_describe_key_value_store/](https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_describe_key_value_store/) for full documentation.
#'
#' @param KvsARN &#91;required&#93; The Amazon Resource Name (ARN) of the Key Value Store.
#'
#' @keywords internal
#'
#' @rdname cloudfrontkeyvaluestore_describe_key_value_store
cloudfrontkeyvaluestore_describe_key_value_store <- function(KvsARN) {
  op <- new_operation(
    name = "DescribeKeyValueStore",
    http_method = "GET",
    http_path = "/key-value-stores/{KvsARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudfrontkeyvaluestore$describe_key_value_store_input(KvsARN = KvsARN)
  output <- .cloudfrontkeyvaluestore$describe_key_value_store_output()
  config <- get_config()
  svc <- .cloudfrontkeyvaluestore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfrontkeyvaluestore$operations$describe_key_value_store <- cloudfrontkeyvaluestore_describe_key_value_store

#' Returns a key value pair
#'
#' @description
#' Returns a key value pair.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_get_key/](https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_get_key/) for full documentation.
#'
#' @param KvsARN &#91;required&#93; The Amazon Resource Name (ARN) of the Key Value Store.
#' @param Key &#91;required&#93; The key to get.
#'
#' @keywords internal
#'
#' @rdname cloudfrontkeyvaluestore_get_key
cloudfrontkeyvaluestore_get_key <- function(KvsARN, Key) {
  op <- new_operation(
    name = "GetKey",
    http_method = "GET",
    http_path = "/key-value-stores/{KvsARN}/keys/{Key}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudfrontkeyvaluestore$get_key_input(KvsARN = KvsARN, Key = Key)
  output <- .cloudfrontkeyvaluestore$get_key_output()
  config <- get_config()
  svc <- .cloudfrontkeyvaluestore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfrontkeyvaluestore$operations$get_key <- cloudfrontkeyvaluestore_get_key

#' Returns a list of key value pairs
#'
#' @description
#' Returns a list of key value pairs.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_list_keys/](https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_list_keys/) for full documentation.
#'
#' @param KvsARN &#91;required&#93; The Amazon Resource Name (ARN) of the Key Value Store.
#' @param NextToken If nextToken is returned in the response, there are more results
#' available. Make the next call using the returned token to retrieve the
#' next page.
#' @param MaxResults Maximum number of results that are returned per call. The default is 10
#' and maximum allowed page is 50.
#'
#' @keywords internal
#'
#' @rdname cloudfrontkeyvaluestore_list_keys
cloudfrontkeyvaluestore_list_keys <- function(KvsARN, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListKeys",
    http_method = "GET",
    http_path = "/key-value-stores/{KvsARN}/keys",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .cloudfrontkeyvaluestore$list_keys_input(KvsARN = KvsARN, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudfrontkeyvaluestore$list_keys_output()
  config <- get_config()
  svc <- .cloudfrontkeyvaluestore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfrontkeyvaluestore$operations$list_keys <- cloudfrontkeyvaluestore_list_keys

#' Creates a new key value pair or replaces the value of an existing key
#'
#' @description
#' Creates a new key value pair or replaces the value of an existing key.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_put_key/](https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_put_key/) for full documentation.
#'
#' @param Key &#91;required&#93; The key to put.
#' @param Value &#91;required&#93; The value to put.
#' @param KvsARN &#91;required&#93; The Amazon Resource Name (ARN) of the Key Value Store.
#' @param IfMatch &#91;required&#93; The current version (ETag) of the Key Value Store that you are putting
#' keys into, which you can get using DescribeKeyValueStore.
#'
#' @keywords internal
#'
#' @rdname cloudfrontkeyvaluestore_put_key
cloudfrontkeyvaluestore_put_key <- function(Key, Value, KvsARN, IfMatch) {
  op <- new_operation(
    name = "PutKey",
    http_method = "PUT",
    http_path = "/key-value-stores/{KvsARN}/keys/{Key}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudfrontkeyvaluestore$put_key_input(Key = Key, Value = Value, KvsARN = KvsARN, IfMatch = IfMatch)
  output <- .cloudfrontkeyvaluestore$put_key_output()
  config <- get_config()
  svc <- .cloudfrontkeyvaluestore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfrontkeyvaluestore$operations$put_key <- cloudfrontkeyvaluestore_put_key

#' Puts or Deletes multiple key value pairs in a single, all-or-nothing
#' operation
#'
#' @description
#' Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_update_keys/](https://www.paws-r-sdk.com/docs/cloudfrontkeyvaluestore_update_keys/) for full documentation.
#'
#' @param KvsARN &#91;required&#93; The Amazon Resource Name (ARN) of the Key Value Store.
#' @param IfMatch &#91;required&#93; The current version (ETag) of the Key Value Store that you are updating
#' keys of, which you can get using DescribeKeyValueStore.
#' @param Puts List of key value pairs to put.
#' @param Deletes List of keys to delete.
#'
#' @keywords internal
#'
#' @rdname cloudfrontkeyvaluestore_update_keys
cloudfrontkeyvaluestore_update_keys <- function(KvsARN, IfMatch, Puts = NULL, Deletes = NULL) {
  op <- new_operation(
    name = "UpdateKeys",
    http_method = "POST",
    http_path = "/key-value-stores/{KvsARN}/keys",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudfrontkeyvaluestore$update_keys_input(KvsARN = KvsARN, IfMatch = IfMatch, Puts = Puts, Deletes = Deletes)
  output <- .cloudfrontkeyvaluestore$update_keys_output()
  config <- get_config()
  svc <- .cloudfrontkeyvaluestore$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfrontkeyvaluestore$operations$update_keys <- cloudfrontkeyvaluestore_update_keys
