# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include apigatewayv2_service.R
NULL

#' Creates an Api resource
#'
#' @description
#' Creates an Api resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_api/) for full documentation.
#'
#' @param ApiKeySelectionExpression An API key selection expression. Supported only for WebSocket APIs. See
#' [API Key Selection
#' Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
#' @param CorsConfiguration A CORS configuration. Supported only for HTTP APIs. See [Configuring
#' CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
#' for more information.
#' @param CredentialsArn This property is part of quick create. It specifies the credentials
#' required for the integration, if any. For a Lambda integration, three
#' options are available. To specify an IAM Role for API Gateway to assume,
#' use the role's Amazon Resource Name (ARN). To require that the caller's
#' identity be passed through from the request, specify
#' arn:aws:iam::*:user/*. To use resource-based permissions on supported
#' AWS services, specify null. Currently, this property is not used for
#' HTTP integrations. Supported only for HTTP APIs.
#' @param Description The description of the API.
#' @param DisableSchemaValidation Avoid validating models when creating a deployment. Supported only for
#' WebSocket APIs.
#' @param DisableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default
#' execute-api endpoint. By default, clients can invoke your API with the
#' default https://\{api_id\}.execute-api.\{region\}.amazonaws.com
#' endpoint. To require that clients use a custom domain name to invoke
#' your API, disable the default endpoint.
#' @param Name &#91;required&#93; The name of the API.
#' @param ProtocolType &#91;required&#93; The API protocol.
#' @param RouteKey This property is part of quick create. If you don't specify a routeKey,
#' a default route of $default is created. The $default route acts as a
#' catch-all for any request made to your API, for a particular stage. The
#' $default route key can't be modified. You can add routes after creating
#' the API, and you can update the route keys of additional routes.
#' Supported only for HTTP APIs.
#' @param RouteSelectionExpression The route selection expression for the API. For HTTP APIs, the
#' routeSelectionExpression must be $\{request.method\}
#' $\{request.path\}. If not provided, this will be the default for HTTP
#' APIs. This property is required for WebSocket APIs.
#' @param Tags The collection of tags. Each tag element is associated with a given
#' resource.
#' @param Target This property is part of quick create. Quick create produces an API with
#' an integration, a default catch-all route, and a default stage which is
#' configured to automatically deploy changes. For HTTP integrations,
#' specify a fully qualified URL. For Lambda integrations, specify a
#' function ARN. The type of the integration will be HTTP_PROXY or
#' AWS_PROXY, respectively. Supported only for HTTP APIs.
#' @param Version A version identifier for the API.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_api
apigatewayv2_create_api <- function(ApiKeySelectionExpression = NULL, CorsConfiguration = NULL, CredentialsArn = NULL, Description = NULL, DisableSchemaValidation = NULL, DisableExecuteApiEndpoint = NULL, Name, ProtocolType, RouteKey = NULL, RouteSelectionExpression = NULL, Tags = NULL, Target = NULL, Version = NULL) {
  op <- new_operation(
    name = "CreateApi",
    http_method = "POST",
    http_path = "/v2/apis",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_api_input(ApiKeySelectionExpression = ApiKeySelectionExpression, CorsConfiguration = CorsConfiguration, CredentialsArn = CredentialsArn, Description = Description, DisableSchemaValidation = DisableSchemaValidation, DisableExecuteApiEndpoint = DisableExecuteApiEndpoint, Name = Name, ProtocolType = ProtocolType, RouteKey = RouteKey, RouteSelectionExpression = RouteSelectionExpression, Tags = Tags, Target = Target, Version = Version)
  output <- .apigatewayv2$create_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_api <- apigatewayv2_create_api

#' Creates an API mapping
#'
#' @description
#' Creates an API mapping.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_api_mapping/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_api_mapping/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiMappingKey The API mapping key.
#' @param DomainName &#91;required&#93; The domain name.
#' @param Stage &#91;required&#93; The API stage.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_api_mapping
apigatewayv2_create_api_mapping <- function(ApiId, ApiMappingKey = NULL, DomainName, Stage) {
  op <- new_operation(
    name = "CreateApiMapping",
    http_method = "POST",
    http_path = "/v2/domainnames/{domainName}/apimappings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_api_mapping_input(ApiId = ApiId, ApiMappingKey = ApiMappingKey, DomainName = DomainName, Stage = Stage)
  output <- .apigatewayv2$create_api_mapping_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_api_mapping <- apigatewayv2_create_api_mapping

#' Creates an Authorizer for an API
#'
#' @description
#' Creates an Authorizer for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_authorizer/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_authorizer/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerCredentialsArn Specifies the required credentials as an IAM role for API Gateway to
#' invoke the authorizer. To specify an IAM role for API Gateway to assume,
#' use the role's Amazon Resource Name (ARN). To use resource-based
#' permissions on the Lambda function, don't specify this parameter.
#' Supported only for REQUEST authorizers.
#' @param AuthorizerPayloadFormatVersion Specifies the format of the payload sent to an HTTP API Lambda
#' authorizer. Required for HTTP API Lambda authorizers. Supported values
#' are 1.0 and 2.0. To learn more, see [Working with AWS Lambda authorizers
#' for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
#' @param AuthorizerResultTtlInSeconds The time to live (TTL) for cached authorizer results, in seconds. If it
#' equals 0, authorization caching is disabled. If it is greater than 0,
#' API Gateway caches authorizer responses. The maximum value is 3600, or 1
#' hour. Supported only for HTTP API Lambda authorizers.
#' @param AuthorizerType &#91;required&#93; The authorizer type. Specify REQUEST for a Lambda function using
#' incoming request parameters. Specify JWT to use JSON Web Tokens
#' (supported only for HTTP APIs).
#' @param AuthorizerUri The authorizer's Uniform Resource Identifier (URI). For REQUEST
#' authorizers, this must be a well-formed Lambda function URI, for
#' example,
#' arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:\{account_id\}:function:\{lambda_function_name\}/invocations.
#' In general, the URI has this form:
#' arn:aws:apigateway:\{region\}:lambda:path/\{service_api\} , where
#' \{region\} is the same as the region hosting the Lambda function, path
#' indicates that the remaining substring in the URI should be treated as
#' the path to the resource, including the initial /. For Lambda functions,
#' this is usually of the form
#' /2015-03-31/functions/\[FunctionARN\]/invocations. Supported only for
#' REQUEST authorizers.
#' @param EnableSimpleResponses Specifies whether a Lambda authorizer returns a response in a simple
#' format. By default, a Lambda authorizer must return an IAM policy. If
#' enabled, the Lambda authorizer can return a boolean value instead of an
#' IAM policy. Supported only for HTTP APIs. To learn more, see [Working
#' with AWS Lambda authorizers for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html)
#' @param IdentitySource &#91;required&#93; The identity source for which authorization is requested.
#' 
#' For a REQUEST authorizer, this is optional. The value is a set of one or
#' more mapping expressions of the specified request parameters. The
#' identity source can be headers, query string parameters, stage
#' variables, and context parameters. For example, if an Auth header and a
#' Name query string parameter are defined as identity sources, this value
#' is route.request.header.Auth, route.request.querystring.Name for
#' WebSocket APIs. For HTTP APIs, use selection expressions prefixed with
#' $, for example, $request.header.Auth, $request.querystring.Name. These
#' parameters are used to perform runtime validation for Lambda-based
#' authorizers by verifying all of the identity-related request parameters
#' are present in the request, not null, and non-empty. Only when this is
#' true does the authorizer invoke the authorizer Lambda function.
#' Otherwise, it returns a 401 Unauthorized response without calling the
#' Lambda function. For HTTP APIs, identity sources are also used as the
#' cache key when caching is enabled. To learn more, see [Working with AWS
#' Lambda authorizers for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
#' 
#' For JWT, a single entry that specifies where to extract the JSON Web
#' Token (JWT) from inbound requests. Currently only header-based and query
#' parameter-based selections are supported, for example
#' $request.header.Authorization.
#' @param IdentityValidationExpression This parameter is not used.
#' @param JwtConfiguration Represents the configuration of a JWT authorizer. Required for the JWT
#' authorizer type. Supported only for HTTP APIs.
#' @param Name &#91;required&#93; The name of the authorizer.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_authorizer
apigatewayv2_create_authorizer <- function(ApiId, AuthorizerCredentialsArn = NULL, AuthorizerPayloadFormatVersion = NULL, AuthorizerResultTtlInSeconds = NULL, AuthorizerType, AuthorizerUri = NULL, EnableSimpleResponses = NULL, IdentitySource, IdentityValidationExpression = NULL, JwtConfiguration = NULL, Name) {
  op <- new_operation(
    name = "CreateAuthorizer",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/authorizers",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_authorizer_input(ApiId = ApiId, AuthorizerCredentialsArn = AuthorizerCredentialsArn, AuthorizerPayloadFormatVersion = AuthorizerPayloadFormatVersion, AuthorizerResultTtlInSeconds = AuthorizerResultTtlInSeconds, AuthorizerType = AuthorizerType, AuthorizerUri = AuthorizerUri, EnableSimpleResponses = EnableSimpleResponses, IdentitySource = IdentitySource, IdentityValidationExpression = IdentityValidationExpression, JwtConfiguration = JwtConfiguration, Name = Name)
  output <- .apigatewayv2$create_authorizer_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_authorizer <- apigatewayv2_create_authorizer

#' Creates a Deployment for an API
#'
#' @description
#' Creates a Deployment for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_deployment/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_deployment/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param Description The description for the deployment resource.
#' @param StageName The name of the Stage resource for the Deployment resource to create.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_deployment
apigatewayv2_create_deployment <- function(ApiId, Description = NULL, StageName = NULL) {
  op <- new_operation(
    name = "CreateDeployment",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/deployments",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_deployment_input(ApiId = ApiId, Description = Description, StageName = StageName)
  output <- .apigatewayv2$create_deployment_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_deployment <- apigatewayv2_create_deployment

#' Creates a domain name
#'
#' @description
#' Creates a domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_domain_name/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_domain_name/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name.
#' @param DomainNameConfigurations The domain name configurations.
#' @param MutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name.
#' @param Tags The collection of tags associated with a domain name.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_domain_name
apigatewayv2_create_domain_name <- function(DomainName, DomainNameConfigurations = NULL, MutualTlsAuthentication = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDomainName",
    http_method = "POST",
    http_path = "/v2/domainnames",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_domain_name_input(DomainName = DomainName, DomainNameConfigurations = DomainNameConfigurations, MutualTlsAuthentication = MutualTlsAuthentication, Tags = Tags)
  output <- .apigatewayv2$create_domain_name_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_domain_name <- apigatewayv2_create_domain_name

#' Creates an Integration
#'
#' @description
#' Creates an Integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_integration/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_integration/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ConnectionId The ID of the VPC link for a private integration. Supported only for
#' HTTP APIs.
#' @param ConnectionType The type of the network connection to the integration endpoint. Specify
#' INTERNET for connections through the public routable internet or
#' VPC_LINK for private connections between API Gateway and resources in a
#' VPC. The default value is INTERNET.
#' @param ContentHandlingStrategy Supported only for WebSocket APIs. Specifies how to handle response
#' payload content type conversions. Supported values are CONVERT_TO_BINARY
#' and CONVERT_TO_TEXT, with the following behaviors:
#' 
#' CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param CredentialsArn Specifies the credentials required for the integration, if any. For AWS
#' integrations, three options are available. To specify an IAM Role for
#' API Gateway to assume, use the role's Amazon Resource Name (ARN). To
#' require that the caller's identity be passed through from the request,
#' specify the string arn:aws:iam::*:user/*. To use resource-based
#' permissions on supported AWS services, specify null.
#' @param Description The description of the integration.
#' @param IntegrationMethod Specifies the integration's HTTP method type.
#' @param IntegrationSubtype Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS
#' service action to invoke. To learn more, see [Integration subtype
#' reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html).
#' @param IntegrationType &#91;required&#93; The integration type of an integration. One of the following:
#' 
#' AWS: for integrating the route or method request with an AWS service
#' action, including the Lambda function-invoking action. With the Lambda
#' function-invoking action, this is referred to as the Lambda custom
#' integration. With any other AWS service action, this is known as AWS
#' integration. Supported only for WebSocket APIs.
#' 
#' AWS_PROXY: for integrating the route or method request with a Lambda
#' function or other AWS service action. This integration is also referred
#' to as a Lambda proxy integration.
#' 
#' HTTP: for integrating the route or method request with an HTTP endpoint.
#' This integration is also referred to as the HTTP custom integration.
#' Supported only for WebSocket APIs.
#' 
#' HTTP_PROXY: for integrating the route or method request with an HTTP
#' endpoint, with the client request passed through as-is. This is also
#' referred to as HTTP proxy integration. For HTTP API private
#' integrations, use an HTTP_PROXY integration.
#' 
#' MOCK: for integrating the route or method request with API Gateway as a
#' "loopback" endpoint without invoking any backend. Supported only for
#' WebSocket APIs.
#' @param IntegrationUri For a Lambda integration, specify the URI of a Lambda function.
#' 
#' For an HTTP integration, specify a fully-qualified URL.
#' 
#' For an HTTP API private integration, specify the ARN of an Application
#' Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map
#' service. If you specify the ARN of an AWS Cloud Map service, API Gateway
#' uses DiscoverInstances to identify resources. You can use query
#' parameters to target specific resources. To learn more, see
#' [DiscoverInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html).
#' For private integrations, all resources must be owned by the same AWS
#' account.
#' @param PassthroughBehavior Specifies the pass-through behavior for incoming requests based on the
#' Content-Type header in the request, and the available mapping templates
#' specified as the requestTemplates property on the Integration resource.
#' There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
#' NEVER. Supported only for WebSocket APIs.
#' 
#' WHEN_NO_MATCH passes the request body for unmapped content types through
#' to the integration backend without transformation.
#' 
#' NEVER rejects unmapped content types with an HTTP 415 Unsupported Media
#' Type response.
#' 
#' WHEN_NO_TEMPLATES allows pass-through when the integration has no
#' content types mapped to templates. However, if there is at least one
#' content type defined, unmapped content types will be rejected with the
#' same HTTP 415 Unsupported Media Type response.
#' @param PayloadFormatVersion Specifies the format of the payload sent to an integration. Required for
#' HTTP APIs. Supported values for Lambda proxy integrations are 1.0 and
#' 2.0. For all other integrations, 1.0 is the only supported value. To
#' learn more, see [Working with AWS Lambda proxy integrations for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html).
#' @param RequestParameters For WebSocket APIs, a key-value map specifying request parameters that
#' are passed from the method request to the backend. The key is an
#' integration request parameter name and the associated value is a method
#' request parameter value or static value that must be enclosed within
#' single quotes and pre-encoded as required by the backend. The method
#' request parameter value must match the pattern of
#' method.request.\{location\}.\{name\} , where \{location\} is
#' querystring, path, or header; and \{name\} must be a valid and unique
#' method request parameter name.
#' 
#' For HTTP API integrations with a specified integrationSubtype, request
#' parameters are a key-value map specifying parameters that are passed to
#' AWS_PROXY integrations. You can provide static values, or map request
#' data, stage variables, or context variables that are evaluated at
#' runtime. To learn more, see [Working with AWS service integrations for
#' HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html).
#' 
#' For HTTP API integrations without a specified integrationSubtype request
#' parameters are a key-value map specifying how to transform HTTP requests
#' before sending them to the backend. The key should follow the pattern
#' \<action\>:\<header|querystring|path\>.\<location\> where action can be
#' append, overwrite or remove. For values, you can provide static values,
#' or map request data, stage variables, or context variables that are
#' evaluated at runtime. To learn more, see [Transforming API requests and
#' responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
#' @param RequestTemplates Represents a map of Velocity templates that are applied on the request
#' payload based on the value of the Content-Type header sent by the
#' client. The content type value is the key in this map, and the template
#' (as a String) is the value. Supported only for WebSocket APIs.
#' @param ResponseParameters Supported only for HTTP APIs. You use response parameters to transform
#' the HTTP response from a backend integration before returning the
#' response to clients. Specify a key-value map from a selection key to
#' response parameters. The selection key must be a valid HTTP status code
#' within the range of 200-599. Response parameters are a key-value map.
#' The key must match pattern \<action\>:\<header\>.\<location\> or
#' overwrite.statuscode. The action can be append, overwrite or remove. The
#' value can be a static value, or map to response data, stage variables,
#' or context variables that are evaluated at runtime. To learn more, see
#' [Transforming API requests and
#' responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
#' @param TemplateSelectionExpression The template selection expression for the integration.
#' @param TimeoutInMillis Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and
#' between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is
#' 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
#' @param TlsConfig The TLS configuration for a private integration. If you specify a TLS
#' configuration, private integration traffic uses the HTTPS protocol.
#' Supported only for HTTP APIs.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_integration
apigatewayv2_create_integration <- function(ApiId, ConnectionId = NULL, ConnectionType = NULL, ContentHandlingStrategy = NULL, CredentialsArn = NULL, Description = NULL, IntegrationMethod = NULL, IntegrationSubtype = NULL, IntegrationType, IntegrationUri = NULL, PassthroughBehavior = NULL, PayloadFormatVersion = NULL, RequestParameters = NULL, RequestTemplates = NULL, ResponseParameters = NULL, TemplateSelectionExpression = NULL, TimeoutInMillis = NULL, TlsConfig = NULL) {
  op <- new_operation(
    name = "CreateIntegration",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/integrations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_integration_input(ApiId = ApiId, ConnectionId = ConnectionId, ConnectionType = ConnectionType, ContentHandlingStrategy = ContentHandlingStrategy, CredentialsArn = CredentialsArn, Description = Description, IntegrationMethod = IntegrationMethod, IntegrationSubtype = IntegrationSubtype, IntegrationType = IntegrationType, IntegrationUri = IntegrationUri, PassthroughBehavior = PassthroughBehavior, PayloadFormatVersion = PayloadFormatVersion, RequestParameters = RequestParameters, RequestTemplates = RequestTemplates, ResponseParameters = ResponseParameters, TemplateSelectionExpression = TemplateSelectionExpression, TimeoutInMillis = TimeoutInMillis, TlsConfig = TlsConfig)
  output <- .apigatewayv2$create_integration_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_integration <- apigatewayv2_create_integration

#' Creates an IntegrationResponses
#'
#' @description
#' Creates an IntegrationResponses.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_integration_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_integration_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentHandlingStrategy Specifies how to handle response payload content type conversions.
#' Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the
#' following behaviors:
#' 
#' CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseKey &#91;required&#93; The integration response key.
#' @param ResponseParameters A key-value map specifying response parameters that are passed to the
#' method response from the backend. The key is a method response header
#' parameter name and the mapped value is an integration response header
#' value, a static value enclosed within a pair of single quotes, or a JSON
#' expression from the integration response body. The mapping key must
#' match the pattern of method.response.header.\{name\}, where \{name\}
#' is a valid and unique header name. The mapped non-static value must
#' match the pattern of integration.response.header.\{name\} or
#' integration.response.body.\{JSON-expression\}, where \{name\} is a
#' valid and unique response header name and \{JSON-expression\} is a
#' valid JSON expression without the $ prefix.
#' @param ResponseTemplates The collection of response templates for the integration response as a
#' string-to-string map of key-value pairs. Response templates are
#' represented as a key/value map, with a content-type as the key and a
#' template as the value.
#' @param TemplateSelectionExpression The template selection expression for the integration response.
#' Supported only for WebSocket APIs.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_integration_response
apigatewayv2_create_integration_response <- function(ApiId, ContentHandlingStrategy = NULL, IntegrationId, IntegrationResponseKey, ResponseParameters = NULL, ResponseTemplates = NULL, TemplateSelectionExpression = NULL) {
  op <- new_operation(
    name = "CreateIntegrationResponse",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_integration_response_input(ApiId = ApiId, ContentHandlingStrategy = ContentHandlingStrategy, IntegrationId = IntegrationId, IntegrationResponseKey = IntegrationResponseKey, ResponseParameters = ResponseParameters, ResponseTemplates = ResponseTemplates, TemplateSelectionExpression = TemplateSelectionExpression)
  output <- .apigatewayv2$create_integration_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_integration_response <- apigatewayv2_create_integration_response

#' Creates a Model for an API
#'
#' @description
#' Creates a Model for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_model/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_model/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentType The content-type for the model, for example, "application/json".
#' @param Description The description of the model.
#' @param Name &#91;required&#93; The name of the model. Must be alphanumeric.
#' @param Schema &#91;required&#93; The schema for the model. For application/json models, this should be
#' JSON schema draft 4 model.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_model
apigatewayv2_create_model <- function(ApiId, ContentType = NULL, Description = NULL, Name, Schema) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/models",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_model_input(ApiId = ApiId, ContentType = ContentType, Description = Description, Name = Name, Schema = Schema)
  output <- .apigatewayv2$create_model_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_model <- apigatewayv2_create_model

#' Creates a Route for an API
#'
#' @description
#' Creates a Route for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_route/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_route/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiKeyRequired Specifies whether an API key is required for the route. Supported only
#' for WebSocket APIs.
#' @param AuthorizationScopes The authorization scopes supported by this route.
#' @param AuthorizationType The authorization type for the route. For WebSocket APIs, valid values
#' are NONE for open access, AWS_IAM for using AWS IAM permissions, and
#' CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are
#' NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using
#' AWS IAM permissions, and CUSTOM for using a Lambda authorizer.
#' @param AuthorizerId The identifier of the Authorizer resource to be associated with this
#' route. The authorizer identifier is generated by API Gateway when you
#' created the authorizer.
#' @param ModelSelectionExpression The model selection expression for the route. Supported only for
#' WebSocket APIs.
#' @param OperationName The operation name for the route.
#' @param RequestModels The request models for the route. Supported only for WebSocket APIs.
#' @param RequestParameters The request parameters for the route. Supported only for WebSocket APIs.
#' @param RouteKey &#91;required&#93; The route key for the route.
#' @param RouteResponseSelectionExpression The route response selection expression for the route. Supported only
#' for WebSocket APIs.
#' @param Target The target for the route.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_route
apigatewayv2_create_route <- function(ApiId, ApiKeyRequired = NULL, AuthorizationScopes = NULL, AuthorizationType = NULL, AuthorizerId = NULL, ModelSelectionExpression = NULL, OperationName = NULL, RequestModels = NULL, RequestParameters = NULL, RouteKey, RouteResponseSelectionExpression = NULL, Target = NULL) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/routes",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_route_input(ApiId = ApiId, ApiKeyRequired = ApiKeyRequired, AuthorizationScopes = AuthorizationScopes, AuthorizationType = AuthorizationType, AuthorizerId = AuthorizerId, ModelSelectionExpression = ModelSelectionExpression, OperationName = OperationName, RequestModels = RequestModels, RequestParameters = RequestParameters, RouteKey = RouteKey, RouteResponseSelectionExpression = RouteResponseSelectionExpression, Target = Target)
  output <- .apigatewayv2$create_route_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_route <- apigatewayv2_create_route

#' Creates a RouteResponse for a Route
#'
#' @description
#' Creates a RouteResponse for a Route.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_route_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_route_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelSelectionExpression The model selection expression for the route response. Supported only
#' for WebSocket APIs.
#' @param ResponseModels The response models for the route response.
#' @param ResponseParameters The route response parameters.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseKey &#91;required&#93; The route response key.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_route_response
apigatewayv2_create_route_response <- function(ApiId, ModelSelectionExpression = NULL, ResponseModels = NULL, ResponseParameters = NULL, RouteId, RouteResponseKey) {
  op <- new_operation(
    name = "CreateRouteResponse",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_route_response_input(ApiId = ApiId, ModelSelectionExpression = ModelSelectionExpression, ResponseModels = ResponseModels, ResponseParameters = ResponseParameters, RouteId = RouteId, RouteResponseKey = RouteResponseKey)
  output <- .apigatewayv2$create_route_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_route_response <- apigatewayv2_create_route_response

#' Creates a Stage for an API
#'
#' @description
#' Creates a Stage for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_stage/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_stage/) for full documentation.
#'
#' @param AccessLogSettings Settings for logging access in this stage.
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AutoDeploy Specifies whether updates to an API automatically trigger a new
#' deployment. The default value is false.
#' @param ClientCertificateId The identifier of a client certificate for a Stage. Supported only for
#' WebSocket APIs.
#' @param DefaultRouteSettings The default route settings for the stage.
#' @param DeploymentId The deployment identifier of the API stage.
#' @param Description The description for the API stage.
#' @param RouteSettings Route settings for the stage, by routeKey.
#' @param StageName &#91;required&#93; The name of the stage.
#' @param StageVariables A map that defines the stage variables for a Stage. Variable names can
#' have alphanumeric and underscore characters, and the values must match
#' \[A-Za-z0-9-._~:/?#&=,\]+.
#' @param Tags The collection of tags. Each tag element is associated with a given
#' resource.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_stage
apigatewayv2_create_stage <- function(AccessLogSettings = NULL, ApiId, AutoDeploy = NULL, ClientCertificateId = NULL, DefaultRouteSettings = NULL, DeploymentId = NULL, Description = NULL, RouteSettings = NULL, StageName, StageVariables = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateStage",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/stages",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_stage_input(AccessLogSettings = AccessLogSettings, ApiId = ApiId, AutoDeploy = AutoDeploy, ClientCertificateId = ClientCertificateId, DefaultRouteSettings = DefaultRouteSettings, DeploymentId = DeploymentId, Description = Description, RouteSettings = RouteSettings, StageName = StageName, StageVariables = StageVariables, Tags = Tags)
  output <- .apigatewayv2$create_stage_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_stage <- apigatewayv2_create_stage

#' Creates a VPC link
#'
#' @description
#' Creates a VPC link.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_create_vpc_link/](https://www.paws-r-sdk.com/docs/apigatewayv2_create_vpc_link/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the VPC link.
#' @param SecurityGroupIds A list of security group IDs for the VPC link.
#' @param SubnetIds &#91;required&#93; A list of subnet IDs to include in the VPC link.
#' @param Tags A list of tags.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_vpc_link
apigatewayv2_create_vpc_link <- function(Name, SecurityGroupIds = NULL, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateVpcLink",
    http_method = "POST",
    http_path = "/v2/vpclinks",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$create_vpc_link_input(Name = Name, SecurityGroupIds = SecurityGroupIds, SubnetIds = SubnetIds, Tags = Tags)
  output <- .apigatewayv2$create_vpc_link_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_vpc_link <- apigatewayv2_create_vpc_link

#' Deletes the AccessLogSettings for a Stage
#'
#' @description
#' Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_access_log_settings/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_access_log_settings/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param StageName &#91;required&#93; The stage name. Stage names can only contain alphanumeric characters,
#' hyphens, and underscores. Maximum length is 128 characters.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_access_log_settings
apigatewayv2_delete_access_log_settings <- function(ApiId, StageName) {
  op <- new_operation(
    name = "DeleteAccessLogSettings",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/stages/{stageName}/accesslogsettings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_access_log_settings_input(ApiId = ApiId, StageName = StageName)
  output <- .apigatewayv2$delete_access_log_settings_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_access_log_settings <- apigatewayv2_delete_access_log_settings

#' Deletes an Api resource
#'
#' @description
#' Deletes an Api resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_api/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_api
apigatewayv2_delete_api <- function(ApiId) {
  op <- new_operation(
    name = "DeleteApi",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_api_input(ApiId = ApiId)
  output <- .apigatewayv2$delete_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_api <- apigatewayv2_delete_api

#' Deletes an API mapping
#'
#' @description
#' Deletes an API mapping.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_api_mapping/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_api_mapping/) for full documentation.
#'
#' @param ApiMappingId &#91;required&#93; The API mapping identifier.
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_api_mapping
apigatewayv2_delete_api_mapping <- function(ApiMappingId, DomainName) {
  op <- new_operation(
    name = "DeleteApiMapping",
    http_method = "DELETE",
    http_path = "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_api_mapping_input(ApiMappingId = ApiMappingId, DomainName = DomainName)
  output <- .apigatewayv2$delete_api_mapping_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_api_mapping <- apigatewayv2_delete_api_mapping

#' Deletes an Authorizer
#'
#' @description
#' Deletes an Authorizer.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_authorizer/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_authorizer/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerId &#91;required&#93; The authorizer identifier.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_authorizer
apigatewayv2_delete_authorizer <- function(ApiId, AuthorizerId) {
  op <- new_operation(
    name = "DeleteAuthorizer",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/authorizers/{authorizerId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_authorizer_input(ApiId = ApiId, AuthorizerId = AuthorizerId)
  output <- .apigatewayv2$delete_authorizer_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_authorizer <- apigatewayv2_delete_authorizer

#' Deletes a CORS configuration
#'
#' @description
#' Deletes a CORS configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_cors_configuration/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_cors_configuration/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_cors_configuration
apigatewayv2_delete_cors_configuration <- function(ApiId) {
  op <- new_operation(
    name = "DeleteCorsConfiguration",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/cors",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_cors_configuration_input(ApiId = ApiId)
  output <- .apigatewayv2$delete_cors_configuration_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_cors_configuration <- apigatewayv2_delete_cors_configuration

#' Deletes a Deployment
#'
#' @description
#' Deletes a Deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_deployment/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_deployment/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param DeploymentId &#91;required&#93; The deployment ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_deployment
apigatewayv2_delete_deployment <- function(ApiId, DeploymentId) {
  op <- new_operation(
    name = "DeleteDeployment",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/deployments/{deploymentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_deployment_input(ApiId = ApiId, DeploymentId = DeploymentId)
  output <- .apigatewayv2$delete_deployment_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_deployment <- apigatewayv2_delete_deployment

#' Deletes a domain name
#'
#' @description
#' Deletes a domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_domain_name/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_domain_name/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_domain_name
apigatewayv2_delete_domain_name <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomainName",
    http_method = "DELETE",
    http_path = "/v2/domainnames/{domainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_domain_name_input(DomainName = DomainName)
  output <- .apigatewayv2$delete_domain_name_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_domain_name <- apigatewayv2_delete_domain_name

#' Deletes an Integration
#'
#' @description
#' Deletes an Integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_integration/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_integration/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_integration
apigatewayv2_delete_integration <- function(ApiId, IntegrationId) {
  op <- new_operation(
    name = "DeleteIntegration",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_integration_input(ApiId = ApiId, IntegrationId = IntegrationId)
  output <- .apigatewayv2$delete_integration_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_integration <- apigatewayv2_delete_integration

#' Deletes an IntegrationResponses
#'
#' @description
#' Deletes an IntegrationResponses.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_integration_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_integration_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseId &#91;required&#93; The integration response ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_integration_response
apigatewayv2_delete_integration_response <- function(ApiId, IntegrationId, IntegrationResponseId) {
  op <- new_operation(
    name = "DeleteIntegrationResponse",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_integration_response_input(ApiId = ApiId, IntegrationId = IntegrationId, IntegrationResponseId = IntegrationResponseId)
  output <- .apigatewayv2$delete_integration_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_integration_response <- apigatewayv2_delete_integration_response

#' Deletes a Model
#'
#' @description
#' Deletes a Model.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_model/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_model/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelId &#91;required&#93; The model ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_model
apigatewayv2_delete_model <- function(ApiId, ModelId) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/models/{modelId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_model_input(ApiId = ApiId, ModelId = ModelId)
  output <- .apigatewayv2$delete_model_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_model <- apigatewayv2_delete_model

#' Deletes a Route
#'
#' @description
#' Deletes a Route.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_route
apigatewayv2_delete_route <- function(ApiId, RouteId) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/routes/{routeId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_route_input(ApiId = ApiId, RouteId = RouteId)
  output <- .apigatewayv2$delete_route_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_route <- apigatewayv2_delete_route

#' Deletes a route request parameter
#'
#' @description
#' Deletes a route request parameter. Supported only for WebSocket APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route_request_parameter/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route_request_parameter/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RequestParameterKey &#91;required&#93; The route request parameter key.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_route_request_parameter
apigatewayv2_delete_route_request_parameter <- function(ApiId, RequestParameterKey, RouteId) {
  op <- new_operation(
    name = "DeleteRouteRequestParameter",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/requestparameters/{requestParameterKey}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_route_request_parameter_input(ApiId = ApiId, RequestParameterKey = RequestParameterKey, RouteId = RouteId)
  output <- .apigatewayv2$delete_route_request_parameter_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_route_request_parameter <- apigatewayv2_delete_route_request_parameter

#' Deletes a RouteResponse
#'
#' @description
#' Deletes a RouteResponse.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseId &#91;required&#93; The route response ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_route_response
apigatewayv2_delete_route_response <- function(ApiId, RouteId, RouteResponseId) {
  op <- new_operation(
    name = "DeleteRouteResponse",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_route_response_input(ApiId = ApiId, RouteId = RouteId, RouteResponseId = RouteResponseId)
  output <- .apigatewayv2$delete_route_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_route_response <- apigatewayv2_delete_route_response

#' Deletes the RouteSettings for a stage
#'
#' @description
#' Deletes the RouteSettings for a stage.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route_settings/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_route_settings/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteKey &#91;required&#93; The route key.
#' @param StageName &#91;required&#93; The stage name. Stage names can only contain alphanumeric characters,
#' hyphens, and underscores. Maximum length is 128 characters.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_route_settings
apigatewayv2_delete_route_settings <- function(ApiId, RouteKey, StageName) {
  op <- new_operation(
    name = "DeleteRouteSettings",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/stages/{stageName}/routesettings/{routeKey}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_route_settings_input(ApiId = ApiId, RouteKey = RouteKey, StageName = StageName)
  output <- .apigatewayv2$delete_route_settings_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_route_settings <- apigatewayv2_delete_route_settings

#' Deletes a Stage
#'
#' @description
#' Deletes a Stage.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_stage/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_stage/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param StageName &#91;required&#93; The stage name. Stage names can only contain alphanumeric characters,
#' hyphens, and underscores. Maximum length is 128 characters.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_stage
apigatewayv2_delete_stage <- function(ApiId, StageName) {
  op <- new_operation(
    name = "DeleteStage",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/stages/{stageName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_stage_input(ApiId = ApiId, StageName = StageName)
  output <- .apigatewayv2$delete_stage_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_stage <- apigatewayv2_delete_stage

#' Deletes a VPC link
#'
#' @description
#' Deletes a VPC link.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_delete_vpc_link/](https://www.paws-r-sdk.com/docs/apigatewayv2_delete_vpc_link/) for full documentation.
#'
#' @param VpcLinkId &#91;required&#93; The ID of the VPC link.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_vpc_link
apigatewayv2_delete_vpc_link <- function(VpcLinkId) {
  op <- new_operation(
    name = "DeleteVpcLink",
    http_method = "DELETE",
    http_path = "/v2/vpclinks/{vpcLinkId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$delete_vpc_link_input(VpcLinkId = VpcLinkId)
  output <- .apigatewayv2$delete_vpc_link_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_vpc_link <- apigatewayv2_delete_vpc_link

#' Export api
#'
#' @description
#' Export api
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_export_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_export_api/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ExportVersion The version of the API Gateway export algorithm. API Gateway uses the
#' latest version by default. Currently, the only supported version is 1.0.
#' @param IncludeExtensions Specifies whether to include [API Gateway
#' extensions](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html)
#' in the exported API definition. API Gateway extensions are included by
#' default.
#' @param OutputType &#91;required&#93; The output type of the exported definition file. Valid values are JSON
#' and YAML.
#' @param Specification &#91;required&#93; The version of the API specification to use. OAS30, for OpenAPI 3.0, is
#' the only supported value.
#' @param StageName The name of the API stage to export. If you don't specify this property,
#' a representation of the latest API configuration is exported.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_export_api
apigatewayv2_export_api <- function(ApiId, ExportVersion = NULL, IncludeExtensions = NULL, OutputType, Specification, StageName = NULL) {
  op <- new_operation(
    name = "ExportApi",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/exports/{specification}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$export_api_input(ApiId = ApiId, ExportVersion = ExportVersion, IncludeExtensions = IncludeExtensions, OutputType = OutputType, Specification = Specification, StageName = StageName)
  output <- .apigatewayv2$export_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$export_api <- apigatewayv2_export_api

#' Resets all authorizer cache entries on a stage
#'
#' @description
#' Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_reset_authorizers_cache/](https://www.paws-r-sdk.com/docs/apigatewayv2_reset_authorizers_cache/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param StageName &#91;required&#93; The stage name. Stage names can contain only alphanumeric characters,
#' hyphens, and underscores, or be $default. Maximum length is 128
#' characters.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_reset_authorizers_cache
apigatewayv2_reset_authorizers_cache <- function(ApiId, StageName) {
  op <- new_operation(
    name = "ResetAuthorizersCache",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/stages/{stageName}/cache/authorizers",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$reset_authorizers_cache_input(ApiId = ApiId, StageName = StageName)
  output <- .apigatewayv2$reset_authorizers_cache_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$reset_authorizers_cache <- apigatewayv2_reset_authorizers_cache

#' Gets an Api resource
#'
#' @description
#' Gets an Api resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_api/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_api
apigatewayv2_get_api <- function(ApiId) {
  op <- new_operation(
    name = "GetApi",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_api_input(ApiId = ApiId)
  output <- .apigatewayv2$get_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_api <- apigatewayv2_get_api

#' Gets an API mapping
#'
#' @description
#' Gets an API mapping.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_api_mapping/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_api_mapping/) for full documentation.
#'
#' @param ApiMappingId &#91;required&#93; The API mapping identifier.
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_api_mapping
apigatewayv2_get_api_mapping <- function(ApiMappingId, DomainName) {
  op <- new_operation(
    name = "GetApiMapping",
    http_method = "GET",
    http_path = "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_api_mapping_input(ApiMappingId = ApiMappingId, DomainName = DomainName)
  output <- .apigatewayv2$get_api_mapping_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_api_mapping <- apigatewayv2_get_api_mapping

#' Gets API mappings
#'
#' @description
#' Gets API mappings.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_api_mappings/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_api_mappings/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_api_mappings
apigatewayv2_get_api_mappings <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetApiMappings",
    http_method = "GET",
    http_path = "/v2/domainnames/{domainName}/apimappings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_api_mappings_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_api_mappings_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_api_mappings <- apigatewayv2_get_api_mappings

#' Gets a collection of Api resources
#'
#' @description
#' Gets a collection of Api resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_apis/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_apis/) for full documentation.
#'
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_apis
apigatewayv2_get_apis <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetApis",
    http_method = "GET",
    http_path = "/v2/apis",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_apis_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_apis_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_apis <- apigatewayv2_get_apis

#' Gets an Authorizer
#'
#' @description
#' Gets an Authorizer.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_authorizer/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_authorizer/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerId &#91;required&#93; The authorizer identifier.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_authorizer
apigatewayv2_get_authorizer <- function(ApiId, AuthorizerId) {
  op <- new_operation(
    name = "GetAuthorizer",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/authorizers/{authorizerId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_authorizer_input(ApiId = ApiId, AuthorizerId = AuthorizerId)
  output <- .apigatewayv2$get_authorizer_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_authorizer <- apigatewayv2_get_authorizer

#' Gets the Authorizers for an API
#'
#' @description
#' Gets the Authorizers for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_authorizers/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_authorizers/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_authorizers
apigatewayv2_get_authorizers <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAuthorizers",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/authorizers",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_authorizers_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_authorizers_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_authorizers <- apigatewayv2_get_authorizers

#' Gets a Deployment
#'
#' @description
#' Gets a Deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_deployment/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_deployment/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param DeploymentId &#91;required&#93; The deployment ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_deployment
apigatewayv2_get_deployment <- function(ApiId, DeploymentId) {
  op <- new_operation(
    name = "GetDeployment",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/deployments/{deploymentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_deployment_input(ApiId = ApiId, DeploymentId = DeploymentId)
  output <- .apigatewayv2$get_deployment_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_deployment <- apigatewayv2_get_deployment

#' Gets the Deployments for an API
#'
#' @description
#' Gets the Deployments for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_deployments/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_deployments/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_deployments
apigatewayv2_get_deployments <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDeployments",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/deployments",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_deployments_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_deployments_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_deployments <- apigatewayv2_get_deployments

#' Gets a domain name
#'
#' @description
#' Gets a domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_domain_name/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_domain_name/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_domain_name
apigatewayv2_get_domain_name <- function(DomainName) {
  op <- new_operation(
    name = "GetDomainName",
    http_method = "GET",
    http_path = "/v2/domainnames/{domainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_domain_name_input(DomainName = DomainName)
  output <- .apigatewayv2$get_domain_name_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_domain_name <- apigatewayv2_get_domain_name

#' Gets the domain names for an AWS account
#'
#' @description
#' Gets the domain names for an AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_domain_names/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_domain_names/) for full documentation.
#'
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_domain_names
apigatewayv2_get_domain_names <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDomainNames",
    http_method = "GET",
    http_path = "/v2/domainnames",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_domain_names_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_domain_names_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_domain_names <- apigatewayv2_get_domain_names

#' Gets an Integration
#'
#' @description
#' Gets an Integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_integration/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_integration/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integration
apigatewayv2_get_integration <- function(ApiId, IntegrationId) {
  op <- new_operation(
    name = "GetIntegration",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_integration_input(ApiId = ApiId, IntegrationId = IntegrationId)
  output <- .apigatewayv2$get_integration_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integration <- apigatewayv2_get_integration

#' Gets an IntegrationResponses
#'
#' @description
#' Gets an IntegrationResponses.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_integration_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_integration_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseId &#91;required&#93; The integration response ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integration_response
apigatewayv2_get_integration_response <- function(ApiId, IntegrationId, IntegrationResponseId) {
  op <- new_operation(
    name = "GetIntegrationResponse",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_integration_response_input(ApiId = ApiId, IntegrationId = IntegrationId, IntegrationResponseId = IntegrationResponseId)
  output <- .apigatewayv2$get_integration_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integration_response <- apigatewayv2_get_integration_response

#' Gets the IntegrationResponses for an Integration
#'
#' @description
#' Gets the IntegrationResponses for an Integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_integration_responses/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_integration_responses/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integration_responses
apigatewayv2_get_integration_responses <- function(ApiId, IntegrationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetIntegrationResponses",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_integration_responses_input(ApiId = ApiId, IntegrationId = IntegrationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_integration_responses_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integration_responses <- apigatewayv2_get_integration_responses

#' Gets the Integrations for an API
#'
#' @description
#' Gets the Integrations for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_integrations/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_integrations/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integrations
apigatewayv2_get_integrations <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetIntegrations",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_integrations_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_integrations_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integrations <- apigatewayv2_get_integrations

#' Gets a Model
#'
#' @description
#' Gets a Model.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_model/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_model/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelId &#91;required&#93; The model ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_model
apigatewayv2_get_model <- function(ApiId, ModelId) {
  op <- new_operation(
    name = "GetModel",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/models/{modelId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_model_input(ApiId = ApiId, ModelId = ModelId)
  output <- .apigatewayv2$get_model_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_model <- apigatewayv2_get_model

#' Gets a model template
#'
#' @description
#' Gets a model template.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_model_template/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_model_template/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelId &#91;required&#93; The model ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_model_template
apigatewayv2_get_model_template <- function(ApiId, ModelId) {
  op <- new_operation(
    name = "GetModelTemplate",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/models/{modelId}/template",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_model_template_input(ApiId = ApiId, ModelId = ModelId)
  output <- .apigatewayv2$get_model_template_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_model_template <- apigatewayv2_get_model_template

#' Gets the Models for an API
#'
#' @description
#' Gets the Models for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_models/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_models/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_models
apigatewayv2_get_models <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetModels",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/models",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_models_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_models_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_models <- apigatewayv2_get_models

#' Gets a Route
#'
#' @description
#' Gets a Route.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_route/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_route/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_route
apigatewayv2_get_route <- function(ApiId, RouteId) {
  op <- new_operation(
    name = "GetRoute",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes/{routeId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_route_input(ApiId = ApiId, RouteId = RouteId)
  output <- .apigatewayv2$get_route_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_route <- apigatewayv2_get_route

#' Gets a RouteResponse
#'
#' @description
#' Gets a RouteResponse.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_route_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_route_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseId &#91;required&#93; The route response ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_route_response
apigatewayv2_get_route_response <- function(ApiId, RouteId, RouteResponseId) {
  op <- new_operation(
    name = "GetRouteResponse",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_route_response_input(ApiId = ApiId, RouteId = RouteId, RouteResponseId = RouteResponseId)
  output <- .apigatewayv2$get_route_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_route_response <- apigatewayv2_get_route_response

#' Gets the RouteResponses for a Route
#'
#' @description
#' Gets the RouteResponses for a Route.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_route_responses/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_route_responses/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_route_responses
apigatewayv2_get_route_responses <- function(ApiId, MaxResults = NULL, NextToken = NULL, RouteId) {
  op <- new_operation(
    name = "GetRouteResponses",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_route_responses_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken, RouteId = RouteId)
  output <- .apigatewayv2$get_route_responses_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_route_responses <- apigatewayv2_get_route_responses

#' Gets the Routes for an API
#'
#' @description
#' Gets the Routes for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_routes/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_routes/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_routes
apigatewayv2_get_routes <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetRoutes",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_routes_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_routes_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_routes <- apigatewayv2_get_routes

#' Gets a Stage
#'
#' @description
#' Gets a Stage.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_stage/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_stage/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param StageName &#91;required&#93; The stage name. Stage names can only contain alphanumeric characters,
#' hyphens, and underscores. Maximum length is 128 characters.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_stage
apigatewayv2_get_stage <- function(ApiId, StageName) {
  op <- new_operation(
    name = "GetStage",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/stages/{stageName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_stage_input(ApiId = ApiId, StageName = StageName)
  output <- .apigatewayv2$get_stage_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_stage <- apigatewayv2_get_stage

#' Gets the Stages for an API
#'
#' @description
#' Gets the Stages for an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_stages/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_stages/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_stages
apigatewayv2_get_stages <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetStages",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/stages",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_stages_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_stages_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_stages <- apigatewayv2_get_stages

#' Gets a collection of Tag resources
#'
#' @description
#' Gets a collection of Tag resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_tags/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource ARN for the tag.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_tags
apigatewayv2_get_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "GET",
    http_path = "/v2/tags/{resource-arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_tags_input(ResourceArn = ResourceArn)
  output <- .apigatewayv2$get_tags_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_tags <- apigatewayv2_get_tags

#' Gets a VPC link
#'
#' @description
#' Gets a VPC link.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_vpc_link/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_vpc_link/) for full documentation.
#'
#' @param VpcLinkId &#91;required&#93; The ID of the VPC link.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_vpc_link
apigatewayv2_get_vpc_link <- function(VpcLinkId) {
  op <- new_operation(
    name = "GetVpcLink",
    http_method = "GET",
    http_path = "/v2/vpclinks/{vpcLinkId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_vpc_link_input(VpcLinkId = VpcLinkId)
  output <- .apigatewayv2$get_vpc_link_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_vpc_link <- apigatewayv2_get_vpc_link

#' Gets a collection of VPC links
#'
#' @description
#' Gets a collection of VPC links.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_get_vpc_links/](https://www.paws-r-sdk.com/docs/apigatewayv2_get_vpc_links/) for full documentation.
#'
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_vpc_links
apigatewayv2_get_vpc_links <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetVpcLinks",
    http_method = "GET",
    http_path = "/v2/vpclinks",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$get_vpc_links_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_vpc_links_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_vpc_links <- apigatewayv2_get_vpc_links

#' Imports an API
#'
#' @description
#' Imports an API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_import_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_import_api/) for full documentation.
#'
#' @param Basepath Specifies how to interpret the base path of the API during import. Valid
#' values are ignore, prepend, and split. The default value is ignore. To
#' learn more, see [Set the OpenAPI basePath
#' Property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html).
#' Supported only for HTTP APIs.
#' @param Body &#91;required&#93; The OpenAPI definition. Supported only for HTTP APIs.
#' @param FailOnWarnings Specifies whether to rollback the API creation when a warning is
#' encountered. By default, API creation continues if a warning is
#' encountered.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_import_api
apigatewayv2_import_api <- function(Basepath = NULL, Body, FailOnWarnings = NULL) {
  op <- new_operation(
    name = "ImportApi",
    http_method = "PUT",
    http_path = "/v2/apis",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$import_api_input(Basepath = Basepath, Body = Body, FailOnWarnings = FailOnWarnings)
  output <- .apigatewayv2$import_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$import_api <- apigatewayv2_import_api

#' Puts an Api resource
#'
#' @description
#' Puts an Api resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_reimport_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_reimport_api/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param Basepath Specifies how to interpret the base path of the API during import. Valid
#' values are ignore, prepend, and split. The default value is ignore. To
#' learn more, see [Set the OpenAPI basePath
#' Property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html).
#' Supported only for HTTP APIs.
#' @param Body &#91;required&#93; The OpenAPI definition. Supported only for HTTP APIs.
#' @param FailOnWarnings Specifies whether to rollback the API creation when a warning is
#' encountered. By default, API creation continues if a warning is
#' encountered.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_reimport_api
apigatewayv2_reimport_api <- function(ApiId, Basepath = NULL, Body, FailOnWarnings = NULL) {
  op <- new_operation(
    name = "ReimportApi",
    http_method = "PUT",
    http_path = "/v2/apis/{apiId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$reimport_api_input(ApiId = ApiId, Basepath = Basepath, Body = Body, FailOnWarnings = FailOnWarnings)
  output <- .apigatewayv2$reimport_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$reimport_api <- apigatewayv2_reimport_api

#' Creates a new Tag resource to represent a tag
#'
#' @description
#' Creates a new Tag resource to represent a tag.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_tag_resource/](https://www.paws-r-sdk.com/docs/apigatewayv2_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource ARN for the tag.
#' @param Tags The collection of tags. Each tag element is associated with a given
#' resource.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_tag_resource
apigatewayv2_tag_resource <- function(ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v2/tags/{resource-arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .apigatewayv2$tag_resource_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$tag_resource <- apigatewayv2_tag_resource

#' Deletes a Tag
#'
#' @description
#' Deletes a Tag.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_untag_resource/](https://www.paws-r-sdk.com/docs/apigatewayv2_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource ARN for the tag.
#' @param TagKeys &#91;required&#93; The Tag keys to delete
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_untag_resource
apigatewayv2_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v2/tags/{resource-arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .apigatewayv2$untag_resource_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$untag_resource <- apigatewayv2_untag_resource

#' Updates an Api resource
#'
#' @description
#' Updates an Api resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_api/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_api/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiKeySelectionExpression An API key selection expression. Supported only for WebSocket APIs. See
#' [API Key Selection
#' Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
#' @param CorsConfiguration A CORS configuration. Supported only for HTTP APIs.
#' @param CredentialsArn This property is part of quick create. It specifies the credentials
#' required for the integration, if any. For a Lambda integration, three
#' options are available. To specify an IAM Role for API Gateway to assume,
#' use the role's Amazon Resource Name (ARN). To require that the caller's
#' identity be passed through from the request, specify
#' arn:aws:iam::*:user/*. To use resource-based permissions on supported
#' AWS services, don't specify this parameter. Currently, this property is
#' not used for HTTP integrations. If provided, this value replaces the
#' credentials associated with the quick create integration. Supported only
#' for HTTP APIs.
#' @param Description The description of the API.
#' @param DisableSchemaValidation Avoid validating models when creating a deployment. Supported only for
#' WebSocket APIs.
#' @param DisableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default
#' execute-api endpoint. By default, clients can invoke your API with the
#' default https://\{api_id\}.execute-api.\{region\}.amazonaws.com
#' endpoint. To require that clients use a custom domain name to invoke
#' your API, disable the default endpoint.
#' @param Name The name of the API.
#' @param RouteKey This property is part of quick create. If not specified, the route
#' created using quick create is kept. Otherwise, this value replaces the
#' route key of the quick create route. Additional routes may still be
#' added after the API is updated. Supported only for HTTP APIs.
#' @param RouteSelectionExpression The route selection expression for the API. For HTTP APIs, the
#' routeSelectionExpression must be $\{request.method\}
#' $\{request.path\}. If not provided, this will be the default for HTTP
#' APIs. This property is required for WebSocket APIs.
#' @param Target This property is part of quick create. For HTTP integrations, specify a
#' fully qualified URL. For Lambda integrations, specify a function ARN.
#' The type of the integration will be HTTP_PROXY or AWS_PROXY,
#' respectively. The value provided updates the integration URI and
#' integration type. You can update a quick-created target, but you can't
#' remove it from an API. Supported only for HTTP APIs.
#' @param Version A version identifier for the API.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_api
apigatewayv2_update_api <- function(ApiId, ApiKeySelectionExpression = NULL, CorsConfiguration = NULL, CredentialsArn = NULL, Description = NULL, DisableSchemaValidation = NULL, DisableExecuteApiEndpoint = NULL, Name = NULL, RouteKey = NULL, RouteSelectionExpression = NULL, Target = NULL, Version = NULL) {
  op <- new_operation(
    name = "UpdateApi",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_api_input(ApiId = ApiId, ApiKeySelectionExpression = ApiKeySelectionExpression, CorsConfiguration = CorsConfiguration, CredentialsArn = CredentialsArn, Description = Description, DisableSchemaValidation = DisableSchemaValidation, DisableExecuteApiEndpoint = DisableExecuteApiEndpoint, Name = Name, RouteKey = RouteKey, RouteSelectionExpression = RouteSelectionExpression, Target = Target, Version = Version)
  output <- .apigatewayv2$update_api_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_api <- apigatewayv2_update_api

#' The API mapping
#'
#' @description
#' The API mapping.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_api_mapping/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_api_mapping/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiMappingId &#91;required&#93; The API mapping identifier.
#' @param ApiMappingKey The API mapping key.
#' @param DomainName &#91;required&#93; The domain name.
#' @param Stage The API stage.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_api_mapping
apigatewayv2_update_api_mapping <- function(ApiId, ApiMappingId, ApiMappingKey = NULL, DomainName, Stage = NULL) {
  op <- new_operation(
    name = "UpdateApiMapping",
    http_method = "PATCH",
    http_path = "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_api_mapping_input(ApiId = ApiId, ApiMappingId = ApiMappingId, ApiMappingKey = ApiMappingKey, DomainName = DomainName, Stage = Stage)
  output <- .apigatewayv2$update_api_mapping_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_api_mapping <- apigatewayv2_update_api_mapping

#' Updates an Authorizer
#'
#' @description
#' Updates an Authorizer.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_authorizer/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_authorizer/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerCredentialsArn Specifies the required credentials as an IAM role for API Gateway to
#' invoke the authorizer. To specify an IAM role for API Gateway to assume,
#' use the role's Amazon Resource Name (ARN). To use resource-based
#' permissions on the Lambda function, don't specify this parameter.
#' @param AuthorizerId &#91;required&#93; The authorizer identifier.
#' @param AuthorizerPayloadFormatVersion Specifies the format of the payload sent to an HTTP API Lambda
#' authorizer. Required for HTTP API Lambda authorizers. Supported values
#' are 1.0 and 2.0. To learn more, see [Working with AWS Lambda authorizers
#' for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
#' @param AuthorizerResultTtlInSeconds The time to live (TTL) for cached authorizer results, in seconds. If it
#' equals 0, authorization caching is disabled. If it is greater than 0,
#' API Gateway caches authorizer responses. The maximum value is 3600, or 1
#' hour. Supported only for HTTP API Lambda authorizers.
#' @param AuthorizerType The authorizer type. Specify REQUEST for a Lambda function using
#' incoming request parameters. Specify JWT to use JSON Web Tokens
#' (supported only for HTTP APIs).
#' @param AuthorizerUri The authorizer's Uniform Resource Identifier (URI). For REQUEST
#' authorizers, this must be a well-formed Lambda function URI, for
#' example,
#' arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:\{account_id\}:function:\{lambda_function_name\}/invocations.
#' In general, the URI has this form:
#' arn:aws:apigateway:\{region\}:lambda:path/\{service_api\} , where
#' \{region\} is the same as the region hosting the Lambda function, path
#' indicates that the remaining substring in the URI should be treated as
#' the path to the resource, including the initial /. For Lambda functions,
#' this is usually of the form
#' /2015-03-31/functions/\[FunctionARN\]/invocations. Supported only for
#' REQUEST authorizers.
#' @param EnableSimpleResponses Specifies whether a Lambda authorizer returns a response in a simple
#' format. By default, a Lambda authorizer must return an IAM policy. If
#' enabled, the Lambda authorizer can return a boolean value instead of an
#' IAM policy. Supported only for HTTP APIs. To learn more, see [Working
#' with AWS Lambda authorizers for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html)
#' @param IdentitySource The identity source for which authorization is requested.
#' 
#' For a REQUEST authorizer, this is optional. The value is a set of one or
#' more mapping expressions of the specified request parameters. The
#' identity source can be headers, query string parameters, stage
#' variables, and context parameters. For example, if an Auth header and a
#' Name query string parameter are defined as identity sources, this value
#' is route.request.header.Auth, route.request.querystring.Name for
#' WebSocket APIs. For HTTP APIs, use selection expressions prefixed with
#' $, for example, $request.header.Auth, $request.querystring.Name. These
#' parameters are used to perform runtime validation for Lambda-based
#' authorizers by verifying all of the identity-related request parameters
#' are present in the request, not null, and non-empty. Only when this is
#' true does the authorizer invoke the authorizer Lambda function.
#' Otherwise, it returns a 401 Unauthorized response without calling the
#' Lambda function. For HTTP APIs, identity sources are also used as the
#' cache key when caching is enabled. To learn more, see [Working with AWS
#' Lambda authorizers for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
#' 
#' For JWT, a single entry that specifies where to extract the JSON Web
#' Token (JWT) from inbound requests. Currently only header-based and query
#' parameter-based selections are supported, for example
#' $request.header.Authorization.
#' @param IdentityValidationExpression This parameter is not used.
#' @param JwtConfiguration Represents the configuration of a JWT authorizer. Required for the JWT
#' authorizer type. Supported only for HTTP APIs.
#' @param Name The name of the authorizer.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_authorizer
apigatewayv2_update_authorizer <- function(ApiId, AuthorizerCredentialsArn = NULL, AuthorizerId, AuthorizerPayloadFormatVersion = NULL, AuthorizerResultTtlInSeconds = NULL, AuthorizerType = NULL, AuthorizerUri = NULL, EnableSimpleResponses = NULL, IdentitySource = NULL, IdentityValidationExpression = NULL, JwtConfiguration = NULL, Name = NULL) {
  op <- new_operation(
    name = "UpdateAuthorizer",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/authorizers/{authorizerId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_authorizer_input(ApiId = ApiId, AuthorizerCredentialsArn = AuthorizerCredentialsArn, AuthorizerId = AuthorizerId, AuthorizerPayloadFormatVersion = AuthorizerPayloadFormatVersion, AuthorizerResultTtlInSeconds = AuthorizerResultTtlInSeconds, AuthorizerType = AuthorizerType, AuthorizerUri = AuthorizerUri, EnableSimpleResponses = EnableSimpleResponses, IdentitySource = IdentitySource, IdentityValidationExpression = IdentityValidationExpression, JwtConfiguration = JwtConfiguration, Name = Name)
  output <- .apigatewayv2$update_authorizer_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_authorizer <- apigatewayv2_update_authorizer

#' Updates a Deployment
#'
#' @description
#' Updates a Deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_deployment/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_deployment/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param DeploymentId &#91;required&#93; The deployment ID.
#' @param Description The description for the deployment resource.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_deployment
apigatewayv2_update_deployment <- function(ApiId, DeploymentId, Description = NULL) {
  op <- new_operation(
    name = "UpdateDeployment",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/deployments/{deploymentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_deployment_input(ApiId = ApiId, DeploymentId = DeploymentId, Description = Description)
  output <- .apigatewayv2$update_deployment_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_deployment <- apigatewayv2_update_deployment

#' Updates a domain name
#'
#' @description
#' Updates a domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_domain_name/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_domain_name/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name.
#' @param DomainNameConfigurations The domain name configurations.
#' @param MutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_domain_name
apigatewayv2_update_domain_name <- function(DomainName, DomainNameConfigurations = NULL, MutualTlsAuthentication = NULL) {
  op <- new_operation(
    name = "UpdateDomainName",
    http_method = "PATCH",
    http_path = "/v2/domainnames/{domainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_domain_name_input(DomainName = DomainName, DomainNameConfigurations = DomainNameConfigurations, MutualTlsAuthentication = MutualTlsAuthentication)
  output <- .apigatewayv2$update_domain_name_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_domain_name <- apigatewayv2_update_domain_name

#' Updates an Integration
#'
#' @description
#' Updates an Integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_integration/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_integration/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ConnectionId The ID of the VPC link for a private integration. Supported only for
#' HTTP APIs.
#' @param ConnectionType The type of the network connection to the integration endpoint. Specify
#' INTERNET for connections through the public routable internet or
#' VPC_LINK for private connections between API Gateway and resources in a
#' VPC. The default value is INTERNET.
#' @param ContentHandlingStrategy Supported only for WebSocket APIs. Specifies how to handle response
#' payload content type conversions. Supported values are CONVERT_TO_BINARY
#' and CONVERT_TO_TEXT, with the following behaviors:
#' 
#' CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param CredentialsArn Specifies the credentials required for the integration, if any. For AWS
#' integrations, three options are available. To specify an IAM Role for
#' API Gateway to assume, use the role's Amazon Resource Name (ARN). To
#' require that the caller's identity be passed through from the request,
#' specify the string arn:aws:iam::*:user/*. To use resource-based
#' permissions on supported AWS services, specify null.
#' @param Description The description of the integration
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationMethod Specifies the integration's HTTP method type.
#' @param IntegrationSubtype Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS
#' service action to invoke. To learn more, see [Integration subtype
#' reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html).
#' @param IntegrationType The integration type of an integration. One of the following:
#' 
#' AWS: for integrating the route or method request with an AWS service
#' action, including the Lambda function-invoking action. With the Lambda
#' function-invoking action, this is referred to as the Lambda custom
#' integration. With any other AWS service action, this is known as AWS
#' integration. Supported only for WebSocket APIs.
#' 
#' AWS_PROXY: for integrating the route or method request with a Lambda
#' function or other AWS service action. This integration is also referred
#' to as a Lambda proxy integration.
#' 
#' HTTP: for integrating the route or method request with an HTTP endpoint.
#' This integration is also referred to as the HTTP custom integration.
#' Supported only for WebSocket APIs.
#' 
#' HTTP_PROXY: for integrating the route or method request with an HTTP
#' endpoint, with the client request passed through as-is. This is also
#' referred to as HTTP proxy integration. For HTTP API private
#' integrations, use an HTTP_PROXY integration.
#' 
#' MOCK: for integrating the route or method request with API Gateway as a
#' "loopback" endpoint without invoking any backend. Supported only for
#' WebSocket APIs.
#' @param IntegrationUri For a Lambda integration, specify the URI of a Lambda function.
#' 
#' For an HTTP integration, specify a fully-qualified URL.
#' 
#' For an HTTP API private integration, specify the ARN of an Application
#' Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map
#' service. If you specify the ARN of an AWS Cloud Map service, API Gateway
#' uses DiscoverInstances to identify resources. You can use query
#' parameters to target specific resources. To learn more, see
#' [DiscoverInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html).
#' For private integrations, all resources must be owned by the same AWS
#' account.
#' @param PassthroughBehavior Specifies the pass-through behavior for incoming requests based on the
#' Content-Type header in the request, and the available mapping templates
#' specified as the requestTemplates property on the Integration resource.
#' There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
#' NEVER. Supported only for WebSocket APIs.
#' 
#' WHEN_NO_MATCH passes the request body for unmapped content types through
#' to the integration backend without transformation.
#' 
#' NEVER rejects unmapped content types with an HTTP 415 Unsupported Media
#' Type response.
#' 
#' WHEN_NO_TEMPLATES allows pass-through when the integration has no
#' content types mapped to templates. However, if there is at least one
#' content type defined, unmapped content types will be rejected with the
#' same HTTP 415 Unsupported Media Type response.
#' @param PayloadFormatVersion Specifies the format of the payload sent to an integration. Required for
#' HTTP APIs. Supported values for Lambda proxy integrations are 1.0 and
#' 2.0. For all other integrations, 1.0 is the only supported value. To
#' learn more, see [Working with AWS Lambda proxy integrations for HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html).
#' @param RequestParameters For WebSocket APIs, a key-value map specifying request parameters that
#' are passed from the method request to the backend. The key is an
#' integration request parameter name and the associated value is a method
#' request parameter value or static value that must be enclosed within
#' single quotes and pre-encoded as required by the backend. The method
#' request parameter value must match the pattern of
#' method.request.\{location\}.\{name\} , where \{location\} is
#' querystring, path, or header; and \{name\} must be a valid and unique
#' method request parameter name.
#' 
#' For HTTP API integrations with a specified integrationSubtype, request
#' parameters are a key-value map specifying parameters that are passed to
#' AWS_PROXY integrations. You can provide static values, or map request
#' data, stage variables, or context variables that are evaluated at
#' runtime. To learn more, see [Working with AWS service integrations for
#' HTTP
#' APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html).
#' 
#' For HTTP API integrations, without a specified integrationSubtype
#' request parameters are a key-value map specifying how to transform HTTP
#' requests before sending them to the backend. The key should follow the
#' pattern \<action\>:\<header|querystring|path\>.\<location\> where action
#' can be append, overwrite or remove. For values, you can provide static
#' values, or map request data, stage variables, or context variables that
#' are evaluated at runtime. To learn more, see [Transforming API requests
#' and
#' responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
#' @param RequestTemplates Represents a map of Velocity templates that are applied on the request
#' payload based on the value of the Content-Type header sent by the
#' client. The content type value is the key in this map, and the template
#' (as a String) is the value. Supported only for WebSocket APIs.
#' @param ResponseParameters Supported only for HTTP APIs. You use response parameters to transform
#' the HTTP response from a backend integration before returning the
#' response to clients. Specify a key-value map from a selection key to
#' response parameters. The selection key must be a valid HTTP status code
#' within the range of 200-599. Response parameters are a key-value map.
#' The key must match pattern \<action\>:\<header\>.\<location\> or
#' overwrite.statuscode. The action can be append, overwrite or remove. The
#' value can be a static value, or map to response data, stage variables,
#' or context variables that are evaluated at runtime. To learn more, see
#' [Transforming API requests and
#' responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
#' @param TemplateSelectionExpression The template selection expression for the integration.
#' @param TimeoutInMillis Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and
#' between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is
#' 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
#' @param TlsConfig The TLS configuration for a private integration. If you specify a TLS
#' configuration, private integration traffic uses the HTTPS protocol.
#' Supported only for HTTP APIs.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_integration
apigatewayv2_update_integration <- function(ApiId, ConnectionId = NULL, ConnectionType = NULL, ContentHandlingStrategy = NULL, CredentialsArn = NULL, Description = NULL, IntegrationId, IntegrationMethod = NULL, IntegrationSubtype = NULL, IntegrationType = NULL, IntegrationUri = NULL, PassthroughBehavior = NULL, PayloadFormatVersion = NULL, RequestParameters = NULL, RequestTemplates = NULL, ResponseParameters = NULL, TemplateSelectionExpression = NULL, TimeoutInMillis = NULL, TlsConfig = NULL) {
  op <- new_operation(
    name = "UpdateIntegration",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_integration_input(ApiId = ApiId, ConnectionId = ConnectionId, ConnectionType = ConnectionType, ContentHandlingStrategy = ContentHandlingStrategy, CredentialsArn = CredentialsArn, Description = Description, IntegrationId = IntegrationId, IntegrationMethod = IntegrationMethod, IntegrationSubtype = IntegrationSubtype, IntegrationType = IntegrationType, IntegrationUri = IntegrationUri, PassthroughBehavior = PassthroughBehavior, PayloadFormatVersion = PayloadFormatVersion, RequestParameters = RequestParameters, RequestTemplates = RequestTemplates, ResponseParameters = ResponseParameters, TemplateSelectionExpression = TemplateSelectionExpression, TimeoutInMillis = TimeoutInMillis, TlsConfig = TlsConfig)
  output <- .apigatewayv2$update_integration_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_integration <- apigatewayv2_update_integration

#' Updates an IntegrationResponses
#'
#' @description
#' Updates an IntegrationResponses.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_integration_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_integration_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentHandlingStrategy Supported only for WebSocket APIs. Specifies how to handle response
#' payload content type conversions. Supported values are CONVERT_TO_BINARY
#' and CONVERT_TO_TEXT, with the following behaviors:
#' 
#' CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseId &#91;required&#93; The integration response ID.
#' @param IntegrationResponseKey The integration response key.
#' @param ResponseParameters A key-value map specifying response parameters that are passed to the
#' method response from the backend. The key is a method response header
#' parameter name and the mapped value is an integration response header
#' value, a static value enclosed within a pair of single quotes, or a JSON
#' expression from the integration response body. The mapping key must
#' match the pattern of method.response.header.\{name\} , where name is a
#' valid and unique header name. The mapped non-static value must match the
#' pattern of integration.response.header.\{name\} or
#' integration.response.body.\{JSON-expression\} , where \{name\} is a
#' valid and unique response header name and \{JSON-expression\} is a
#' valid JSON expression without the $ prefix.
#' @param ResponseTemplates The collection of response templates for the integration response as a
#' string-to-string map of key-value pairs. Response templates are
#' represented as a key/value map, with a content-type as the key and a
#' template as the value.
#' @param TemplateSelectionExpression The template selection expression for the integration response.
#' Supported only for WebSocket APIs.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_integration_response
apigatewayv2_update_integration_response <- function(ApiId, ContentHandlingStrategy = NULL, IntegrationId, IntegrationResponseId, IntegrationResponseKey = NULL, ResponseParameters = NULL, ResponseTemplates = NULL, TemplateSelectionExpression = NULL) {
  op <- new_operation(
    name = "UpdateIntegrationResponse",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_integration_response_input(ApiId = ApiId, ContentHandlingStrategy = ContentHandlingStrategy, IntegrationId = IntegrationId, IntegrationResponseId = IntegrationResponseId, IntegrationResponseKey = IntegrationResponseKey, ResponseParameters = ResponseParameters, ResponseTemplates = ResponseTemplates, TemplateSelectionExpression = TemplateSelectionExpression)
  output <- .apigatewayv2$update_integration_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_integration_response <- apigatewayv2_update_integration_response

#' Updates a Model
#'
#' @description
#' Updates a Model.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_model/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_model/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentType The content-type for the model, for example, "application/json".
#' @param Description The description of the model.
#' @param ModelId &#91;required&#93; The model ID.
#' @param Name The name of the model.
#' @param Schema The schema for the model. For application/json models, this should be
#' JSON schema draft 4 model.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_model
apigatewayv2_update_model <- function(ApiId, ContentType = NULL, Description = NULL, ModelId, Name = NULL, Schema = NULL) {
  op <- new_operation(
    name = "UpdateModel",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/models/{modelId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_model_input(ApiId = ApiId, ContentType = ContentType, Description = Description, ModelId = ModelId, Name = Name, Schema = Schema)
  output <- .apigatewayv2$update_model_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_model <- apigatewayv2_update_model

#' Updates a Route
#'
#' @description
#' Updates a Route.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_route/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_route/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiKeyRequired Specifies whether an API key is required for the route. Supported only
#' for WebSocket APIs.
#' @param AuthorizationScopes The authorization scopes supported by this route.
#' @param AuthorizationType The authorization type for the route. For WebSocket APIs, valid values
#' are NONE for open access, AWS_IAM for using AWS IAM permissions, and
#' CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are
#' NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using
#' AWS IAM permissions, and CUSTOM for using a Lambda authorizer.
#' @param AuthorizerId The identifier of the Authorizer resource to be associated with this
#' route. The authorizer identifier is generated by API Gateway when you
#' created the authorizer.
#' @param ModelSelectionExpression The model selection expression for the route. Supported only for
#' WebSocket APIs.
#' @param OperationName The operation name for the route.
#' @param RequestModels The request models for the route. Supported only for WebSocket APIs.
#' @param RequestParameters The request parameters for the route. Supported only for WebSocket APIs.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteKey The route key for the route.
#' @param RouteResponseSelectionExpression The route response selection expression for the route. Supported only
#' for WebSocket APIs.
#' @param Target The target for the route.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_route
apigatewayv2_update_route <- function(ApiId, ApiKeyRequired = NULL, AuthorizationScopes = NULL, AuthorizationType = NULL, AuthorizerId = NULL, ModelSelectionExpression = NULL, OperationName = NULL, RequestModels = NULL, RequestParameters = NULL, RouteId, RouteKey = NULL, RouteResponseSelectionExpression = NULL, Target = NULL) {
  op <- new_operation(
    name = "UpdateRoute",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/routes/{routeId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_route_input(ApiId = ApiId, ApiKeyRequired = ApiKeyRequired, AuthorizationScopes = AuthorizationScopes, AuthorizationType = AuthorizationType, AuthorizerId = AuthorizerId, ModelSelectionExpression = ModelSelectionExpression, OperationName = OperationName, RequestModels = RequestModels, RequestParameters = RequestParameters, RouteId = RouteId, RouteKey = RouteKey, RouteResponseSelectionExpression = RouteResponseSelectionExpression, Target = Target)
  output <- .apigatewayv2$update_route_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_route <- apigatewayv2_update_route

#' Updates a RouteResponse
#'
#' @description
#' Updates a RouteResponse.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_route_response/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_route_response/) for full documentation.
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelSelectionExpression The model selection expression for the route response. Supported only
#' for WebSocket APIs.
#' @param ResponseModels The response models for the route response.
#' @param ResponseParameters The route response parameters.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseId &#91;required&#93; The route response ID.
#' @param RouteResponseKey The route response key.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_route_response
apigatewayv2_update_route_response <- function(ApiId, ModelSelectionExpression = NULL, ResponseModels = NULL, ResponseParameters = NULL, RouteId, RouteResponseId, RouteResponseKey = NULL) {
  op <- new_operation(
    name = "UpdateRouteResponse",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_route_response_input(ApiId = ApiId, ModelSelectionExpression = ModelSelectionExpression, ResponseModels = ResponseModels, ResponseParameters = ResponseParameters, RouteId = RouteId, RouteResponseId = RouteResponseId, RouteResponseKey = RouteResponseKey)
  output <- .apigatewayv2$update_route_response_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_route_response <- apigatewayv2_update_route_response

#' Updates a Stage
#'
#' @description
#' Updates a Stage.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_stage/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_stage/) for full documentation.
#'
#' @param AccessLogSettings Settings for logging access in this stage.
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AutoDeploy Specifies whether updates to an API automatically trigger a new
#' deployment. The default value is false.
#' @param ClientCertificateId The identifier of a client certificate for a Stage.
#' @param DefaultRouteSettings The default route settings for the stage.
#' @param DeploymentId The deployment identifier for the API stage. Can't be updated if
#' autoDeploy is enabled.
#' @param Description The description for the API stage.
#' @param RouteSettings Route settings for the stage.
#' @param StageName &#91;required&#93; The stage name. Stage names can contain only alphanumeric characters,
#' hyphens, and underscores, or be $default. Maximum length is 128
#' characters.
#' @param StageVariables A map that defines the stage variables for a Stage. Variable names can
#' have alphanumeric and underscore characters, and the values must match
#' \[A-Za-z0-9-._~:/?#&=,\]+.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_stage
apigatewayv2_update_stage <- function(AccessLogSettings = NULL, ApiId, AutoDeploy = NULL, ClientCertificateId = NULL, DefaultRouteSettings = NULL, DeploymentId = NULL, Description = NULL, RouteSettings = NULL, StageName, StageVariables = NULL) {
  op <- new_operation(
    name = "UpdateStage",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/stages/{stageName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_stage_input(AccessLogSettings = AccessLogSettings, ApiId = ApiId, AutoDeploy = AutoDeploy, ClientCertificateId = ClientCertificateId, DefaultRouteSettings = DefaultRouteSettings, DeploymentId = DeploymentId, Description = Description, RouteSettings = RouteSettings, StageName = StageName, StageVariables = StageVariables)
  output <- .apigatewayv2$update_stage_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_stage <- apigatewayv2_update_stage

#' Updates a VPC link
#'
#' @description
#' Updates a VPC link.
#'
#' See [https://www.paws-r-sdk.com/docs/apigatewayv2_update_vpc_link/](https://www.paws-r-sdk.com/docs/apigatewayv2_update_vpc_link/) for full documentation.
#'
#' @param Name The name of the VPC link.
#' @param VpcLinkId &#91;required&#93; The ID of the VPC link.
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_vpc_link
apigatewayv2_update_vpc_link <- function(Name = NULL, VpcLinkId) {
  op <- new_operation(
    name = "UpdateVpcLink",
    http_method = "PATCH",
    http_path = "/v2/vpclinks/{vpcLinkId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .apigatewayv2$update_vpc_link_input(Name = Name, VpcLinkId = VpcLinkId)
  output <- .apigatewayv2$update_vpc_link_output()
  config <- get_config()
  svc <- .apigatewayv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_vpc_link <- apigatewayv2_update_vpc_link
