% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_describe_route}
\alias{appmesh_describe_route}
\title{Describes an existing route}
\usage{
appmesh_describe_route(
  meshName,
  meshOwner = NULL,
  routeName,
  virtualRouterName
)
}
\arguments{
\item{meshName}{[required] The name of the service mesh that the route resides in.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then it's the ID of the account that shared
the mesh with your account. For more information about mesh sharing, see
\href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{routeName}{[required] The name of the route to describe.}

\item{virtualRouterName}{[required] The name of the virtual router that the route is associated with.}
}
\description{
Describes an existing route.

See \url{https://www.paws-r-sdk.com/docs/appmesh_describe_route/} for full documentation.
}
\keyword{internal}
