% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_start_route_analysis}
\alias{networkmanager_start_route_analysis}
\title{Starts analyzing the routing path between the specified source and
destination}
\usage{
networkmanager_start_route_analysis(
  GlobalNetworkId,
  Source,
  Destination,
  IncludeReturnPath = NULL,
  UseMiddleboxes = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{Source}{[required] The source from which traffic originates.}

\item{Destination}{[required] The destination.}

\item{IncludeReturnPath}{Indicates whether to analyze the return path. The default is \code{false}.}

\item{UseMiddleboxes}{Indicates whether to include the location of middlebox appliances in the
route analysis. The default is \code{false}.}
}
\description{
Starts analyzing the routing path between the specified source and destination. For more information, see \href{https://docs.aws.amazon.com/network-manager/latest/tgwnm/route-analyzer.html}{Route Analyzer}.

See \url{https://www.paws-r-sdk.com/docs/networkmanager_start_route_analysis/} for full documentation.
}
\keyword{internal}
