% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_put_bucket_policy}
\alias{s3control_put_bucket_policy}
\title{This action puts a bucket policy to an Amazon S3 on Outposts bucket}
\usage{
s3control_put_bucket_policy(
  AccountId,
  Bucket,
  ConfirmRemoveSelfBucketAccess = NULL,
  Policy
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID of the Outposts bucket.}

\item{Bucket}{[required] Specifies the bucket.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the Amazon Web
Services SDK and CLI, you must specify the ARN of the bucket accessed in
the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>}.
For example, to access the bucket \code{reports} through Outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}

\item{ConfirmRemoveSelfBucketAccess}{Set this parameter to true to confirm that you want to remove your
permissions to change this bucket policy in the future.

This is not supported by Amazon S3 on Outposts buckets.}

\item{Policy}{[required] The bucket policy as a JSON document.}
}
\description{
This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see \code{\link[=s3control_put_bucket_policy]{put_bucket_policy}} in the \emph{Amazon S3 API Reference}.

See \url{https://www.paws-r-sdk.com/docs/s3control_put_bucket_policy/} for full documentation.
}
\keyword{internal}
