\name{summary.pblm}
\alias{summary.pblm}
\alias{print.pblm}
\alias{print.summary.pblm}
\alias{AIC.pblm}
\alias{logLik.pblm}
\alias{vcov.pblm}
\alias{coef.pblm}
\alias{coefficients.pblm}
\alias{edf.pblm}
\alias{residuals.pblm}
\alias{resid.pblm}
\alias{fitted.pblm}
\alias{predict.pblm}
\alias{deviance.pblm}
\alias{se.smooth.pblm}
\alias{chisq.test.pblm}
\alias{Rsq.pblm}
\title{Summarizing methods for bivariate additive logistic regression}
\description{
  Summarizing methods anf functions for objects of class \code{pblm}.
}
\usage{
\method{summary}{pblm}(object,...)
 
\method{print}{pblm}(x,digits = max(3, getOption("digits") - 3),...)

\method{print}{summary.pblm}(x,digits = max(3, getOption("digits") - 3),...) 
 
\method{AIC}{pblm}(object,...,k=2) 

\method{logLik}{pblm}(object, penalized=FALSE,...)

\method{vcov}{pblm}(object,...)

\method{coef}{pblm}(object, digits = max(3, getOption("digits") - 3), ...)

\method{coefficients}{pblm}(object, digits = max(3, getOption("digits") - 3), ...)

\method{residuals}{pblm}(object, type = c("working", "pearson"),...)

\method{resid}{pblm}(object, type = c("working", "pearson"),...)

\method{fitted}{pblm}(object,...)

\method{predict}{pblm}(object, newdata, type=c("link","response","terms","count"), 
                  se.fit=FALSE, digits= max(6, getOption("digits") - 3),...)

\method{deviance}{pblm}(object, penalized=FALSE,...)

edf.pblm(object, which.eq=1, which.var=1 )
chisq.test.pblm(obj)
se.smooth.pblm(object)
Rsq.pblm(object, type = c("McFadden", "Cox Snell", "Cragg Uhler", "all"))
}
\arguments{
  \item{object, obj}{An object of class \code{pblm}.}
  \item{digits}{Integer controlling the number of digits printed in the output.}
  \item{x}{An object produced by \code{pblm} or \code{summary.pblm} to be printed.}
  \item{k}{Numeric; the penalty per parameter to be used. By default \code{k = 2}, corresponding to the classical AIC.}
  \item{penalized}{Logical indicating whether the value of the penalized log-likelihood is required.}
  \item{which.var}{Index indicating the position of the smoother as it appears in the model formula.}
  \item{which.eq}{Equation index for the smoothers.}
  \item{newdata}{Optional data frame with new values of the model covariates.}
  \item{type}{The type of residuals, predictions, or pseudo R-squared desired.}
  \item{se.fit}{Logical. Should prediction standard errors be returned? Currently available only for \code{type = "link"} or \code{type = "terms"} when \code{newdata} is not specified, and only for \code{type = "link"} when \code{newdata} is specified.}
  \item{\dots}{Further arguments passed to or from other methods.}
}

\details{
\code{fitted.pblm} is equivalent to \code{predict.pblm} specifying \code{type="response"}.
\code{chisq.test.pblm} performs the \eqn{\chi^2} and \eqn{G^2} tests. 
\code{Rsq.pblm} calculates pseudo R-squared.  
}

\value{
\code{print.pblm} return an object of class "pblm".
\code{print.summary.pblm} return an object of class "summary.pblm".
\code{summary.pblm} returns a list with the following components:
  \item{results}{A \eqn{p \times 4} data frame with columns for the estimated coefficient, its standard error, z-statistic, and corresponding (two-sided) p-value.}
  \item{convergence}{Logical flag indicating whether the algorithm converged.}
  \item{iter}{Number of iterations performed in the model fitting.}
  \item{logLik}{Log-likelihood value at convergence.}
  \item{logLikp}{Penalized log-likelihood of the fitted model.}
  \item{AIC}{Akaike Information Criterion of the fitted model.}
  \item{gAIC}{Generalized AIC of the fitted model.}
  \item{BIC}{Bayesian Information Criterion of the fitted model.}
  \item{gaic.m}{Penalty coefficient used in the gAIC.}
  \item{np1, np2}{Number of parameters estimated in the first and second marginal, respectively.}
  \item{deviance}{Model deviance.}
  \item{names}{A character vector of length two containing the names of the response variables.}
  \item{df.res}{Residual degrees of freedom.}
  \item{df.tot}{Total degrees of freedom of the model.}
  \item{df.fix}{Degrees of freedom associated with the fixed part of the model.}
  \item{df.smooth}{Effective degrees of freedom of the smoothers in the model, if any.}
  \item{res.smooth}{A data frame reporting an approximate chi-squared test for the smooth terms. If the effective degrees of freedom are far from the fixed ones, consider re-fitting the model by reducing \code{pgtol.df} in \code{pblm.control}, via the \code{control} argument.}
  \item{smoother}{Logical. \code{TRUE} if smooth terms were used in the model.}
  \item{pnl.type}{Penalty type as specified in the fitted \code{object}.}
  \item{PR}{A matrix with residuals summarized by row, one per model equation.}
  \item{which.term}{A list. For internal use.}
  \item{respStr}{A matrix. For internal use.}
  \item{label1, label2}{Names of the two response variables, respectively.}
  \item{call}{Matched call from the fitted \code{object}.}

\code{coef.pblm, coefficients.pblm} return a numeric vector of estimated coefficient.

\code{edf.pblm} returns a scalar with the effective degrees of freedom for a specified smooth term.

\code{vcov.pblm} returns the variance-covariance matrix.

If \code{se.fit = FALSE}, the method \code{predict.pblm} returns a data frame with predicted values according to the specified prediction \code{type}. If \code{se.fit = TRUE}, a list of length two is returned with the following components:
  \item{fit}{Data frame of predicted values for each linear predictor, according to the specified prediction type.}
  \item{se.fit}{Associated data frame of standard errors.}

\code{resid.pblm, residuals.pblm} return a data frame with the specified type of residuals.

\code{se.smooth.pblm} returns a list of length three, containing the standard errors and the lower and upper bounds of the 95\% confidence intervals for the smooth terms.

\code{chisq.test.pblm} returns a list of length two containing the results of the \eqn{\chi^2} and \eqn{G^2} tests.

\code{Rsq.pblm} returns a scalar, or a list if \code{type="both"} is selected.

\code{AIC.pblm} returns a scalar with several attributes, with printed AIC and df. 
If more objects are passed as arguments, it returns a data frame.

\code{logLik, deviance} return a scalar.
}

\author{Marco Enea}
\seealso{ \code{\link{pblm}}, \code{\link{pb}}}
\examples{

#NOT RUN 
## Example 1
#The Dale's model 
data(ulcer)
m1 <- pblm(fo1=cbind(pain,medication)~1, fo12=~I(operation=="vh"), RC.fo=~Col,
           data=ulcer, weights=freq,  contrasts=list(Col="contr.SAS"))
summary(m1)
deviance(m1)
predict(m1,type="response")


#the same data but in another format
#compare with Dale (1986), Table 3
dat <- multicolumn(freq~medication+pain+operation,data=ulcer)
fo <- as.formula(paste(attributes(dat)$"resp","~1",sep=""))
m1bis <- pblm(fo1=fo, fo12=~I(operation=="vh"), RC.fo=~Col, verbose=TRUE,
              data=dat, ncat1=3, contrasts=list(Col="contr.SAS"))
deviance(m1bis)
chisq.test.pblm(m1bis)
Rsq.pblm(m1bis)

# Example 2. An artificial data set: 
set.seed(10)
da <- expand.grid("Y1"=1:3,"Y2"=1:3,"fat1"=0:4,"fat2"=0:1)
da$Freq <- sample(1:20,3*3*5*2,replace=TRUE)
da$x1 <- rnorm(90)

#the bivariate additive proportional-odds model
m2 <- pblm(fo1=cbind(Y1,Y2) ~ fat1 + pb(x1), data=da, weights=Freq)
summary(m2)



}
\keyword{ multivariate }
\keyword{ regression }
\keyword{ models }
\keyword{ nonparametric }
\keyword{ smooth }
