// Generated by rstantools.  Do not edit by hand.

/*
    pcFactorStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pcFactorStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pcFactorStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_factor_ll_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'factor_ll', line 150, column 2 to column 36)",
                                                      " (in 'factor_ll', line 151, column 2 to column 56)",
                                                      " (in 'factor_ll', line 152, column 2 to column 41)",
                                                      " (in 'factor_ll', line 153, column 2 to column 33)",
                                                      " (in 'factor_ll', line 154, column 2 to column 46)",
                                                      " (in 'factor_ll', line 155, column 2 to column 36)",
                                                      " (in 'factor_ll', line 156, column 2 to column 44)",
                                                      " (in 'factor_ll', line 159, column 2 to column 36)",
                                                      " (in 'factor_ll', line 160, column 2 to column 35)",
                                                      " (in 'factor_ll', line 161, column 2 to column 36)",
                                                      " (in 'factor_ll', line 162, column 2 to column 27)",
                                                      " (in 'factor_ll', line 163, column 2 to column 29)",
                                                      " (in 'factor_ll', line 164, column 2 to column 51)",
                                                      " (in 'factor_ll', line 166, column 4 to column 59)",
                                                      " (in 'factor_ll', line 167, column 4 to column 53)",
                                                      " (in 'factor_ll', line 165, column 23 to line 168, column 3)",
                                                      " (in 'factor_ll', line 165, column 2 to line 168, column 3)",
                                                      " (in 'factor_ll', line 170, column 25 to column 57)",
                                                      " (in 'factor_ll', line 170, column 4 to column 57)",
                                                      " (in 'factor_ll', line 169, column 25 to line 171, column 3)",
                                                      " (in 'factor_ll', line 169, column 2 to line 171, column 3)",
                                                      " (in 'factor_ll', line 172, column 2 to column 38)",
                                                      " (in 'factor_ll', line 174, column 4 to column 34)",
                                                      " (in 'factor_ll', line 175, column 4 to column 34)",
                                                      " (in 'factor_ll', line 176, column 11 to column 14)",
                                                      " (in 'factor_ll', line 176, column 4 to column 67)",
                                                      " (in 'factor_ll', line 177, column 4 to column 51)",
                                                      " (in 'factor_ll', line 178, column 4 to column 25)",
                                                      " (in 'factor_ll', line 173, column 23 to line 179, column 3)",
                                                      " (in 'factor_ll', line 173, column 2 to line 179, column 3)",
                                                      " (in 'factor_ll', line 181, column 4 to column 34)",
                                                      " (in 'factor_ll', line 182, column 4 to column 34)",
                                                      " (in 'factor_ll', line 183, column 4 to column 19)",
                                                      " (in 'factor_ll', line 184, column 4 to column 14)",
                                                      " (in 'factor_ll', line 189, column 8 to column 43)",
                                                      " (in 'factor_ll', line 188, column 13 to line 190, column 7)",
                                                      " (in 'factor_ll', line 187, column 8 to column 41)",
                                                      " (in 'factor_ll', line 186, column 22 to line 188, column 7)",
                                                      " (in 'factor_ll', line 186, column 6 to line 190, column 7)",
                                                      " (in 'factor_ll', line 185, column 31 to line 191, column 5)",
                                                      " (in 'factor_ll', line 185, column 4 to line 191, column 5)",
                                                      " (in 'factor_ll', line 192, column 4 to column 44)",
                                                      " (in 'factor_ll', line 180, column 23 to line 193, column 3)",
                                                      " (in 'factor_ll', line 180, column 2 to line 193, column 3)",
                                                      " (in 'factor_ll', line 195, column 4 to column 53)",
                                                      " (in 'factor_ll', line 196, column 4 to column 27)",
                                                      " (in 'factor_ll', line 197, column 4 to column 43)",
                                                      " (in 'factor_ll', line 198, column 4 to column 57)",
                                                      " (in 'factor_ll', line 199, column 4 to column 59)",
                                                      " (in 'factor_ll', line 194, column 23 to line 200, column 3)",
                                                      " (in 'factor_ll', line 194, column 2 to line 200, column 3)",
                                                      " (in 'factor_ll', line 230, column 2 to column 24)",
                                                      " (in 'factor_ll', line 231, column 2 to column 40)",
                                                      " (in 'factor_ll', line 232, column 2 to column 45)",
                                                      " (in 'factor_ll', line 233, column 2 to column 40)",
                                                      " (in 'factor_ll', line 234, column 2 to column 53)",
                                                      " (in 'factor_ll', line 236, column 11 to column 14)",
                                                      " (in 'factor_ll', line 236, column 15 to column 21)",
                                                      " (in 'factor_ll', line 236, column 4 to column 32)",
                                                      " (in 'factor_ll', line 238, column 6 to column 64)",
                                                      " (in 'factor_ll', line 239, column 6 to column 43)",
                                                      " (in 'factor_ll', line 240, column 6 to column 41)",
                                                      " (in 'factor_ll', line 237, column 25 to line 241, column 5)",
                                                      " (in 'factor_ll', line 237, column 4 to line 241, column 5)",
                                                      " (in 'factor_ll', line 242, column 4 to column 42)",
                                                      " (in 'factor_ll', line 243, column 4 to column 94)",
                                                      " (in 'factor_ll', line 235, column 2 to line 244, column 3)",
                                                      " (in 'factor_ll', line 246, column 11 to column 17)",
                                                      " (in 'factor_ll', line 246, column 4 to column 52)",
                                                      " (in 'factor_ll', line 247, column 10 to column 18)",
                                                      " (in 'factor_ll', line 247, column 4 to column 38)",
                                                      " (in 'factor_ll', line 248, column 10 to column 18)",
                                                      " (in 'factor_ll', line 248, column 4 to column 40)",
                                                      " (in 'factor_ll', line 249, column 27 to column 49)",
                                                      " (in 'factor_ll', line 249, column 4 to column 49)",
                                                      " (in 'factor_ll', line 251, column 6 to column 36)",
                                                      " (in 'factor_ll', line 252, column 6 to column 36)",
                                                      " (in 'factor_ll', line 254, column 8 to column 30)",
                                                      " (in 'factor_ll', line 255, column 8 to column 52)",
                                                      " (in 'factor_ll', line 253, column 34 to line 256, column 7)",
                                                      " (in 'factor_ll', line 253, column 6 to line 256, column 7)",
                                                      " (in 'factor_ll', line 258, column 8 to column 45)",
                                                      " (in 'factor_ll', line 257, column 31 to line 259, column 7)",
                                                      " (in 'factor_ll', line 257, column 6 to line 259, column 7)",
                                                      " (in 'factor_ll', line 250, column 25 to line 260, column 5)",
                                                      " (in 'factor_ll', line 250, column 4 to line 260, column 5)",
                                                      " (in 'factor_ll', line 262, column 32 to column 41)",
                                                      " (in 'factor_ll', line 262, column 6 to column 41)",
                                                      " (in 'factor_ll', line 263, column 6 to column 33)",
                                                      " (in 'factor_ll', line 264, column 6 to column 27)",
                                                      " (in 'factor_ll', line 265, column 6 to column 27)",
                                                      " (in 'factor_ll', line 266, column 6 to column 31)",
                                                      " (in 'factor_ll', line 261, column 27 to line 267, column 5)",
                                                      " (in 'factor_ll', line 261, column 4 to line 267, column 5)",
                                                      " (in 'factor_ll', line 269, column 32 to column 61)",
                                                      " (in 'factor_ll', line 269, column 6 to column 61)",
                                                      " (in 'factor_ll', line 268, column 25 to line 270, column 5)",
                                                      " (in 'factor_ll', line 268, column 4 to line 270, column 5)",
                                                      " (in 'factor_ll', line 245, column 2 to line 271, column 3)",
                                                      " (in 'factor_ll', line 273, column 4 to column 37)",
                                                      " (in 'factor_ll', line 274, column 4 to column 35)",
                                                      " (in 'factor_ll', line 272, column 25 to line 275, column 3)",
                                                      " (in 'factor_ll', line 272, column 2 to line 275, column 3)",
                                                      " (in 'factor_ll', line 277, column 4 to column 21)",
                                                      " (in 'factor_ll', line 278, column 4 to column 16)",
                                                      " (in 'factor_ll', line 280, column 6 to column 24)",
                                                      " (in 'factor_ll', line 281, column 6 to column 29)",
                                                      " (in 'factor_ll', line 282, column 6 to column 45)",
                                                      " (in 'factor_ll', line 283, column 6 to column 32)",
                                                      " (in 'factor_ll', line 284, column 6 to column 32)",
                                                      " (in 'factor_ll', line 285, column 6 to line 288, column 78)",
                                                      " (in 'factor_ll', line 289, column 6 to column 30)",
                                                      " (in 'factor_ll', line 290, column 6 to column 28)",
                                                      " (in 'factor_ll', line 279, column 29 to line 291, column 5)",
                                                      " (in 'factor_ll', line 279, column 4 to line 291, column 5)",
                                                      " (in 'factor_ll', line 276, column 2 to line 292, column 3)",
                                                      " (in 'factor_ll', line 203, column 68 to column 69)",
                                                      " (in 'factor_ll', line 203, column 23 to column 72)",
                                                      " (in 'factor_ll', line 203, column 2 to column 72)",
                                                      " (in 'factor_ll', line 204, column 2 to column 30)",
                                                      " (in 'factor_ll', line 205, column 2 to column 35)",
                                                      " (in 'factor_ll', line 207, column 4 to column 34)",
                                                      " (in 'factor_ll', line 206, column 20 to line 208, column 3)",
                                                      " (in 'factor_ll', line 206, column 2 to line 208, column 3)",
                                                      " (in 'factor_ll', line 209, column 2 to column 43)",
                                                      " (in 'factor_ll', line 210, column 2 to column 41)",
                                                      " (in 'factor_ll', line 212, column 4 to column 39)",
                                                      " (in 'factor_ll', line 211, column 23 to line 213, column 3)",
                                                      " (in 'factor_ll', line 211, column 2 to line 213, column 3)",
                                                      " (in 'factor_ll', line 215, column 4 to column 21)",
                                                      " (in 'factor_ll', line 217, column 6 to column 24)",
                                                      " (in 'factor_ll', line 218, column 6 to column 29)",
                                                      " (in 'factor_ll', line 219, column 6 to column 45)",
                                                      " (in 'factor_ll', line 220, column 6 to line 222, column 72)",
                                                      " (in 'factor_ll', line 223, column 6 to column 30)",
                                                      " (in 'factor_ll', line 216, column 29 to line 224, column 5)",
                                                      " (in 'factor_ll', line 216, column 4 to line 224, column 5)",
                                                      " (in 'factor_ll', line 214, column 2 to line 225, column 3)",
                                                      " (in 'factor_ll', line 227, column 2 to column 74)",
                                                      " (in 'factor_ll', line 99, column 2 to column 23)",
                                                      " (in 'factor_ll', line 101, column 2 to column 19)",
                                                      " (in 'factor_ll', line 102, column 2 to column 20)",
                                                      " (in 'factor_ll', line 103, column 2 to column 17)",
                                                      " (in 'factor_ll', line 104, column 2 to column 26)",
                                                      " (in 'factor_ll', line 105, column 2 to column 22)",
                                                      " (in 'factor_ll', line 106, column 8 to column 14)",
                                                      " (in 'factor_ll', line 106, column 2 to column 37)",
                                                      " (in 'factor_ll', line 107, column 8 to column 14)",
                                                      " (in 'factor_ll', line 107, column 2 to column 37)",
                                                      " (in 'factor_ll', line 108, column 9 to column 15)",
                                                      " (in 'factor_ll', line 108, column 2 to column 23)",
                                                      " (in 'factor_ll', line 109, column 2 to column 17)",
                                                      " (in 'factor_ll', line 110, column 2 to column 24)",
                                                      " (in 'factor_ll', line 111, column 8 to column 16)",
                                                      " (in 'factor_ll', line 111, column 2 to column 40)",
                                                      " (in 'factor_ll', line 112, column 2 to column 22)",
                                                      " (in 'factor_ll', line 113, column 10 to column 16)",
                                                      " (in 'factor_ll', line 113, column 2 to column 37)",
                                                      " (in 'factor_ll', line 115, column 8 to column 18)",
                                                      " (in 'factor_ll', line 115, column 2 to column 48)",
                                                      " (in 'factor_ll', line 116, column 8 to column 18)",
                                                      " (in 'factor_ll', line 116, column 2 to column 48)",
                                                      " (in 'factor_ll', line 117, column 8 to column 12)",
                                                      " (in 'factor_ll', line 117, column 2 to column 25)",
                                                      " (in 'factor_ll', line 118, column 8 to column 12)",
                                                      " (in 'factor_ll', line 118, column 2 to column 23)",
                                                      " (in 'factor_ll', line 119, column 8 to column 18)",
                                                      " (in 'factor_ll', line 119, column 2 to column 32)",
                                                      " (in 'factor_ll', line 120, column 8 to column 18)",
                                                      " (in 'factor_ll', line 120, column 2 to column 35)",
                                                      " (in 'factor_ll', line 121, column 8 to column 18)",
                                                      " (in 'factor_ll', line 121, column 2 to column 29)",
                                                      " (in 'factor_ll', line 124, column 2 to column 37)",
                                                      " (in 'factor_ll', line 125, column 8 to column 12)",
                                                      " (in 'factor_ll', line 125, column 2 to column 23)",
                                                      " (in 'factor_ll', line 126, column 9 to column 15)",
                                                      " (in 'factor_ll', line 126, column 2 to column 32)",
                                                      " (in 'factor_ll', line 128, column 4 to column 21)",
                                                      " (in 'factor_ll', line 130, column 6 to column 24)",
                                                      " (in 'factor_ll', line 132, column 8 to column 70)",
                                                      " (in 'factor_ll', line 131, column 33 to line 133, column 7)",
                                                      " (in 'factor_ll', line 131, column 6 to line 133, column 7)",
                                                      " (in 'factor_ll', line 134, column 6 to column 30)",
                                                      " (in 'factor_ll', line 129, column 29 to line 135, column 5)",
                                                      " (in 'factor_ll', line 129, column 4 to line 135, column 5)",
                                                      " (in 'factor_ll', line 127, column 2 to line 136, column 3)",
                                                      " (in 'factor_ll', line 138, column 4 to column 34)",
                                                      " (in 'factor_ll', line 139, column 4 to column 34)",
                                                      " (in 'factor_ll', line 141, column 6 to column 89)",
                                                      " (in 'factor_ll', line 140, column 33 to line 142, column 5)",
                                                      " (in 'factor_ll', line 140, column 4 to line 142, column 5)",
                                                      " (in 'factor_ll', line 144, column 6 to column 83)",
                                                      " (in 'factor_ll', line 143, column 31 to line 145, column 5)",
                                                      " (in 'factor_ll', line 143, column 4 to line 145, column 5)",
                                                      " (in 'factor_ll', line 146, column 4 to column 46)",
                                                      " (in 'factor_ll', line 137, column 23 to line 147, column 3)",
                                                      " (in 'factor_ll', line 137, column 2 to line 147, column 3)",
                                                      " (in 'factor_ll', line 150, column 8 to column 14)",
                                                      " (in 'factor_ll', line 151, column 26 to column 41)",
                                                      " (in 'factor_ll', line 152, column 23 to column 31)",
                                                      " (in 'factor_ll', line 153, column 9 to column 12)",
                                                      " (in 'factor_ll', line 153, column 13 to column 21)",
                                                      " (in 'factor_ll', line 154, column 26 to column 32)",
                                                      " (in 'factor_ll', line 155, column 9 to column 12)",
                                                      " (in 'factor_ll', line 155, column 13 to column 19)",
                                                      " (in 'factor_ll', line 156, column 26 to column 32)",
                                                      " (in 'factor_ll', line 159, column 9 to column 24)",
                                                      " (in 'factor_ll', line 160, column 9 to column 24)",
                                                      " (in 'factor_ll', line 161, column 9 to column 12)",
                                                      " (in 'factor_ll', line 161, column 13 to column 21)",
                                                      " (in 'factor_ll', line 162, column 9 to column 12)",
                                                      " (in 'factor_ll', line 162, column 13 to column 19)",
                                                      " (in 'factor_ll', line 163, column 9 to column 15)",
                                                      " (in 'factor_ll', line 164, column 8 to column 14)",
                                                      " (in 'factor_ll', line 164, column 15 to column 25)",
                                                      " (in 'factor_ll', line 230, column 8 to column 9)",
                                                      " (in 'factor_ll', line 231, column 9 to column 15)",
                                                      " (in 'factor_ll', line 232, column 9 to column 12)",
                                                      " (in 'factor_ll', line 232, column 13 to column 21)",
                                                      " (in 'factor_ll', line 233, column 9 to column 15)",
                                                      " (in 'factor_ll', line 233, column 16 to column 22)",
                                                      " (in 'factor_ll', line 234, column 9 to column 17)",
                                                      " (in 'factor_ll', line 234, column 18 to column 26)",
                                                      " (in 'factor_ll', line 19, column 2 to column 30)",
                                                      " (in 'factor_ll', line 20, column 2 to column 19)",
                                                      " (in 'factor_ll', line 21, column 8 to column 14)",
                                                      " (in 'factor_ll', line 21, column 2 to column 24)",
                                                      " (in 'factor_ll', line 22, column 9 to column 17)",
                                                      " (in 'factor_ll', line 22, column 2 to column 23)",
                                                      " (in 'factor_ll', line 23, column 2 to column 44)",
                                                      " (in 'factor_ll', line 24, column 9 to column 12)",
                                                      " (in 'factor_ll', line 24, column 2 to column 37)",
                                                      " (in 'factor_ll', line 25, column 2 to column 17)",
                                                      " (in 'factor_ll', line 36, column 6 to column 17)",
                                                      " (in 'factor_ll', line 35, column 11 to line 37, column 5)",
                                                      " (in 'factor_ll', line 28, column 6 to column 14)",
                                                      " (in 'factor_ll', line 32, column 8 to column 30)",
                                                      " (in 'factor_ll', line 31, column 13 to line 33, column 7)",
                                                      " (in 'factor_ll', line 30, column 8 to column 33)",
                                                      " (in 'factor_ll', line 29, column 21 to line 31, column 7)",
                                                      " (in 'factor_ll', line 29, column 6 to line 33, column 7)",
                                                      " (in 'factor_ll', line 34, column 6 to column 45)",
                                                      " (in 'factor_ll', line 27, column 32 to line 35, column 5)",
                                                      " (in 'factor_ll', line 27, column 4 to line 37, column 5)",
                                                      " (in 'factor_ll', line 26, column 21 to line 38, column 3)",
                                                      " (in 'factor_ll', line 26, column 2 to line 38, column 3)",
                                                      " (in 'factor_ll', line 39, column 2 to column 17)",
                                                      " (in 'factor_ll', line 41, column 4 to column 32)",
                                                      " (in 'factor_ll', line 40, column 34 to line 42, column 3)",
                                                      " (in 'factor_ll', line 40, column 2 to line 42, column 3)",
                                                      " (in 'factor_ll', line 45, column 6 to line 46, column 79)",
                                                      " (in 'factor_ll', line 44, column 52 to line 47, column 5)",
                                                      " (in 'factor_ll', line 44, column 4 to line 47, column 5)",
                                                      " (in 'factor_ll', line 43, column 35 to line 48, column 3)",
                                                      " (in 'factor_ll', line 43, column 2 to line 48, column 3)",
                                                      " (in 'factor_ll', line 49, column 2 to column 13)",
                                                      " (in 'factor_ll', line 18, column 91 to line 50, column 1)",
                                                      " (in 'factor_ll', line 55, column 2 to column 14)",
                                                      " (in 'factor_ll', line 56, column 2 to column 32)",
                                                      " (in 'factor_ll', line 57, column 9 to column 16)",
                                                      " (in 'factor_ll', line 57, column 2 to column 23)",
                                                      " (in 'factor_ll', line 58, column 8 to column 15)",
                                                      " (in 'factor_ll', line 58, column 2 to column 26)",
                                                      " (in 'factor_ll', line 59, column 35 to column 48)",
                                                      " (in 'factor_ll', line 59, column 2 to column 48)",
                                                      " (in 'factor_ll', line 61, column 4 to column 25)",
                                                      " (in 'factor_ll', line 60, column 44 to line 62, column 3)",
                                                      " (in 'factor_ll', line 60, column 2 to line 62, column 3)",
                                                      " (in 'factor_ll', line 63, column 2 to column 56)",
                                                      " (in 'factor_ll', line 65, column 4 to column 35)",
                                                      " (in 'factor_ll', line 69, column 6 to column 29)",
                                                      " (in 'factor_ll', line 68, column 11 to line 70, column 5)",
                                                      " (in 'factor_ll', line 67, column 6 to column 16)",
                                                      " (in 'factor_ll', line 66, column 25 to line 68, column 5)",
                                                      " (in 'factor_ll', line 66, column 4 to line 70, column 5)",
                                                      " (in 'factor_ll', line 64, column 44 to line 71, column 3)",
                                                      " (in 'factor_ll', line 64, column 2 to line 71, column 3)",
                                                      " (in 'factor_ll', line 72, column 2 to column 12)",
                                                      " (in 'factor_ll', line 54, column 0 to line 73, column 1)",
                                                      " (in 'factor_ll', line 78, column 8 to column 18)",
                                                      " (in 'factor_ll', line 78, column 2 to column 28)",
                                                      " (in 'factor_ll', line 79, column 2 to column 14)",
                                                      " (in 'factor_ll', line 80, column 2 to column 32)",
                                                      " (in 'factor_ll', line 81, column 9 to column 16)",
                                                      " (in 'factor_ll', line 81, column 2 to column 23)",
                                                      " (in 'factor_ll', line 82, column 8 to column 15)",
                                                      " (in 'factor_ll', line 82, column 2 to column 26)",
                                                      " (in 'factor_ll', line 83, column 35 to column 48)",
                                                      " (in 'factor_ll', line 83, column 2 to column 48)",
                                                      " (in 'factor_ll', line 85, column 4 to column 25)",
                                                      " (in 'factor_ll', line 84, column 44 to line 86, column 3)",
                                                      " (in 'factor_ll', line 84, column 2 to line 86, column 3)",
                                                      " (in 'factor_ll', line 87, column 2 to column 56)",
                                                      " (in 'factor_ll', line 89, column 4 to column 35)",
                                                      " (in 'factor_ll', line 91, column 6 to column 20)",
                                                      " (in 'factor_ll', line 92, column 6 to column 15)",
                                                      " (in 'factor_ll', line 90, column 29 to line 93, column 5)",
                                                      " (in 'factor_ll', line 90, column 4 to line 93, column 5)",
                                                      " (in 'factor_ll', line 88, column 44 to line 94, column 3)",
                                                      " (in 'factor_ll', line 88, column 2 to line 94, column 3)",
                                                      " (in 'factor_ll', line 95, column 2 to column 12)",
                                                      " (in 'factor_ll', line 77, column 0 to line 96, column 1)"};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T2__, T3__,
stan::value_type_t<T4__>>, -1, 1>
cmp_probs(const T0__& scale, const T1__& alpha, const T2__& pa1,
          const T3__& pa2, const T4__& thr_arg__,
          const std::vector<int>& want, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          stan::value_type_t<T4__>>;
  const auto& thr = to_ref(thr_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int nth;
    nth = std::numeric_limits<int>::min();
    
    current_statement__ = 224;
    nth = num_elements(thr);
    int nth2;
    nth2 = std::numeric_limits<int>::min();
    
    current_statement__ = 225;
    nth2 = (nth * 2);
    current_statement__ = 226;
    validate_non_negative_index("pr", "1 + nth2", (1 + nth2));
    std::vector<local_scalar_t__> pr;
    pr = std::vector<local_scalar_t__>((1 + nth2), DUMMY_VAR__);
    
    current_statement__ = 228;
    validate_non_negative_index("out", "1 + nth2", (1 + nth2));
    Eigen::Matrix<local_scalar_t__, -1, 1> out;
    out = Eigen::Matrix<local_scalar_t__, -1, 1>((1 + nth2));
    stan::math::fill(out, DUMMY_VAR__);
    
    local_scalar_t__ paDiff;
    paDiff = DUMMY_VAR__;
    
    current_statement__ = 230;
    paDiff = ((alpha * scale) * (pa1 - pa2));
    current_statement__ = 231;
    validate_non_negative_index("thrAlpha", "nth", nth);
    Eigen::Matrix<local_scalar_t__, -1, 1> thrAlpha;
    thrAlpha = Eigen::Matrix<local_scalar_t__, -1, 1>(nth);
    stan::math::fill(thrAlpha, DUMMY_VAR__);
    
    current_statement__ = 232;
    assign(thrAlpha, nil_index_list(), multiply(thr, alpha),
      "assigning variable thrAlpha");
    current_statement__ = 233;
    assign(pr, cons_list(index_uni((1 + nth2)), nil_index_list()), 1,
      "assigning variable pr");
    current_statement__ = 246;
    for (int tx = 1; tx <= nth2; ++tx) {
      current_statement__ = 244;
      if ((primitive_value(want[(tx - 1)]) || primitive_value(
          want[((tx + 1) - 1)]))) {
        local_scalar_t__ at;
        at = DUMMY_VAR__;
        
        current_statement__ = 241;
        if (logical_lte(tx, nth)) {
          current_statement__ = 239;
          at = -thrAlpha[(((nth + 1) - tx) - 1)];
        } else {
          current_statement__ = 237;
          at = thrAlpha[((tx - nth) - 1)];
        }
        current_statement__ = 242;
        assign(pr, cons_list(index_uni(tx), nil_index_list()),
          (1.0 / (1.0 + stan::math::exp(-(paDiff + at)))),
          "assigning variable pr");
      } else {
        current_statement__ = 234;
        assign(pr, cons_list(index_uni(tx), nil_index_list()), 0,
          "assigning variable pr");
      }}
    current_statement__ = 247;
    assign(out, cons_list(index_uni(1), nil_index_list()), pr[(1 - 1)],
      "assigning variable out");
    current_statement__ = 250;
    for (int tx = 2; tx <= num_elements(out); ++tx) {
      current_statement__ = 248;
      assign(out, cons_list(index_uni(tx), nil_index_list()),
        (pr[(tx - 1)] - pr[((tx - 1) - 1)]), "assigning variable out");}
    current_statement__ = 255;
    for (int tx = 1; tx <= num_elements(want); ++tx) {
      current_statement__ = 253;
      if ((primitive_value(want[(tx - 1)]) && primitive_value(
          (primitive_value(logical_lte(out[(tx - 1)], 0)) || primitive_value(
          logical_gte(out[(tx - 1)], 1)))))) {
        current_statement__ = 251;
        std::stringstream errmsg_stream__;
        errmsg_stream__ << "out[";
        errmsg_stream__ << tx;
        errmsg_stream__ << "]=";
        errmsg_stream__ << out[(tx - 1)];
        errmsg_stream__ << "; scale=";
        errmsg_stream__ << scale;
        errmsg_stream__ << " alpha=";
        errmsg_stream__ << alpha;
        errmsg_stream__ << " pa1=";
        errmsg_stream__ << pa1;
        errmsg_stream__ << " pa2=";
        errmsg_stream__ << pa2;
        errmsg_stream__ << " th=";
        errmsg_stream__ << thr;
        throw std::domain_error(errmsg_stream__.str());
      } }
    current_statement__ = 256;
    return out;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cmp_probs_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T2__, T3__,
stan::value_type_t<T4__>>, -1, 1>
operator()(const T0__& scale, const T1__& alpha, const T2__& pa1,
           const T3__& pa2, const T4__& thr, const std::vector<int>& want,
           std::ostream* pstream__)  const 
{
return cmp_probs(scale, alpha, pa1, pa2, thr, want, pstream__);
}
};
template <typename T4__, typename T5__, typename T6__, typename T7__,
typename T8__>
stan::promote_args_t<T4__, T5__, T6__, T7__,
stan::value_type_t<T8__>>
pairwise_logprob(const std::vector<int>& rcat,
                 const std::vector<int>& weight, const int& cmpStart,
                 const int& len, const T4__& scale, const T5__& alpha,
                 const T6__& pa1, const T7__& pa2, const T8__& cumTh_arg__,
                 std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T4__,
          T5__,
          T6__,
          T7__,
          stan::value_type_t<T8__>>;
  const auto& cumTh = to_ref(cumTh_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ lp;
    lp = DUMMY_VAR__;
    
    current_statement__ = 258;
    lp = 0;
    int nth;
    nth = std::numeric_limits<int>::min();
    
    current_statement__ = 259;
    nth = num_elements(cumTh);
    current_statement__ = 260;
    validate_non_negative_index("prob", "1 + nth * 2", (1 + (nth * 2)));
    Eigen::Matrix<local_scalar_t__, -1, 1> prob;
    prob = Eigen::Matrix<local_scalar_t__, -1, 1>((1 + (nth * 2)));
    stan::math::fill(prob, DUMMY_VAR__);
    
    current_statement__ = 262;
    validate_non_negative_index("want", "1 + nth * 2", (1 + (nth * 2)));
    std::vector<int> want;
    want = std::vector<int>((1 + (nth * 2)), std::numeric_limits<int>::min());
    
    current_statement__ = 265;
    for (int ox = 1; ox <= num_elements(want); ++ox) {
      current_statement__ = 264;
      assign(want, cons_list(index_uni(ox), nil_index_list()), 0,
        "assigning variable want");}
    current_statement__ = 268;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      current_statement__ = 266;
      assign(want, cons_list(index_uni(rcat[(ox - 1)]), nil_index_list()), 1,
        "assigning variable want");}
    current_statement__ = 269;
    assign(prob, nil_index_list(),
      cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__),
      "assigning variable prob");
    current_statement__ = 277;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      local_scalar_t__ lp1;
      lp1 = DUMMY_VAR__;
      
      current_statement__ = 270;
      lp1 = stan::math::log(prob[(rcat[(ox - 1)] - 1)]);
      current_statement__ = 275;
      if (logical_eq(weight[(ox - 1)], 1)) {
        current_statement__ = 273;
        lp = (lp + lp1);
      } else {
        current_statement__ = 271;
        lp = (lp + (weight[(ox - 1)] * lp1));
      }}
    current_statement__ = 278;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct pairwise_logprob_functor__ {
template <typename T4__, typename T5__, typename T6__, typename T7__,
typename T8__>
stan::promote_args_t<T4__, T5__, T6__, T7__,
stan::value_type_t<T8__>>
operator()(const std::vector<int>& rcat, const std::vector<int>& weight,
           const int& cmpStart, const int& len, const T4__& scale,
           const T5__& alpha, const T6__& pa1, const T7__& pa2,
           const T8__& cumTh, std::ostream* pstream__)  const 
{
return pairwise_logprob(rcat, weight, cmpStart, len, scale, alpha, pa1, pa2,
         cumTh, pstream__);
}
};
template <typename T5__, typename T6__, typename T7__, typename T8__,
typename T9__>
std::vector<stan::promote_args_t<T5__, T6__, T7__, T8__,
stan::value_type_t<T9__>>>
pairwise_loo(const std::vector<int>& rcat, const std::vector<int>& weight,
             const int& numOutcome, const int& cmpStart, const int& len,
             const T5__& scale, const T6__& alpha, const T7__& pa1,
             const T8__& pa2, const T9__& cumTh_arg__,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T5__,
          T6__,
          T7__,
          T8__,
          stan::value_type_t<T9__>>;
  const auto& cumTh = to_ref(cumTh_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 280;
    validate_non_negative_index("lp", "numOutcome", numOutcome);
    std::vector<local_scalar_t__> lp;
    lp = std::vector<local_scalar_t__>(numOutcome, DUMMY_VAR__);
    
    int cur;
    cur = std::numeric_limits<int>::min();
    
    current_statement__ = 282;
    cur = 1;
    int nth;
    nth = std::numeric_limits<int>::min();
    
    current_statement__ = 283;
    nth = num_elements(cumTh);
    current_statement__ = 284;
    validate_non_negative_index("prob", "1 + nth * 2", (1 + (nth * 2)));
    Eigen::Matrix<local_scalar_t__, -1, 1> prob;
    prob = Eigen::Matrix<local_scalar_t__, -1, 1>((1 + (nth * 2)));
    stan::math::fill(prob, DUMMY_VAR__);
    
    current_statement__ = 286;
    validate_non_negative_index("want", "1 + nth * 2", (1 + (nth * 2)));
    std::vector<int> want;
    want = std::vector<int>((1 + (nth * 2)), std::numeric_limits<int>::min());
    
    current_statement__ = 289;
    for (int ox = 1; ox <= num_elements(want); ++ox) {
      current_statement__ = 288;
      assign(want, cons_list(index_uni(ox), nil_index_list()), 0,
        "assigning variable want");}
    current_statement__ = 292;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      current_statement__ = 290;
      assign(want, cons_list(index_uni(rcat[(ox - 1)]), nil_index_list()), 1,
        "assigning variable want");}
    current_statement__ = 293;
    assign(prob, nil_index_list(),
      cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__),
      "assigning variable prob");
    current_statement__ = 300;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      local_scalar_t__ lp1;
      lp1 = DUMMY_VAR__;
      
      current_statement__ = 294;
      lp1 = stan::math::log(prob[(rcat[(ox - 1)] - 1)]);
      current_statement__ = 298;
      for (int wx = 1; wx <= weight[(ox - 1)]; ++wx) {
        current_statement__ = 295;
        assign(lp, cons_list(index_uni(cur), nil_index_list()), lp1,
          "assigning variable lp");
        current_statement__ = 296;
        cur = (cur + 1);}}
    current_statement__ = 301;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct pairwise_loo_functor__ {
template <typename T5__, typename T6__, typename T7__, typename T8__,
typename T9__>
std::vector<stan::promote_args_t<T5__, T6__, T7__, T8__,
stan::value_type_t<T9__>>>
operator()(const std::vector<int>& rcat, const std::vector<int>& weight,
           const int& numOutcome, const int& cmpStart, const int& len,
           const T5__& scale, const T6__& alpha, const T7__& pa1,
           const T8__& pa2, const T9__& cumTh, std::ostream* pstream__)  const 
{
return pairwise_loo(rcat, weight, numOutcome, cmpStart, len, scale, alpha,
         pa1, pa2, cumTh, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_factor_ll final : public model_base_crtp<model_factor_ll> {
private:
  double alphaScalePrior;
  int NPA;
  int NCMP;
  int N;
  int numRefresh;
  int NITEMS;
  std::vector<int> NTHRESH;
  std::vector<int> TOFFSET;
  Eigen::Matrix<double, -1, 1> scale;
  double propShape;
  int NFACTORS;
  std::vector<double> factorScalePrior;
  int NPATHS;
  std::vector<std::vector<int>> factorItemPath;
  std::vector<int> pa1;
  std::vector<int> pa2;
  std::vector<int> weight;
  std::vector<int> pick;
  std::vector<int> refresh;
  std::vector<int> numOutcome;
  std::vector<int> item;
  int totalThresholds;
  std::vector<int> rcat;
  Eigen::Matrix<double, -1, 1> pathScalePrior;
  int rawPerComponentVar_2dim__;
 
public:
  ~model_factor_ll() { }
  
  inline std::string model_name() const final { return "model_factor_ll"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_factor_ll(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_factor_ll_namespace::model_factor_ll";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 140;
      context__.validate_dims("data initialization","alphaScalePrior",
          "double",context__.to_vec());
      alphaScalePrior = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 140;
      alphaScalePrior = context__.vals_r("alphaScalePrior")[(1 - 1)];
      current_statement__ = 141;
      context__.validate_dims("data initialization","NPA","int",
          context__.to_vec());
      NPA = std::numeric_limits<int>::min();
      
      current_statement__ = 141;
      NPA = context__.vals_i("NPA")[(1 - 1)];
      current_statement__ = 141;
      current_statement__ = 141;
      check_greater_or_equal(function__, "NPA", NPA, 1);
      current_statement__ = 142;
      context__.validate_dims("data initialization","NCMP","int",
          context__.to_vec());
      NCMP = std::numeric_limits<int>::min();
      
      current_statement__ = 142;
      NCMP = context__.vals_i("NCMP")[(1 - 1)];
      current_statement__ = 142;
      current_statement__ = 142;
      check_greater_or_equal(function__, "NCMP", NCMP, 1);
      current_statement__ = 143;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 143;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 143;
      current_statement__ = 143;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 144;
      context__.validate_dims("data initialization","numRefresh","int",
          context__.to_vec());
      numRefresh = std::numeric_limits<int>::min();
      
      current_statement__ = 144;
      numRefresh = context__.vals_i("numRefresh")[(1 - 1)];
      current_statement__ = 144;
      current_statement__ = 144;
      check_greater_or_equal(function__, "numRefresh", numRefresh, 1);
      current_statement__ = 145;
      context__.validate_dims("data initialization","NITEMS","int",
          context__.to_vec());
      NITEMS = std::numeric_limits<int>::min();
      
      current_statement__ = 145;
      NITEMS = context__.vals_i("NITEMS")[(1 - 1)];
      current_statement__ = 145;
      current_statement__ = 145;
      check_greater_or_equal(function__, "NITEMS", NITEMS, 1);
      current_statement__ = 146;
      validate_non_negative_index("NTHRESH", "NITEMS", NITEMS);
      current_statement__ = 147;
      context__.validate_dims("data initialization","NTHRESH","int",
          context__.to_vec(NITEMS));
      NTHRESH = std::vector<int>(NITEMS, std::numeric_limits<int>::min());
      
      current_statement__ = 147;
      assign(NTHRESH, nil_index_list(), context__.vals_i("NTHRESH"),
        "assigning variable NTHRESH");
      current_statement__ = 147;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 147;
        current_statement__ = 147;
        check_greater_or_equal(function__, "NTHRESH[sym1__]",
                               NTHRESH[(sym1__ - 1)], 1);}
      current_statement__ = 148;
      validate_non_negative_index("TOFFSET", "NITEMS", NITEMS);
      current_statement__ = 149;
      context__.validate_dims("data initialization","TOFFSET","int",
          context__.to_vec(NITEMS));
      TOFFSET = std::vector<int>(NITEMS, std::numeric_limits<int>::min());
      
      current_statement__ = 149;
      assign(TOFFSET, nil_index_list(), context__.vals_i("TOFFSET"),
        "assigning variable TOFFSET");
      current_statement__ = 149;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 149;
        current_statement__ = 149;
        check_greater_or_equal(function__, "TOFFSET[sym1__]",
                               TOFFSET[(sym1__ - 1)], 1);}
      current_statement__ = 150;
      validate_non_negative_index("scale", "NITEMS", NITEMS);
      current_statement__ = 151;
      context__.validate_dims("data initialization","scale","double",
          context__.to_vec(NITEMS));
      scale = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(scale, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> scale_flat__;
        current_statement__ = 151;
        assign(scale_flat__, nil_index_list(), context__.vals_r("scale"),
          "assigning variable scale_flat__");
        current_statement__ = 151;
        pos__ = 1;
        current_statement__ = 151;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 151;
          assign(scale, cons_list(index_uni(sym1__), nil_index_list()),
            scale_flat__[(pos__ - 1)], "assigning variable scale");
          current_statement__ = 151;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 152;
      context__.validate_dims("data initialization","propShape","double",
          context__.to_vec());
      propShape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 152;
      propShape = context__.vals_r("propShape")[(1 - 1)];
      current_statement__ = 153;
      context__.validate_dims("data initialization","NFACTORS","int",
          context__.to_vec());
      NFACTORS = std::numeric_limits<int>::min();
      
      current_statement__ = 153;
      NFACTORS = context__.vals_i("NFACTORS")[(1 - 1)];
      current_statement__ = 153;
      current_statement__ = 153;
      check_greater_or_equal(function__, "NFACTORS", NFACTORS, 1);
      current_statement__ = 154;
      validate_non_negative_index("factorScalePrior", "NFACTORS", NFACTORS);
      current_statement__ = 155;
      context__.validate_dims("data initialization","factorScalePrior",
          "double",context__.to_vec(NFACTORS));
      factorScalePrior = std::vector<double>(NFACTORS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 155;
      assign(factorScalePrior, nil_index_list(),
        context__.vals_r("factorScalePrior"),
        "assigning variable factorScalePrior");
      current_statement__ = 156;
      context__.validate_dims("data initialization","NPATHS","int",
          context__.to_vec());
      NPATHS = std::numeric_limits<int>::min();
      
      current_statement__ = 156;
      NPATHS = context__.vals_i("NPATHS")[(1 - 1)];
      current_statement__ = 156;
      current_statement__ = 156;
      check_greater_or_equal(function__, "NPATHS", NPATHS, 1);
      current_statement__ = 157;
      validate_non_negative_index("factorItemPath", "NPATHS", NPATHS);
      current_statement__ = 158;
      context__.validate_dims("data initialization","factorItemPath","int",
          context__.to_vec(2, NPATHS));
      factorItemPath = std::vector<std::vector<int>>(2, std::vector<int>(NPATHS, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> factorItemPath_flat__;
        current_statement__ = 158;
        assign(factorItemPath_flat__, nil_index_list(),
          context__.vals_i("factorItemPath"),
          "assigning variable factorItemPath_flat__");
        current_statement__ = 158;
        pos__ = 1;
        current_statement__ = 158;
        for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
          current_statement__ = 158;
          for (int sym2__ = 1; sym2__ <= 2; ++sym2__) {
            current_statement__ = 158;
            assign(factorItemPath,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              factorItemPath_flat__[(pos__ - 1)],
              "assigning variable factorItemPath");
            current_statement__ = 158;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 159;
      validate_non_negative_index("pa1", "numRefresh", numRefresh);
      current_statement__ = 160;
      context__.validate_dims("data initialization","pa1","int",
          context__.to_vec(numRefresh));
      pa1 = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 160;
      assign(pa1, nil_index_list(), context__.vals_i("pa1"),
        "assigning variable pa1");
      current_statement__ = 160;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 160;
        current_statement__ = 160;
        check_greater_or_equal(function__, "pa1[sym1__]", pa1[(sym1__ - 1)],
                               1);}
      current_statement__ = 160;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 160;
        current_statement__ = 160;
        check_less_or_equal(function__, "pa1[sym1__]", pa1[(sym1__ - 1)], NPA);
      }
      current_statement__ = 161;
      validate_non_negative_index("pa2", "numRefresh", numRefresh);
      current_statement__ = 162;
      context__.validate_dims("data initialization","pa2","int",
          context__.to_vec(numRefresh));
      pa2 = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 162;
      assign(pa2, nil_index_list(), context__.vals_i("pa2"),
        "assigning variable pa2");
      current_statement__ = 162;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 162;
        current_statement__ = 162;
        check_greater_or_equal(function__, "pa2[sym1__]", pa2[(sym1__ - 1)],
                               1);}
      current_statement__ = 162;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 162;
        current_statement__ = 162;
        check_less_or_equal(function__, "pa2[sym1__]", pa2[(sym1__ - 1)], NPA);
      }
      current_statement__ = 163;
      validate_non_negative_index("weight", "NCMP", NCMP);
      current_statement__ = 164;
      context__.validate_dims("data initialization","weight","int",
          context__.to_vec(NCMP));
      weight = std::vector<int>(NCMP, std::numeric_limits<int>::min());
      
      current_statement__ = 164;
      assign(weight, nil_index_list(), context__.vals_i("weight"),
        "assigning variable weight");
      current_statement__ = 165;
      validate_non_negative_index("pick", "NCMP", NCMP);
      current_statement__ = 166;
      context__.validate_dims("data initialization","pick","int",
          context__.to_vec(NCMP));
      pick = std::vector<int>(NCMP, std::numeric_limits<int>::min());
      
      current_statement__ = 166;
      assign(pick, nil_index_list(), context__.vals_i("pick"),
        "assigning variable pick");
      current_statement__ = 167;
      validate_non_negative_index("refresh", "numRefresh", numRefresh);
      current_statement__ = 168;
      context__.validate_dims("data initialization","refresh","int",
          context__.to_vec(numRefresh));
      refresh = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 168;
      assign(refresh, nil_index_list(), context__.vals_i("refresh"),
        "assigning variable refresh");
      current_statement__ = 169;
      validate_non_negative_index("numOutcome", "numRefresh", numRefresh);
      current_statement__ = 170;
      context__.validate_dims("data initialization","numOutcome","int",
          context__.to_vec(numRefresh));
      numOutcome = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 170;
      assign(numOutcome, nil_index_list(), context__.vals_i("numOutcome"),
        "assigning variable numOutcome");
      current_statement__ = 171;
      validate_non_negative_index("item", "numRefresh", numRefresh);
      current_statement__ = 172;
      context__.validate_dims("data initialization","item","int",
          context__.to_vec(numRefresh));
      item = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 172;
      assign(item, nil_index_list(), context__.vals_i("item"),
        "assigning variable item");
      current_statement__ = 173;
      totalThresholds = std::numeric_limits<int>::min();
      
      current_statement__ = 173;
      totalThresholds = sum(NTHRESH);
      current_statement__ = 174;
      validate_non_negative_index("rcat", "NCMP", NCMP);
      current_statement__ = 175;
      rcat = std::vector<int>(NCMP, std::numeric_limits<int>::min());
      
      current_statement__ = 176;
      validate_non_negative_index("pathScalePrior", "NPATHS", NPATHS);
      current_statement__ = 177;
      pathScalePrior = Eigen::Matrix<double, -1, 1>(NPATHS);
      stan::math::fill(pathScalePrior, std::numeric_limits<double>::quiet_NaN());
      
      {
        int cmpStart;
        cmpStart = std::numeric_limits<int>::min();
        
        current_statement__ = 178;
        cmpStart = 0;
        current_statement__ = 185;
        for (int rx = 1; rx <= numRefresh; ++rx) {
          int ix;
          ix = std::numeric_limits<int>::min();
          
          current_statement__ = 179;
          ix = item[(rx - 1)];
          current_statement__ = 182;
          for (int cmp = 1; cmp <= refresh[(rx - 1)]; ++cmp) {
            current_statement__ = 180;
            assign(rcat,
              cons_list(index_uni((cmpStart + cmp)), nil_index_list()),
              ((pick[((cmpStart + cmp) - 1)] + NTHRESH[(ix - 1)]) + 1),
              "assigning variable rcat");}
          current_statement__ = 183;
          cmpStart = (cmpStart + refresh[(rx - 1)]);}
      }
      current_statement__ = 197;
      for (int px = 1; px <= NPATHS; ++px) {
        int fx;
        fx = std::numeric_limits<int>::min();
        
        current_statement__ = 187;
        fx = factorItemPath[(1 - 1)][(px - 1)];
        int ix;
        ix = std::numeric_limits<int>::min();
        
        current_statement__ = 188;
        ix = factorItemPath[(2 - 1)][(px - 1)];
        current_statement__ = 191;
        if ((primitive_value(logical_lt(fx, 1)) || primitive_value(
            logical_gt(fx, NFACTORS)))) {
          current_statement__ = 189;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "factorItemPath[1,";
          errmsg_stream__ << "px";
          errmsg_stream__ << "] names factor ";
          errmsg_stream__ << fx;
          errmsg_stream__ << " (NFACTORS=";
          errmsg_stream__ << NFACTORS;
          errmsg_stream__ << ")";
          throw std::domain_error(errmsg_stream__.str());
        } 
        current_statement__ = 194;
        if ((primitive_value(logical_lt(ix, 1)) || primitive_value(
            logical_gt(ix, NITEMS)))) {
          current_statement__ = 192;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "factorItemPath[2,";
          errmsg_stream__ << "px";
          errmsg_stream__ << "] names item ";
          errmsg_stream__ << ix;
          errmsg_stream__ << " (NITEMS=";
          errmsg_stream__ << NITEMS;
          errmsg_stream__ << ")";
          throw std::domain_error(errmsg_stream__.str());
        } 
        current_statement__ = 195;
        assign(pathScalePrior, cons_list(index_uni(px), nil_index_list()),
          factorScalePrior[(fx - 1)], "assigning variable pathScalePrior");}
      current_statement__ = 198;
      validate_non_negative_index("alpha", "NITEMS", NITEMS);
      current_statement__ = 199;
      validate_non_negative_index("rawThreshold", "totalThresholds",
                                  totalThresholds);
      current_statement__ = 200;
      validate_non_negative_index("CholPsi", "NFACTORS", NFACTORS);
      current_statement__ = 200;
      validate_non_negative_index("CholPsi", "NFACTORS", NFACTORS);
      current_statement__ = 201;
      validate_non_negative_index("rawFactor", "NPA", NPA);
      current_statement__ = 202;
      validate_non_negative_index("rawFactor", "NFACTORS", NFACTORS);
      current_statement__ = 203;
      validate_non_negative_index("rawLoadings", "NPATHS", NPATHS);
      current_statement__ = 204;
      validate_non_negative_index("rawUniqueTheta", "NPA", NPA);
      current_statement__ = 205;
      validate_non_negative_index("rawUniqueTheta", "NITEMS", NITEMS);
      current_statement__ = 206;
      validate_non_negative_index("rawUnique", "NITEMS", NITEMS);
      current_statement__ = 207;
      validate_non_negative_index("threshold", "totalThresholds",
                                  totalThresholds);
      current_statement__ = 208;
      validate_non_negative_index("rawCumTh", "totalThresholds",
                                  totalThresholds);
      current_statement__ = 209;
      validate_non_negative_index("rawFactorPsi", "NPA", NPA);
      current_statement__ = 210;
      validate_non_negative_index("rawFactorPsi", "NFACTORS", NFACTORS);
      current_statement__ = 211;
      validate_non_negative_index("theta", "NPA", NPA);
      current_statement__ = 212;
      validate_non_negative_index("theta", "NITEMS", NITEMS);
      current_statement__ = 213;
      validate_non_negative_index("rawPathProp", "NPATHS", NPATHS);
      current_statement__ = 214;
      validate_non_negative_index("rawPerComponentVar", "NITEMS", NITEMS);
      current_statement__ = 215;
      rawPerComponentVar_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 215;
      rawPerComponentVar_2dim__ = (1 + NFACTORS);
      current_statement__ = 215;
      validate_non_negative_index("rawPerComponentVar", "1 + NFACTORS",
                                  rawPerComponentVar_2dim__);
      current_statement__ = 216;
      validate_non_negative_index("log_lik", "N", N);
      current_statement__ = 217;
      validate_non_negative_index("pathProp", "NPATHS", NPATHS);
      current_statement__ = 218;
      validate_non_negative_index("factor", "NPA", NPA);
      current_statement__ = 219;
      validate_non_negative_index("factor", "NFACTORS", NFACTORS);
      current_statement__ = 220;
      validate_non_negative_index("residualItemCor", "NITEMS", NITEMS);
      current_statement__ = 221;
      validate_non_negative_index("residualItemCor", "NITEMS", NITEMS);
      current_statement__ = 222;
      validate_non_negative_index("Psi", "NFACTORS", NFACTORS);
      current_statement__ = 223;
      validate_non_negative_index("Psi", "NFACTORS", NFACTORS);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += NITEMS;
      num_params_r__ += totalThresholds;
      num_params_r__ += ((NFACTORS * (NFACTORS - 1)) / 2);
      num_params_r__ += NPA * NFACTORS;
      num_params_r__ += NPATHS;
      num_params_r__ += NPA * NITEMS;
      num_params_r__ += NITEMS;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_factor_ll_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> alpha;
      alpha = std::vector<local_scalar_t__>(NITEMS, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 1;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable alpha");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha[(sym1__ - 1)], 0, lp__),
            "assigning variable alpha");
        } else {
          current_statement__ = 1;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha[(sym1__ - 1)], 0),
            "assigning variable alpha");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> rawThreshold;
      rawThreshold = Eigen::Matrix<local_scalar_t__, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold, DUMMY_VAR__);
      
      current_statement__ = 2;
      rawThreshold = in__.vector(totalThresholds);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(rawThreshold,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawThreshold[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable rawThreshold");
        } else {
          current_statement__ = 2;
          assign(rawThreshold,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawThreshold[(sym1__ - 1)], 0, 1),
            "assigning variable rawThreshold");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> CholPsi;
      CholPsi = Eigen::Matrix<local_scalar_t__, -1, -1>(NFACTORS, NFACTORS);
      stan::math::fill(CholPsi, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> CholPsi_in__;
      CholPsi_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((NFACTORS *
                                                               (NFACTORS - 1))
                                                              / 2));
      stan::math::fill(CholPsi_in__, DUMMY_VAR__);
      
      current_statement__ = 3;
      CholPsi_in__ = in__.vector(((NFACTORS * (NFACTORS - 1)) / 2));
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        assign(CholPsi, nil_index_list(),
          stan::math::cholesky_corr_constrain(CholPsi_in__, NFACTORS, lp__),
          "assigning variable CholPsi");
      } else {
        current_statement__ = 3;
        assign(CholPsi, nil_index_list(),
          stan::math::cholesky_corr_constrain(CholPsi_in__, NFACTORS),
          "assigning variable CholPsi");
      }
      Eigen::Matrix<local_scalar_t__, -1, -1> rawFactor;
      rawFactor = Eigen::Matrix<local_scalar_t__, -1, -1>(NPA, NFACTORS);
      stan::math::fill(rawFactor, DUMMY_VAR__);
      
      current_statement__ = 4;
      rawFactor = in__.matrix(NPA, NFACTORS);
      Eigen::Matrix<local_scalar_t__, -1, 1> rawLoadings;
      rawLoadings = Eigen::Matrix<local_scalar_t__, -1, 1>(NPATHS);
      stan::math::fill(rawLoadings, DUMMY_VAR__);
      
      current_statement__ = 5;
      rawLoadings = in__.vector(NPATHS);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(rawLoadings, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawLoadings[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable rawLoadings");
        } else {
          current_statement__ = 5;
          assign(rawLoadings, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawLoadings[(sym1__ - 1)], 0, 1),
            "assigning variable rawLoadings");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> rawUniqueTheta;
      rawUniqueTheta = Eigen::Matrix<local_scalar_t__, -1, -1>(NPA, NITEMS);
      stan::math::fill(rawUniqueTheta, DUMMY_VAR__);
      
      current_statement__ = 6;
      rawUniqueTheta = in__.matrix(NPA, NITEMS);
      Eigen::Matrix<local_scalar_t__, -1, 1> rawUnique;
      rawUnique = Eigen::Matrix<local_scalar_t__, -1, 1>(NITEMS);
      stan::math::fill(rawUnique, DUMMY_VAR__);
      
      current_statement__ = 7;
      rawUnique = in__.vector(NITEMS);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(rawUnique, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawUnique[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable rawUnique");
        } else {
          current_statement__ = 7;
          assign(rawUnique, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawUnique[(sym1__ - 1)], 0, 1),
            "assigning variable rawUnique");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> threshold;
      threshold = Eigen::Matrix<local_scalar_t__, -1, 1>(totalThresholds);
      stan::math::fill(threshold, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> rawCumTh;
      rawCumTh = Eigen::Matrix<local_scalar_t__, -1, 1>(totalThresholds);
      stan::math::fill(rawCumTh, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> rawFactorPsi;
      rawFactorPsi = Eigen::Matrix<local_scalar_t__, -1, -1>(NPA, NFACTORS);
      stan::math::fill(rawFactorPsi, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(NPA, NITEMS);
      stan::math::fill(theta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> rawPathProp;
      rawPathProp = Eigen::Matrix<local_scalar_t__, -1, 1>(NPATHS);
      stan::math::fill(rawPathProp, DUMMY_VAR__);
      
      std::vector<std::vector<local_scalar_t__>> rawPerComponentVar;
      rawPerComponentVar = std::vector<std::vector<local_scalar_t__>>(NITEMS, std::vector<local_scalar_t__>(rawPerComponentVar_2dim__, DUMMY_VAR__));
      
      current_statement__ = 17;
      for (int ix = 1; ix <= NITEMS; ++ix) {
        current_statement__ = 14;
        assign(theta,
          cons_list(index_omni(), cons_list(index_uni(ix), nil_index_list())),
          multiply(
            rvalue(rawUniqueTheta,
              cons_list(index_omni(),
                cons_list(index_uni(ix), nil_index_list())),
              "rawUniqueTheta"), ((2 * rawUnique[(ix - 1)]) - 1)),
          "assigning variable theta");
        current_statement__ = 15;
        assign(rawPerComponentVar,
          cons_list(index_uni(ix), cons_list(index_uni(1), nil_index_list())),
          variance(
            rvalue(theta,
              cons_list(index_omni(),
                cons_list(index_uni(ix), nil_index_list())), "theta")),
          "assigning variable rawPerComponentVar");}
      current_statement__ = 21;
      for (int fx = 1; fx <= NFACTORS; ++fx) {
        current_statement__ = 19;
        for (int ix = 1; ix <= NITEMS; ++ix) {
          current_statement__ = 18;
          assign(rawPerComponentVar,
            cons_list(index_uni(ix),
              cons_list(index_uni((1 + fx)), nil_index_list())), 0,
            "assigning variable rawPerComponentVar");}}
      current_statement__ = 22;
      assign(rawFactorPsi, nil_index_list(),
        multiply(rawFactor, transpose(CholPsi)),
        "assigning variable rawFactorPsi");
      current_statement__ = 30;
      for (int px = 1; px <= NPATHS; ++px) {
        int fx;
        fx = std::numeric_limits<int>::min();
        
        current_statement__ = 23;
        fx = factorItemPath[(1 - 1)][(px - 1)];
        int ix;
        ix = std::numeric_limits<int>::min();
        
        current_statement__ = 24;
        ix = factorItemPath[(2 - 1)][(px - 1)];
        current_statement__ = 25;
        validate_non_negative_index("theta1", "NPA", NPA);
        Eigen::Matrix<local_scalar_t__, -1, 1> theta1;
        theta1 = Eigen::Matrix<local_scalar_t__, -1, 1>(NPA);
        stan::math::fill(theta1, DUMMY_VAR__);
        
        current_statement__ = 26;
        assign(theta1, nil_index_list(),
          multiply(((2 * rawLoadings[(px - 1)]) - 1),
            rvalue(rawFactorPsi,
              cons_list(index_omni(),
                cons_list(index_uni(fx), nil_index_list())), "rawFactorPsi")),
          "assigning variable theta1");
        current_statement__ = 27;
        assign(rawPerComponentVar,
          cons_list(index_uni(ix),
            cons_list(index_uni((1 + fx)), nil_index_list())),
          variance(theta1), "assigning variable rawPerComponentVar");
        current_statement__ = 28;
        assign(theta,
          cons_list(index_omni(), cons_list(index_uni(ix), nil_index_list())),
          add(
            stan::model::deep_copy(
              rvalue(theta,
                cons_list(index_omni(),
                  cons_list(index_uni(ix), nil_index_list())), "theta")),
            theta1), "assigning variable theta");}
      current_statement__ = 44;
      for (int px = 1; px <= NPATHS; ++px) {
        int fx;
        fx = std::numeric_limits<int>::min();
        
        current_statement__ = 31;
        fx = factorItemPath[(1 - 1)][(px - 1)];
        int ix;
        ix = std::numeric_limits<int>::min();
        
        current_statement__ = 32;
        ix = factorItemPath[(2 - 1)][(px - 1)];
        local_scalar_t__ resid;
        resid = DUMMY_VAR__;
        
        current_statement__ = 33;
        resid = 0;
        local_scalar_t__ pred;
        pred = DUMMY_VAR__;
        
        current_statement__ = 41;
        for (int cx = 1; cx <= (1 + NFACTORS); ++cx) {
          current_statement__ = 39;
          if (logical_eq(cx, (fx + 1))) {
            current_statement__ = 37;
            pred = rawPerComponentVar[(ix - 1)][(cx - 1)];
          } else {
            current_statement__ = 35;
            resid = (resid + rawPerComponentVar[(ix - 1)][(cx - 1)]);
          }}
        current_statement__ = 42;
        assign(rawPathProp, cons_list(index_uni(px), nil_index_list()),
          (pred / (pred + resid)), "assigning variable rawPathProp");}
      current_statement__ = 51;
      for (int ix = 1; ix <= NITEMS; ++ix) {
        local_scalar_t__ maxSpan;
        maxSpan = DUMMY_VAR__;
        
        current_statement__ = 45;
        maxSpan = (max(
                     rvalue(theta,
                       cons_list(index_omni(),
                         cons_list(index_uni(ix), nil_index_list())),
                       "theta")) -
                    min(
                      rvalue(theta,
                        cons_list(index_omni(),
                          cons_list(index_uni(ix), nil_index_list())),
                        "theta")));
        int from;
        from = std::numeric_limits<int>::min();
        
        current_statement__ = 46;
        from = TOFFSET[(ix - 1)];
        int to;
        to = std::numeric_limits<int>::min();
        
        current_statement__ = 47;
        to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
        current_statement__ = 48;
        assign(threshold,
          cons_list(index_min_max(from, to), nil_index_list()),
          multiply(maxSpan,
            rvalue(rawThreshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "rawThreshold")), "assigning variable threshold");
        current_statement__ = 49;
        assign(rawCumTh,
          cons_list(index_min_max(from, to), nil_index_list()),
          cumulative_sum(
            rvalue(threshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "threshold")), "assigning variable rawCumTh");}
      {
        current_statement__ = 119;
        for (int ix = 1; ix <= NITEMS; ++ix) {
          current_statement__ = 117;
          if (logical_lt(alpha[(ix - 1)], 0)) {
            current_statement__ = 117;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 117;
            lp_accum__.add(-normal_ccdf_log(0, 1.749, alphaScalePrior));
          }
          current_statement__ = 118;
          lp_accum__.add(
            normal_lpdf<propto__>(alpha[(ix - 1)], 1.749, alphaScalePrior));}
        current_statement__ = 120;
        lp_accum__.add(beta_lpdf<propto__>(rawThreshold, 1.1, 2));
        current_statement__ = 121;
        lp_accum__.add(lkj_corr_cholesky_lpdf<propto__>(CholPsi, 2.5));
        current_statement__ = 124;
        for (int xx = 1; xx <= NPA; ++xx) {
          current_statement__ = 122;
          lp_accum__.add(
            std_normal_lpdf<propto__>(
              rvalue(rawFactor,
                cons_list(index_uni(xx),
                  cons_list(index_omni(), nil_index_list())), "rawFactor")));
        }
        current_statement__ = 125;
        lp_accum__.add(beta_lpdf<propto__>(rawLoadings, propShape, propShape));
        current_statement__ = 126;
        lp_accum__.add(beta_lpdf<propto__>(rawUnique, propShape, propShape));
        current_statement__ = 129;
        for (int ix = 1; ix <= NITEMS; ++ix) {
          current_statement__ = 127;
          lp_accum__.add(
            std_normal_lpdf<propto__>(
              rvalue(rawUniqueTheta,
                cons_list(index_omni(),
                  cons_list(index_uni(ix), nil_index_list())),
                "rawUniqueTheta")));}
        {
          int cmpStart;
          cmpStart = std::numeric_limits<int>::min();
          
          current_statement__ = 130;
          cmpStart = 1;
          current_statement__ = 137;
          for (int rx = 1; rx <= numRefresh; ++rx) {
            int ix;
            ix = std::numeric_limits<int>::min();
            
            current_statement__ = 131;
            ix = item[(rx - 1)];
            int from;
            from = std::numeric_limits<int>::min();
            
            current_statement__ = 132;
            from = TOFFSET[(ix - 1)];
            int to;
            to = std::numeric_limits<int>::min();
            
            current_statement__ = 133;
            to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
            current_statement__ = 134;
            lp_accum__.add(
              pairwise_logprob(rcat, weight, cmpStart, refresh[(rx - 1)],
                scale[(ix - 1)], alpha[(ix - 1)],
                rvalue(theta,
                  cons_list(index_uni(pa1[(rx - 1)]),
                    cons_list(index_uni(ix), nil_index_list())), "theta"),
                rvalue(theta,
                  cons_list(index_uni(pa2[(rx - 1)]),
                    cons_list(index_uni(ix), nil_index_list())), "theta"),
                rvalue(rawCumTh,
                  cons_list(index_min_max(from, to), nil_index_list()),
                  "rawCumTh"), pstream__));
            current_statement__ = 135;
            cmpStart = (cmpStart + refresh[(rx - 1)]);}
        }
        current_statement__ = 139;
        lp_accum__.add(
          normal_lpdf<false>(logit(add(0.5, divide(rawPathProp, 2.0))), 0,
            pathScalePrior));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_factor_ll_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> alpha;
      alpha = std::vector<double>(NITEMS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 1;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable alpha");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 1;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(alpha[(sym1__ - 1)], 0),
          "assigning variable alpha");}
      Eigen::Matrix<double, -1, 1> rawThreshold;
      rawThreshold = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      rawThreshold = in__.vector(totalThresholds);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        current_statement__ = 2;
        assign(rawThreshold, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(rawThreshold[(sym1__ - 1)], 0, 1),
          "assigning variable rawThreshold");}
      Eigen::Matrix<double, -1, -1> CholPsi;
      CholPsi = Eigen::Matrix<double, -1, -1>(NFACTORS, NFACTORS);
      stan::math::fill(CholPsi, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> CholPsi_in__;
      CholPsi_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((NFACTORS *
                                                               (NFACTORS - 1))
                                                              / 2));
      stan::math::fill(CholPsi_in__, DUMMY_VAR__);
      
      current_statement__ = 3;
      CholPsi_in__ = in__.vector(((NFACTORS * (NFACTORS - 1)) / 2));
      current_statement__ = 3;
      assign(CholPsi, nil_index_list(),
        stan::math::cholesky_corr_constrain(CholPsi_in__, NFACTORS),
        "assigning variable CholPsi");
      Eigen::Matrix<double, -1, -1> rawFactor;
      rawFactor = Eigen::Matrix<double, -1, -1>(NPA, NFACTORS);
      stan::math::fill(rawFactor, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      rawFactor = in__.matrix(NPA, NFACTORS);
      Eigen::Matrix<double, -1, 1> rawLoadings;
      rawLoadings = Eigen::Matrix<double, -1, 1>(NPATHS);
      stan::math::fill(rawLoadings, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      rawLoadings = in__.vector(NPATHS);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        current_statement__ = 5;
        assign(rawLoadings, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(rawLoadings[(sym1__ - 1)], 0, 1),
          "assigning variable rawLoadings");}
      Eigen::Matrix<double, -1, -1> rawUniqueTheta;
      rawUniqueTheta = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
      stan::math::fill(rawUniqueTheta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      rawUniqueTheta = in__.matrix(NPA, NITEMS);
      Eigen::Matrix<double, -1, 1> rawUnique;
      rawUnique = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(rawUnique, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      rawUnique = in__.vector(NITEMS);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 7;
        assign(rawUnique, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(rawUnique[(sym1__ - 1)], 0, 1),
          "assigning variable rawUnique");}
      Eigen::Matrix<double, -1, 1> threshold;
      threshold = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(threshold, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> rawCumTh;
      rawCumTh = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawCumTh, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> rawFactorPsi;
      rawFactorPsi = Eigen::Matrix<double, -1, -1>(NPA, NFACTORS);
      stan::math::fill(rawFactorPsi, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> rawPathProp;
      rawPathProp = Eigen::Matrix<double, -1, 1>(NPATHS);
      stan::math::fill(rawPathProp, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<std::vector<double>> rawPerComponentVar;
      rawPerComponentVar = std::vector<std::vector<double>>(NITEMS, std::vector<double>(rawPerComponentVar_2dim__, std::numeric_limits<double>::quiet_NaN()));
      
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        vars__.emplace_back(rawThreshold[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NFACTORS; ++sym2__) {
          vars__.emplace_back(
            rvalue(CholPsi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "CholPsi"));
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawFactor,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "rawFactor"));
        }}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        vars__.emplace_back(rawLoadings[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawUniqueTheta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "rawUniqueTheta"));}}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        vars__.emplace_back(rawUnique[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 17;
      for (int ix = 1; ix <= NITEMS; ++ix) {
        current_statement__ = 14;
        assign(theta,
          cons_list(index_omni(), cons_list(index_uni(ix), nil_index_list())),
          multiply(
            rvalue(rawUniqueTheta,
              cons_list(index_omni(),
                cons_list(index_uni(ix), nil_index_list())),
              "rawUniqueTheta"), ((2 * rawUnique[(ix - 1)]) - 1)),
          "assigning variable theta");
        current_statement__ = 15;
        assign(rawPerComponentVar,
          cons_list(index_uni(ix), cons_list(index_uni(1), nil_index_list())),
          variance(
            rvalue(theta,
              cons_list(index_omni(),
                cons_list(index_uni(ix), nil_index_list())), "theta")),
          "assigning variable rawPerComponentVar");}
      current_statement__ = 21;
      for (int fx = 1; fx <= NFACTORS; ++fx) {
        current_statement__ = 19;
        for (int ix = 1; ix <= NITEMS; ++ix) {
          current_statement__ = 18;
          assign(rawPerComponentVar,
            cons_list(index_uni(ix),
              cons_list(index_uni((1 + fx)), nil_index_list())), 0,
            "assigning variable rawPerComponentVar");}}
      current_statement__ = 22;
      assign(rawFactorPsi, nil_index_list(),
        multiply(rawFactor, transpose(CholPsi)),
        "assigning variable rawFactorPsi");
      current_statement__ = 30;
      for (int px = 1; px <= NPATHS; ++px) {
        int fx;
        fx = std::numeric_limits<int>::min();
        
        current_statement__ = 23;
        fx = factorItemPath[(1 - 1)][(px - 1)];
        int ix;
        ix = std::numeric_limits<int>::min();
        
        current_statement__ = 24;
        ix = factorItemPath[(2 - 1)][(px - 1)];
        current_statement__ = 25;
        validate_non_negative_index("theta1", "NPA", NPA);
        Eigen::Matrix<double, -1, 1> theta1;
        theta1 = Eigen::Matrix<double, -1, 1>(NPA);
        stan::math::fill(theta1, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 26;
        assign(theta1, nil_index_list(),
          multiply(((2 * rawLoadings[(px - 1)]) - 1),
            rvalue(rawFactorPsi,
              cons_list(index_omni(),
                cons_list(index_uni(fx), nil_index_list())), "rawFactorPsi")),
          "assigning variable theta1");
        current_statement__ = 27;
        assign(rawPerComponentVar,
          cons_list(index_uni(ix),
            cons_list(index_uni((1 + fx)), nil_index_list())),
          variance(theta1), "assigning variable rawPerComponentVar");
        current_statement__ = 28;
        assign(theta,
          cons_list(index_omni(), cons_list(index_uni(ix), nil_index_list())),
          add(
            stan::model::deep_copy(
              rvalue(theta,
                cons_list(index_omni(),
                  cons_list(index_uni(ix), nil_index_list())), "theta")),
            theta1), "assigning variable theta");}
      current_statement__ = 44;
      for (int px = 1; px <= NPATHS; ++px) {
        int fx;
        fx = std::numeric_limits<int>::min();
        
        current_statement__ = 31;
        fx = factorItemPath[(1 - 1)][(px - 1)];
        int ix;
        ix = std::numeric_limits<int>::min();
        
        current_statement__ = 32;
        ix = factorItemPath[(2 - 1)][(px - 1)];
        double resid;
        resid = std::numeric_limits<double>::quiet_NaN();
        
        current_statement__ = 33;
        resid = 0;
        double pred;
        pred = std::numeric_limits<double>::quiet_NaN();
        
        current_statement__ = 41;
        for (int cx = 1; cx <= (1 + NFACTORS); ++cx) {
          current_statement__ = 39;
          if (logical_eq(cx, (fx + 1))) {
            current_statement__ = 37;
            pred = rawPerComponentVar[(ix - 1)][(cx - 1)];
          } else {
            current_statement__ = 35;
            resid = (resid + rawPerComponentVar[(ix - 1)][(cx - 1)]);
          }}
        current_statement__ = 42;
        assign(rawPathProp, cons_list(index_uni(px), nil_index_list()),
          (pred / (pred + resid)), "assigning variable rawPathProp");}
      current_statement__ = 51;
      for (int ix = 1; ix <= NITEMS; ++ix) {
        double maxSpan;
        maxSpan = std::numeric_limits<double>::quiet_NaN();
        
        current_statement__ = 45;
        maxSpan = (max(
                     rvalue(theta,
                       cons_list(index_omni(),
                         cons_list(index_uni(ix), nil_index_list())),
                       "theta")) -
                    min(
                      rvalue(theta,
                        cons_list(index_omni(),
                          cons_list(index_uni(ix), nil_index_list())),
                        "theta")));
        int from;
        from = std::numeric_limits<int>::min();
        
        current_statement__ = 46;
        from = TOFFSET[(ix - 1)];
        int to;
        to = std::numeric_limits<int>::min();
        
        current_statement__ = 47;
        to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
        current_statement__ = 48;
        assign(threshold,
          cons_list(index_min_max(from, to), nil_index_list()),
          multiply(maxSpan,
            rvalue(rawThreshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "rawThreshold")), "assigning variable threshold");
        current_statement__ = 49;
        assign(rawCumTh,
          cons_list(index_min_max(from, to), nil_index_list()),
          cumulative_sum(
            rvalue(threshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "threshold")), "assigning variable rawCumTh");}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
          vars__.emplace_back(threshold[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
          vars__.emplace_back(rawCumTh[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            vars__.emplace_back(
              rvalue(rawFactorPsi,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "rawFactorPsi"));}}
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            vars__.emplace_back(
              rvalue(theta,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "theta"));
          }}
        for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
          vars__.emplace_back(rawPathProp[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= rawPerComponentVar_2dim__; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            vars__.emplace_back(
              rawPerComponentVar[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<double> log_lik;
      log_lik = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> pathProp;
      pathProp = Eigen::Matrix<double, -1, 1>(NPATHS);
      stan::math::fill(pathProp, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 53;
      assign(pathProp, nil_index_list(), rawPathProp,
        "assigning variable pathProp");
      Eigen::Matrix<double, -1, -1> factor;
      factor = Eigen::Matrix<double, -1, -1>(NPA, NFACTORS);
      stan::math::fill(factor, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 54;
      assign(factor, nil_index_list(), rawFactorPsi,
        "assigning variable factor");
      Eigen::Matrix<double, -1, -1> residualItemCor;
      residualItemCor = Eigen::Matrix<double, -1, -1>(NITEMS, NITEMS);
      stan::math::fill(residualItemCor, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> Psi;
      Psi = Eigen::Matrix<double, -1, -1>(NFACTORS, NFACTORS);
      stan::math::fill(Psi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 56;
      assign(Psi, nil_index_list(), multiply(CholPsi, transpose(CholPsi)),
        "assigning variable Psi");
      {
        current_statement__ = 57;
        validate_non_negative_index("residual", "NPA", NPA);
        current_statement__ = 58;
        validate_non_negative_index("residual", "NITEMS", NITEMS);
        Eigen::Matrix<double, -1, -1> residual;
        residual = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
        stan::math::fill(residual, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 64;
        for (int ix = 1; ix <= NITEMS; ++ix) {
          current_statement__ = 60;
          assign(residual,
            cons_list(index_omni(),
              cons_list(index_uni(ix), nil_index_list())),
            multiply(
              rvalue(rawUniqueTheta,
                cons_list(index_omni(),
                  cons_list(index_uni(ix), nil_index_list())),
                "rawUniqueTheta"), ((2 * rawUnique[(ix - 1)]) - 1)),
            "assigning variable residual");
          current_statement__ = 61;
          assign(residual,
            cons_list(index_omni(),
              cons_list(index_uni(ix), nil_index_list())),
            subtract(
              stan::model::deep_copy(
                rvalue(residual,
                  cons_list(index_omni(),
                    cons_list(index_uni(ix), nil_index_list())), "residual")),
              mean(
                rvalue(residual,
                  cons_list(index_omni(),
                    cons_list(index_uni(ix), nil_index_list())), "residual"))),
            "assigning variable residual");
          current_statement__ = 62;
          assign(residual,
            cons_list(index_omni(),
              cons_list(index_uni(ix), nil_index_list())),
            divide(
              stan::model::deep_copy(
                rvalue(residual,
                  cons_list(index_omni(),
                    cons_list(index_uni(ix), nil_index_list())), "residual")),
              sd(
                rvalue(residual,
                  cons_list(index_omni(),
                    cons_list(index_uni(ix), nil_index_list())), "residual"))),
            "assigning variable residual");}
        current_statement__ = 65;
        assign(residualItemCor, nil_index_list(), crossprod(residual),
          "assigning variable residualItemCor");
        current_statement__ = 66;
        assign(residualItemCor, nil_index_list(),
          quad_form_diag(stan::model::deep_copy(residualItemCor),
            elt_divide(1.0,
              stan::math::sqrt(
                diagonal(stan::model::deep_copy(residualItemCor))))),
          "assigning variable residualItemCor");
      }
      {
        current_statement__ = 68;
        validate_non_negative_index("pathLoadings", "NPATHS", NPATHS);
        Eigen::Matrix<double, -1, 1> pathLoadings;
        pathLoadings = Eigen::Matrix<double, -1, 1>(NPATHS);
        stan::math::fill(pathLoadings, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 69;
        assign(pathLoadings, nil_index_list(),
          subtract(multiply(2, rawLoadings), 1),
          "assigning variable pathLoadings");
        current_statement__ = 70;
        validate_non_negative_index("rawSeenFactor", "NFACTORS", NFACTORS);
        std::vector<int> rawSeenFactor;
        rawSeenFactor = std::vector<int>(NFACTORS, std::numeric_limits<int>::min());
        
        current_statement__ = 72;
        validate_non_negative_index("rawNegateFactor", "NFACTORS", NFACTORS);
        std::vector<int> rawNegateFactor;
        rawNegateFactor = std::vector<int>(NFACTORS, std::numeric_limits<int>::min());
        
        current_statement__ = 75;
        for (int fx = 1; fx <= NFACTORS; ++fx) {
          current_statement__ = 74;
          assign(rawSeenFactor, cons_list(index_uni(fx), nil_index_list()),
            0, "assigning variable rawSeenFactor");}
        current_statement__ = 86;
        for (int px = 1; px <= NPATHS; ++px) {
          int fx;
          fx = std::numeric_limits<int>::min();
          
          current_statement__ = 76;
          fx = factorItemPath[(1 - 1)][(px - 1)];
          int ix;
          ix = std::numeric_limits<int>::min();
          
          current_statement__ = 77;
          ix = factorItemPath[(2 - 1)][(px - 1)];
          current_statement__ = 81;
          if (logical_eq(rawSeenFactor[(fx - 1)], 0)) {
            current_statement__ = 78;
            assign(rawSeenFactor, cons_list(index_uni(fx), nil_index_list()),
              1, "assigning variable rawSeenFactor");
            current_statement__ = 79;
            assign(rawNegateFactor,
              cons_list(index_uni(fx), nil_index_list()),
              logical_lt(rawLoadings[(px - 1)], 0.5),
              "assigning variable rawNegateFactor");
          } 
          current_statement__ = 84;
          if (rawNegateFactor[(fx - 1)]) {
            current_statement__ = 82;
            assign(pathLoadings, cons_list(index_uni(px), nil_index_list()),
              -pathLoadings[(px - 1)], "assigning variable pathLoadings");
          } }
        current_statement__ = 94;
        for (int fx = 1; fx <= NFACTORS; ++fx) {
          current_statement__ = 88;
          if (logical_negation(rawNegateFactor[(fx - 1)])) {
            continue;
          } 
          current_statement__ = 89;
          assign(factor,
            cons_list(index_omni(),
              cons_list(index_uni(fx), nil_index_list())),
            minus(
              stan::model::deep_copy(
                rvalue(factor,
                  cons_list(index_omni(),
                    cons_list(index_uni(fx), nil_index_list())), "factor"))),
            "assigning variable factor");
          current_statement__ = 90;
          assign(Psi,
            cons_list(index_omni(),
              cons_list(index_uni(fx), nil_index_list())),
            minus(
              stan::model::deep_copy(
                rvalue(Psi,
                  cons_list(index_omni(),
                    cons_list(index_uni(fx), nil_index_list())), "Psi"))),
            "assigning variable Psi");
          current_statement__ = 91;
          assign(Psi,
            cons_list(index_uni(fx),
              cons_list(index_omni(), nil_index_list())),
            minus(
              stan::model::deep_copy(
                rvalue(Psi,
                  cons_list(index_uni(fx),
                    cons_list(index_omni(), nil_index_list())), "Psi"))),
            "assigning variable Psi");
          current_statement__ = 92;
          assign(Psi,
            cons_list(index_uni(fx),
              cons_list(index_uni(fx), nil_index_list())),
            -rvalue(Psi,
               cons_list(index_uni(fx),
                 cons_list(index_uni(fx), nil_index_list())), "Psi"),
            "assigning variable Psi");}
        current_statement__ = 98;
        for (int fx = 1; fx <= NPATHS; ++fx) {
          current_statement__ = 96;
          if (logical_lt(pathLoadings[(fx - 1)], 0)) {
            current_statement__ = 95;
            assign(pathProp, cons_list(index_uni(fx), nil_index_list()),
              -pathProp[(fx - 1)], "assigning variable pathProp");
          } }
      }
      current_statement__ = 103;
      for (int fx = 1; fx <= NFACTORS; ++fx) {
        current_statement__ = 100;
        assign(factor,
          cons_list(index_omni(), cons_list(index_uni(fx), nil_index_list())),
          subtract(
            stan::model::deep_copy(
              rvalue(factor,
                cons_list(index_omni(),
                  cons_list(index_uni(fx), nil_index_list())), "factor")),
            mean(
              rvalue(factor,
                cons_list(index_omni(),
                  cons_list(index_uni(fx), nil_index_list())), "factor"))),
          "assigning variable factor");
        current_statement__ = 101;
        assign(factor,
          cons_list(index_omni(), cons_list(index_uni(fx), nil_index_list())),
          divide(
            stan::model::deep_copy(
              rvalue(factor,
                cons_list(index_omni(),
                  cons_list(index_uni(fx), nil_index_list())), "factor")),
            sd(
              rvalue(factor,
                cons_list(index_omni(),
                  cons_list(index_uni(fx), nil_index_list())), "factor"))),
          "assigning variable factor");}
      {
        int cmpStart;
        cmpStart = std::numeric_limits<int>::min();
        
        current_statement__ = 104;
        cmpStart = 1;
        int cur;
        cur = std::numeric_limits<int>::min();
        
        current_statement__ = 105;
        cur = 1;
        current_statement__ = 115;
        for (int rx = 1; rx <= numRefresh; ++rx) {
          int ix;
          ix = std::numeric_limits<int>::min();
          
          current_statement__ = 106;
          ix = item[(rx - 1)];
          int from;
          from = std::numeric_limits<int>::min();
          
          current_statement__ = 107;
          from = TOFFSET[(ix - 1)];
          int to;
          to = std::numeric_limits<int>::min();
          
          current_statement__ = 108;
          to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
          int nout;
          nout = std::numeric_limits<int>::min();
          
          current_statement__ = 109;
          nout = numOutcome[(rx - 1)];
          int last;
          last = std::numeric_limits<int>::min();
          
          current_statement__ = 110;
          last = ((cur + nout) - 1);
          current_statement__ = 111;
          assign(log_lik,
            cons_list(index_min_max(cur, last), nil_index_list()),
            pairwise_loo(rcat, weight, nout, cmpStart, refresh[(rx - 1)],
              scale[(ix - 1)], alpha[(ix - 1)],
              rvalue(theta,
                cons_list(index_uni(pa1[(rx - 1)]),
                  cons_list(index_uni(ix), nil_index_list())), "theta"),
              rvalue(theta,
                cons_list(index_uni(pa2[(rx - 1)]),
                  cons_list(index_uni(ix), nil_index_list())), "theta"),
              rvalue(rawCumTh,
                cons_list(index_min_max(from, to), nil_index_list()),
                "rawCumTh"), pstream__), "assigning variable log_lik");
          current_statement__ = 112;
          cmpStart = (cmpStart + refresh[(rx - 1)]);
          current_statement__ = 113;
          cur = (cur + numOutcome[(rx - 1)]);}
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        vars__.emplace_back(pathProp[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(factor,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "factor"));}
      }
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
          vars__.emplace_back(
            rvalue(residualItemCor,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "residualItemCor"));}}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NFACTORS; ++sym2__) {
          vars__.emplace_back(
            rvalue(Psi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "Psi"));}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> alpha;
      alpha = std::vector<double>(NITEMS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(alpha, nil_index_list(), context__.vals_r("alpha"),
        "assigning variable alpha");
      std::vector<double> alpha_free__;
      alpha_free__ = std::vector<double>(NITEMS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 1;
        assign(alpha_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(alpha[(sym1__ - 1)], 0),
          "assigning variable alpha_free__");}
      Eigen::Matrix<double, -1, 1> rawThreshold;
      rawThreshold = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawThreshold_flat__;
        current_statement__ = 2;
        assign(rawThreshold_flat__, nil_index_list(),
          context__.vals_r("rawThreshold"),
          "assigning variable rawThreshold_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
          current_statement__ = 2;
          assign(rawThreshold,
            cons_list(index_uni(sym1__), nil_index_list()),
            rawThreshold_flat__[(pos__ - 1)],
            "assigning variable rawThreshold");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> rawThreshold_free__;
      rawThreshold_free__ = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        current_statement__ = 2;
        assign(rawThreshold_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(rawThreshold[(sym1__ - 1)], 0, 1),
          "assigning variable rawThreshold_free__");}
      Eigen::Matrix<double, -1, -1> CholPsi;
      CholPsi = Eigen::Matrix<double, -1, -1>(NFACTORS, NFACTORS);
      stan::math::fill(CholPsi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> CholPsi_flat__;
        current_statement__ = 3;
        assign(CholPsi_flat__, nil_index_list(), context__.vals_r("CholPsi"),
          "assigning variable CholPsi_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= NFACTORS; ++sym2__) {
            current_statement__ = 3;
            assign(CholPsi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              CholPsi_flat__[(pos__ - 1)], "assigning variable CholPsi");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> CholPsi_free__;
      CholPsi_free__ = Eigen::Matrix<double, -1, 1>(((NFACTORS *
                                                       (NFACTORS - 1)) / 2));
      stan::math::fill(CholPsi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(CholPsi_free__, nil_index_list(),
        stan::math::cholesky_corr_free(CholPsi),
        "assigning variable CholPsi_free__");
      Eigen::Matrix<double, -1, -1> rawFactor;
      rawFactor = Eigen::Matrix<double, -1, -1>(NPA, NFACTORS);
      stan::math::fill(rawFactor, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawFactor_flat__;
        current_statement__ = 4;
        assign(rawFactor_flat__, nil_index_list(),
          context__.vals_r("rawFactor"),
          "assigning variable rawFactor_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            current_statement__ = 4;
            assign(rawFactor,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rawFactor_flat__[(pos__ - 1)], "assigning variable rawFactor");
            current_statement__ = 4;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> rawLoadings;
      rawLoadings = Eigen::Matrix<double, -1, 1>(NPATHS);
      stan::math::fill(rawLoadings, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawLoadings_flat__;
        current_statement__ = 5;
        assign(rawLoadings_flat__, nil_index_list(),
          context__.vals_r("rawLoadings"),
          "assigning variable rawLoadings_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
          current_statement__ = 5;
          assign(rawLoadings, cons_list(index_uni(sym1__), nil_index_list()),
            rawLoadings_flat__[(pos__ - 1)], "assigning variable rawLoadings");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> rawLoadings_free__;
      rawLoadings_free__ = Eigen::Matrix<double, -1, 1>(NPATHS);
      stan::math::fill(rawLoadings_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        current_statement__ = 5;
        assign(rawLoadings_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(rawLoadings[(sym1__ - 1)], 0, 1),
          "assigning variable rawLoadings_free__");}
      Eigen::Matrix<double, -1, -1> rawUniqueTheta;
      rawUniqueTheta = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
      stan::math::fill(rawUniqueTheta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawUniqueTheta_flat__;
        current_statement__ = 6;
        assign(rawUniqueTheta_flat__, nil_index_list(),
          context__.vals_r("rawUniqueTheta"),
          "assigning variable rawUniqueTheta_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            current_statement__ = 6;
            assign(rawUniqueTheta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rawUniqueTheta_flat__[(pos__ - 1)],
              "assigning variable rawUniqueTheta");
            current_statement__ = 6;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> rawUnique;
      rawUnique = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(rawUnique, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawUnique_flat__;
        current_statement__ = 7;
        assign(rawUnique_flat__, nil_index_list(),
          context__.vals_r("rawUnique"),
          "assigning variable rawUnique_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 7;
          assign(rawUnique, cons_list(index_uni(sym1__), nil_index_list()),
            rawUnique_flat__[(pos__ - 1)], "assigning variable rawUnique");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> rawUnique_free__;
      rawUnique_free__ = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(rawUnique_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 7;
        assign(rawUnique_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(rawUnique[(sym1__ - 1)], 0, 1),
          "assigning variable rawUnique_free__");}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        vars__.emplace_back(alpha_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        vars__.emplace_back(rawThreshold_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= ((NFACTORS * (NFACTORS - 1)) / 2);
           ++sym1__) { vars__.emplace_back(CholPsi_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawFactor,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "rawFactor"));
        }}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        vars__.emplace_back(rawLoadings_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawUniqueTheta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "rawUniqueTheta"));}}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        vars__.emplace_back(rawUnique_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("alpha");
    names__.emplace_back("rawThreshold");
    names__.emplace_back("CholPsi");
    names__.emplace_back("rawFactor");
    names__.emplace_back("rawLoadings");
    names__.emplace_back("rawUniqueTheta");
    names__.emplace_back("rawUnique");
    names__.emplace_back("threshold");
    names__.emplace_back("rawCumTh");
    names__.emplace_back("rawFactorPsi");
    names__.emplace_back("theta");
    names__.emplace_back("rawPathProp");
    names__.emplace_back("rawPerComponentVar");
    names__.emplace_back("log_lik");
    names__.emplace_back("pathProp");
    names__.emplace_back("factor");
    names__.emplace_back("residualItemCor");
    names__.emplace_back("Psi");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(totalThresholds)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NFACTORS),
                                             static_cast<size_t>(NFACTORS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NFACTORS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPATHS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(totalThresholds)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(totalThresholds)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NFACTORS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPATHS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS),
                                             static_cast<size_t>(rawPerComponentVar_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPATHS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NFACTORS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS),
                                             static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NFACTORS),
                                             static_cast<size_t>(NFACTORS)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawThreshold" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NFACTORS; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "CholPsi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawFactor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawLoadings" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawUniqueTheta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawUnique" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "threshold" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rawCumTh" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rawFactorPsi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rawPathProp" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= rawPerComponentVar_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rawPerComponentVar" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "pathProp" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "factor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "residualItemCor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NFACTORS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Psi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawThreshold" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= ((NFACTORS * (NFACTORS - 1)) / 2);
         ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "CholPsi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawFactor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawLoadings" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawUniqueTheta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawUnique" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "threshold" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rawCumTh" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rawFactorPsi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rawPathProp" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= rawPerComponentVar_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rawPerComponentVar" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NPATHS; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "pathProp" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "factor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "residualItemCor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= NFACTORS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NFACTORS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Psi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << NITEMS << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"rawThreshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"parameters\"},{\"name\":\"CholPsi\",\"type\":{\"name\":\"matrix\",\"rows\":" << NFACTORS << ",\"cols\":" << NFACTORS << "},\"block\":\"parameters\"},{\"name\":\"rawFactor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NFACTORS << "},\"block\":\"parameters\"},{\"name\":\"rawLoadings\",\"type\":{\"name\":\"vector\",\"length\":" << NPATHS << "},\"block\":\"parameters\"},{\"name\":\"rawUniqueTheta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"rawUnique\",\"type\":{\"name\":\"vector\",\"length\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"threshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawCumTh\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawFactorPsi\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NFACTORS << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawPathProp\",\"type\":{\"name\":\"vector\",\"length\":" << NPATHS << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawPerComponentVar\",\"type\":{\"name\":\"array\",\"length\":" << NITEMS << ",\"element_type\":{\"name\":\"array\",\"length\":" << rawPerComponentVar_2dim__ << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"pathProp\",\"type\":{\"name\":\"vector\",\"length\":" << NPATHS << "},\"block\":\"generated_quantities\"},{\"name\":\"factor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NFACTORS << "},\"block\":\"generated_quantities\"},{\"name\":\"residualItemCor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NITEMS << ",\"cols\":" << NITEMS << "},\"block\":\"generated_quantities\"},{\"name\":\"Psi\",\"type\":{\"name\":\"matrix\",\"rows\":" << NFACTORS << ",\"cols\":" << NFACTORS << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << NITEMS << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"rawThreshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"parameters\"},{\"name\":\"CholPsi\",\"type\":{\"name\":\"vector\",\"length\":" << ((NFACTORS * (NFACTORS - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"rawFactor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NFACTORS << "},\"block\":\"parameters\"},{\"name\":\"rawLoadings\",\"type\":{\"name\":\"vector\",\"length\":" << NPATHS << "},\"block\":\"parameters\"},{\"name\":\"rawUniqueTheta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"rawUnique\",\"type\":{\"name\":\"vector\",\"length\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"threshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawCumTh\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawFactorPsi\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NFACTORS << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawPathProp\",\"type\":{\"name\":\"vector\",\"length\":" << NPATHS << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawPerComponentVar\",\"type\":{\"name\":\"array\",\"length\":" << NITEMS << ",\"element_type\":{\"name\":\"array\",\"length\":" << rawPerComponentVar_2dim__ << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"pathProp\",\"type\":{\"name\":\"vector\",\"length\":" << NPATHS << "},\"block\":\"generated_quantities\"},{\"name\":\"factor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NFACTORS << "},\"block\":\"generated_quantities\"},{\"name\":\"residualItemCor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NITEMS << ",\"cols\":" << NITEMS << "},\"block\":\"generated_quantities\"},{\"name\":\"Psi\",\"type\":{\"name\":\"matrix\",\"rows\":" << NFACTORS << ",\"cols\":" << NFACTORS << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_factor_ll_namespace::model_factor_ll;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_factor_ll_namespace::profiles__;
}
#endif
#endif
