% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{funsPDomNum2PE1D}
\alias{funsPDomNum2PE1D}
\alias{Pdom.num2AI}
\alias{Pdom.num2AII}
\alias{Pdom.num2AIII}
\alias{Pdom.num2AIV}
\alias{Pdom.num2A}
\alias{Pdom.num2Asym}
\alias{Pdom.num2BIII}
\alias{Pdom.num2B}
\alias{Pdom.num2Bsym}
\alias{Pdom.num2CIV}
\alias{Pdom.num2C}
\alias{Pdom.num2Csym}
\alias{Pdom.num2PE1D}
\title{The functions for probability of domination number \eqn{= 2} for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - middle interval case}
\usage{
Pdom.num2AI(r, c, n)

Pdom.num2AII(r, c, n)

Pdom.num2AIII(r, c, n)

Pdom.num2AIV(r, c, n)

Pdom.num2A(r, c, n)

Pdom.num2Asym(r, c, n)

Pdom.num2BIII(r, c, n)

Pdom.num2B(r, c, n)

Pdom.num2Bsym(r, c, n)

Pdom.num2CIV(r, c, n)

Pdom.num2C(r, c, n)

Pdom.num2Csym(r, c, n)

Pdom.num2PE1D(r, c, n)
}
\arguments{
\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}.
For the interval, \eqn{(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{n}{A positive integer representing the size of the uniform data set.}
}
\value{
\eqn{P(}domination number\eqn{\le 1)} for PE-PCD whose vertices are a uniform data set of size \code{n} in a finite
interval \eqn{(a,b)}
}
\description{
The function \code{Pdom.num2PE1D} and its auxiliary functions.

Returns \eqn{P(\gamma=2)} for PE-PCD whose vertices are a uniform data set of size \code{n} in a finite interval
\eqn{(a,b)} where \eqn{\gamma} stands for the domination number.

The PE proximity region \eqn{N_{PE}(x,r,c)} is defined with respect to \eqn{(a,b)} with centrality parameter \eqn{c \in (0,1)}
and expansion parameter \eqn{r \ge 1}.

To compute the probability \eqn{P(\gamma=2)} for PE-PCD in the 1D case,
we partition the domain \eqn{(r,c)=(1,\infty) \times (0,1)}, and compute the probability for each partition
set. The sample size (i.e., number of vertices or data points) is a positive integer, \code{n}.
}
\section{Auxiliary Functions for \code{Pdom.num2PE1D}}{

The auxiliary functions are \code{Pdom.num2AI, Pdom.num2AII, Pdom.num2AIII, Pdom.num2AIV, Pdom.num2A, Pdom.num2Asym, Pdom.num2BIII, Pdom.num2B, Pdom.num2B,
Pdom.num2Bsym, Pdom.num2CIV, Pdom.num2C}, and \code{Pdom.num2Csym}, each corresponding to a partition of the domain of
\code{r} and \code{c}. In particular, the domain partition is handled in 3 cases as

CASE A: \eqn{c \in ((3-\sqrt{5})/2, 1/2)}

CASE B: \eqn{c \in (1/4,(3-\sqrt{5})/2)} and

CASE C: \eqn{c \in (0,1/4)}.
}

\section{Case A - \eqn{c \in ((3-\sqrt{5})/2, 1/2)}}{

In Case A, we compute \eqn{P(\gamma=2)} with

\code{Pdom.num2AIV(r,c,n)} if \eqn{1 < r < (1-c)/c};

\code{Pdom.num2AIII(r,c,n)} if \eqn{(1-c)/c< r < 1/(1-c)};

\code{Pdom.num2AII(r,c,n)} if \eqn{1/(1-c)< r < 1/c};

and \code{Pdom.num2AI(r,c,n)} otherwise.

\code{Pdom.num2A(r,c,n)} combines these functions in Case A: \eqn{c \in ((3-\sqrt{5})/2,1/2)}.
Due to the symmetry in the PE proximity regions, we use \code{Pdom.num2Asym(r,c,n)} for \eqn{c} in
\eqn{(1/2,(\sqrt{5}-1)/2)} with the same auxiliary functions

\code{Pdom.num2AIV(r,1-c,n)} if \eqn{1 < r < c/(1-c)};

\code{Pdom.num2AIII(r,1-c,n)} if \eqn{(c/(1-c) < r < 1/c};

\code{Pdom.num2AII(r,1-c,n)} if \eqn{1/c < r < 1/(1-c)};

and \code{Pdom.num2AI(r,1-c,n)} otherwise.
}

\section{Case B - \eqn{c \in (1/4,(3-\sqrt{5})/2)}}{


In Case B, we compute \eqn{P(\gamma=2)} with

\code{Pdom.num2AIV(r,c,n)} if \eqn{1 < r < 1/(1-c)};

\code{Pdom.num2BIII(r,c,n)} if \eqn{1/(1-c) < r < (1-c)/c};

\code{Pdom.num2AII(r,c,n)} if \eqn{(1-c)/c < r < 1/c};

and \code{Pdom.num2AI(r,c,n)} otherwise.

\code{Pdom.num2B(r,c,n)} combines these functions in Case B: \eqn{c \in (1/4,(3-\sqrt{5})/2)}.
Due to the symmetry in the PE proximity regions,
we use \code{Pdom.num2Bsym(r,c,n)} for \code{c} in
\eqn{((\sqrt{5}-1)/2,3/4)} with the same auxiliary functions

\code{Pdom.num2AIV(r,1-c,n)} if \eqn{ 1< r < 1/c};

\code{Pdom.num2BIII(r,1-c,n)} if \eqn{1/c < r < c/(1-c)};

\code{Pdom.num2AII(r,1-c,n)} if \eqn{c/(1-c) < r < 1/(1-c)};

and \code{Pdom.num2AI(r,1-c,n)} otherwise.
}

\section{Case C - \eqn{c \in (0,1/4)}}{


In Case C, we compute \eqn{P(\gamma=2)} with

\code{Pdom.num2AIV(r,c,n)} if \eqn{1< r < 1/(1-c)};

\code{Pdom.num2BIII(r,c,n)} if \eqn{1/(1-c) < r < (1-\sqrt{1-4 c})/(2 c)};

\code{Pdom.num2CIV(r,c,n)} if \eqn{(1-\sqrt{1-4 c})/(2 c) < r < (1+\sqrt{1-4 c})/(2 c)};

\code{Pdom.num2BIII(r,c,n)} if \eqn{(1+\sqrt{1-4 c})/(2 c) < r <1/(1-c)};

\code{Pdom.num2AII(r,c,n)} if \eqn{1/(1-c) < r < 1/c};

and \code{Pdom.num2AI(r,c,n)} otherwise.

\code{Pdom.num2C(r,c,n)} combines these functions in Case C: \eqn{c \in (0,1/4)}.
Due to the symmetry in the PE proximity regions,
we use \code{Pdom.num2Csym(r,c,n)} for \eqn{c \in (3/4,1)}
with the same auxiliary functions

\code{Pdom.num2AIV(r,1-c,n)} if \eqn{1< r < 1/c};

\code{Pdom.num2BIII(r,1-c,n)} if \eqn{1/c < r < (1-\sqrt{1-4(1-c)})/(2(1-c))};

\code{Pdom.num2CIV(r,1-c,n)} if \eqn{(1-\sqrt{1-4(1-c)})/(2(1-c)) < r < (1+\sqrt{1-4(1-c)})/(2(1-c))};

\code{Pdom.num2BIII(r,1-c,n)} if \eqn{(1+\sqrt{1-4(1-c)})/(2(1-c)) < r < c/(1-c)};

\code{Pdom.num2AII(r,1-c,n)} if \eqn{c/(1-c)< r < 1/(1-c)};

and \code{Pdom.num2AI(r,1-c,n)} otherwise.

Combining Cases A, B, and C, we get our main function \code{Pdom.num2PE1D} which computes \eqn{P(\gamma=2)}
for any (\code{r,c}) in its domain.
}

\examples{
#Examples for the main function Pdom.num2PE1D
r<-2
c<-.5

Pdom.num2PE1D(r,c,n=10)
Pdom.num2PE1D(r=1.5,c=1/1.5,n=100)

}
\seealso{
\code{\link{Pdom.num2PEtri}} and  \code{\link{Pdom.num2PE1Dasy}}
}
\author{
Elvan Ceyhan
}
