% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefy.R
\name{aor}
\alias{aor}
\alias{aor.data.frame}
\alias{plot.AOR}
\title{Calculate Abundance-occupancy_relationship}
\usage{
aor(otutab, ...)

\method{aor}{data.frame}(
  otutab,
  top_r = 0.7,
  ocup_n = ceiling(0.8 * ncol(otutab)),
  special_n = ceiling(0.1 * ncol(otutab)),
  ...
)

\method{plot}{AOR}(x, ...)
}
\arguments{
\item{otutab}{otutab}

\item{...}{add}

\item{top_r}{percentage of top relative abundance}

\item{ocup_n}{percentage of top occupied}

\item{special_n}{how many occupancy define as specialists}

\item{x}{AOR object}
}
\value{
AOR

ggplot
}
\description{
Calculate Abundance-occupancy_relationship

Plot a AOR
}
\examples{
data(otutab, package = "pcutils")
aor(otutab) -> AOR
plot(AOR)
}
\references{
Barberán, A., Bates, S. T., Casamayor, E. & Fierer, N. (2012) Using network analysis to explore co-occurrence patterns in soil microbial communities.
}
