% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtaxonkit.R
\name{name_or_id2df}
\alias{name_or_id2df}
\title{Transfer taxon name or taxid to the lineage dataframe}
\usage{
name_or_id2df(
  name_or_id,
  mode = "name",
  add_prefix = TRUE,
  fill_miss_rank = TRUE,
  data_dir = NULL
)
}
\arguments{
\item{name_or_id}{name or taxid}

\item{mode}{"id" or "name"}

\item{add_prefix}{add_prefix}

\item{fill_miss_rank}{fill_miss_rank}

\item{data_dir}{directory containing nodes.dmp and names.dmp (default "/Users/asa/.taxonkit")}
}
\value{
dataframe
}
\description{
Transfer taxon name or taxid to the lineage dataframe
}
\examples{
\dontrun{
name_or_id2df(c("Homo sapiens", "Akkermansia muciniphila ATCC BAA-835"))
}
}
\seealso{
Other Rtaxonkit: 
\code{\link{check_taxonkit}()},
\code{\link{download_taxonkit_dataset}()},
\code{\link{install_taxonkit}()},
\code{\link{taxonkit_filter}()},
\code{\link{taxonkit_lca}()},
\code{\link{taxonkit_lineage}()},
\code{\link{taxonkit_list}()},
\code{\link{taxonkit_name2taxid}()},
\code{\link{taxonkit_reformat}()}
}
\concept{Rtaxonkit}
